/*
 * Decompiled with CFR 0.152.
 */
package crafttweaker.mc1120.world;

import crafttweaker.api.world.IBiome;
import crafttweaker.api.world.IBiomeType;
import crafttweaker.mc1120.brackets.BracketHandlerBiomeType;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.common.BiomeDictionary;

public class MCBiome
implements IBiome {
    private final Biome biome;

    public MCBiome(Biome biome) {
        this.biome = biome;
    }

    @Override
    public String getId() {
        return this.biome.getRegistryName().toString();
    }

    @Override
    public String getName() {
        return this.biome.field_76791_y;
    }

    @Override
    public boolean getCanRain() {
        return this.biome.func_76738_d();
    }

    @Override
    public boolean isSnowyBiome() {
        return this.biome.func_150559_j();
    }

    @Override
    public boolean getIsHighHumidity() {
        return this.biome.func_76736_e();
    }

    @Override
    public float getSpawningChance() {
        return this.biome.func_76741_f();
    }

    @Override
    public float getBaseHeight() {
        return this.biome.func_185355_j();
    }

    @Override
    public float getRainfall() {
        return this.biome.func_76727_i();
    }

    @Override
    public int getWaterColorMultiplier() {
        return this.biome.getWaterColorMultiplier();
    }

    @Override
    public boolean getIgnorePlayerSpawnSuitability() {
        return this.biome.func_185352_i();
    }

    @Override
    public float getHeightVariation() {
        return this.biome.func_185360_m();
    }

    @Override
    public float getTemperature() {
        return this.biome.func_185353_n();
    }

    @Override
    public List<IBiomeType> getTypes() {
        ArrayList<IBiomeType> types = new ArrayList<IBiomeType>();
        for (BiomeDictionary.Type type : BiomeDictionary.getTypes((Biome)this.biome)) {
            types.add(BracketHandlerBiomeType.getBiomeType(type.getName()));
        }
        return types;
    }

    public Biome getInternal() {
        return this.biome;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MCBiome mcBiome = (MCBiome)o;
        return Objects.equals(this.biome, mcBiome.biome);
    }

    public int hashCode() {
        return Objects.hash(this.biome);
    }
}

