/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.buildinggadgets.common.config.fieldmap;

import com.direwolf20.buildinggadgets.common.config.fieldmap.FieldMapper;
import com.direwolf20.buildinggadgets.common.tools.ReflectionTool;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import java.lang.reflect.Field;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@VisibleForTesting
public final class FieldWrapper {
    private final Object instance;
    private final Field field;
    private final FieldMapper<Object, Object> mapper;
    private Object val;

    public FieldWrapper(@Nonnull Field field, @Nonnull FieldMapper<?, ?> mapper) {
        this(field, mapper, null);
    }

    public FieldWrapper(@Nonnull Field field, @Nonnull FieldMapper<?, ?> mapper, @Nullable Object instance) {
        Preconditions.checkArgument((boolean)ReflectionTool.isInstanceProvidedForField(field, instance), (Object)"Non Static fields must be accessed with an instance! Static fields without! Also watch out for incompatible classes! ");
        Preconditions.checkArgument((boolean)field.getType().isAssignableFrom(mapper.getFieldType()), (Object)("The Mapper must map to an assignableField Type! Mapper has Type " + mapper.getFieldType().getName() + " but at least " + field.getType().getName() + " is required!"));
        this.instance = instance;
        this.field = field;
        this.mapper = mapper;
        this.val = null;
    }

    public <T> T get(Class<T> clazz) throws IllegalAccessException {
        Preconditions.checkArgument((boolean)clazz.isAssignableFrom(this.getMappedType()), (Object)("Attempted to retrieve value of type " + clazz.getName() + " but this wrapper only accepts " + this.mapper.getSyncedType().getName()));
        if (this.val == null) {
            this.val = this.mapper.mapToSync(this.field.get(this.instance));
        }
        Object obj = this.val;
        return (T)obj;
    }

    public <T> void set(T val, Class<T> clazz) throws IllegalAccessException {
        Preconditions.checkArgument((boolean)clazz.isAssignableFrom(this.getMappedType()), (Object)("Attempted to set value of type " + clazz.getName() + " but this wrapper only accepts " + this.mapper.getSyncedType().getName()));
        this.field.set(this.instance, this.mapper.mapToField(val));
    }

    public Class<?> getFieldType() {
        return this.mapper.getFieldType();
    }

    public Class<?> getMappedType() {
        return this.mapper.getSyncedType();
    }
}

