/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.buildinggadgets.common.building.modes;

import com.direwolf20.buildinggadgets.common.building.IPlacementSequence;
import com.direwolf20.buildinggadgets.common.building.IValidatorFactory;
import com.direwolf20.buildinggadgets.common.building.modes.AtopSupportedMode;
import com.direwolf20.buildinggadgets.common.building.placement.Wall;
import com.direwolf20.buildinggadgets.common.tools.GadgetUtils;
import com.direwolf20.buildinggadgets.common.tools.MathTool;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;

public class HorizontalWallMode
extends AtopSupportedMode {
    private static final ResourceLocation NAME = new ResourceLocation("buildinggadgets", "horizontal_wall");

    public HorizontalWallMode(IValidatorFactory validatorFactory) {
        super(validatorFactory);
    }

    @Override
    public IPlacementSequence computeWithTransformed(EntityPlayer player, BlockPos transformed, BlockPos original, EnumFacing sideHit, ItemStack tool) {
        int range = GadgetUtils.getToolRange(tool);
        int radius = MathTool.floorToOdd(range) / 2;
        if (sideHit.func_176740_k().func_176720_b()) {
            return Wall.clickedSide(transformed, sideHit, radius);
        }
        return Wall.extendingFrom(transformed.func_177972_a(sideHit.func_176734_d()), sideHit, EnumFacing.UP, radius, MathTool.isEven(range) ? 1 : 0);
    }

    @Override
    public BlockPos transformAtop(EntityPlayer player, BlockPos hit, EnumFacing sideHit, ItemStack tool) {
        return hit.func_177972_a(sideHit);
    }

    @Override
    public ResourceLocation getRegistryName() {
        return NAME;
    }
}

