/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.brandonscore.client.gui.modulargui.markdown;

import com.brandon3055.brandonscore.client.gui.modulargui.MGuiElementBase;
import com.brandon3055.brandonscore.client.gui.modulargui.markdown.LayoutHelper;
import com.brandon3055.brandonscore.client.gui.modulargui.markdown.MDElementFactory;
import com.brandon3055.brandonscore.client.gui.modulargui.markdown.mdelements.MDElementBase;
import com.brandon3055.brandonscore.client.gui.modulargui.markdown.mdelements.MarkerElement;
import com.brandon3055.brandonscore.client.gui.modulargui.markdown.reader.lib.HAlign;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.function.BiConsumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GlStateManager;

public class MDElementContainer
extends MGuiElementBase<MDElementContainer> {
    private LinkedList<MDElementBase> elements = new LinkedList();
    protected BiConsumer<String, Integer> linkClickCallback = null;
    public MGuiElementBase linkDisplayTarget = this;
    public int linkDisplayZOffset = 600;
    public MDElementFactory lastFactory = null;
    public HAlign defaultAlignment = HAlign.LEFT;
    private MDElementContainer parentContainer = null;

    public MDElementContainer(MGuiElementBase initializer) {
        this.initializeElementData(initializer);
        this.reportYSizeChange = true;
    }

    public MDElementContainer(MGuiElementBase initializer, int xPos, int yPos, int xSize) {
        super(xPos, yPos);
        this.initializeElementData(initializer);
        this.setXSize(xSize);
        this.reportYSizeChange = true;
    }

    public MDElementContainer(MGuiElementBase initializer, int xSize) {
        this.initializeElementData(initializer);
        this.setXSize(xSize);
        this.reportYSizeChange = true;
    }

    @Override
    public void reloadElement() {
        super.reloadElement();
    }

    public void layoutMarkdownElements() {
        LayoutHelper layout = new LayoutHelper(this.getInsetRect().x, this.getInsetRect().y, this.getInsetRect().width);
        ArrayList<MDElementBase> currentLine = new ArrayList<MDElementBase>();
        for (MDElementBase element : this.elements) {
            boolean endOfLine = false;
            if (element instanceof MarkerElement && ((MarkerElement)element).getType() == MarkerElement.Type.NEW_LINE) {
                endOfLine = true;
            }
            element.layoutElement(layout, currentLine);
            if (endOfLine) {
                currentLine.clear();
                continue;
            }
            currentLine.add(element);
        }
        currentLine.clear();
        HAlign currentAlignment = this.defaultAlignment;
        LinkedList<MDElementBase> display = this.getDisplayElements();
        int lineY = this.getInsetRect().y;
        MDElementBase last = display.isEmpty() ? null : display.getLast();
        for (int i = 0; i < display.size(); ++i) {
            boolean newLine;
            MDElementBase element = display.get(i);
            boolean endOfLine = false;
            boolean bl = newLine = element instanceof MarkerElement && ((MarkerElement)element).getType() == MarkerElement.Type.NEW_LINE;
            if (element instanceof MarkerElement && !newLine && element != last) {
                if (((MarkerElement)element).isAlign()) {
                    currentAlignment = ((MarkerElement)element).getAlign();
                }
            } else if (element.yPos() > lineY || last == element || newLine) {
                if (currentAlignment != HAlign.LEFT) {
                    int lineWidth = 0;
                    for (MDElementBase lineElement : currentLine) {
                        lineWidth += lineElement.xSize();
                    }
                    int offset = layout.getWidth() - lineWidth;
                    if (currentAlignment == HAlign.CENTER) {
                        offset /= 2;
                    }
                    for (MDElementBase lineElement : currentLine) {
                        lineElement.translate(offset, 0);
                    }
                }
                lineY = element.yPos();
                endOfLine = true;
            }
            if (endOfLine) {
                currentLine.clear();
            }
            currentLine.add(element);
        }
        this.setYSize(layout.getContainerHeight() + this.getInsets().bottom + this.getInsets().top);
    }

    public void addElement(MDElementBase element) {
        if (!(element instanceof MarkerElement)) {
            this.addChild(element);
        }
        this.elements.add(element);
    }

    public LinkedList<MDElementBase> getElements() {
        return this.elements;
    }

    public void clearContainer() {
        this.toRemove.addAll(this.elements);
        this.elements.clear();
    }

    public LinkedList<MDElementBase> getDisplayElements() {
        LinkedList<MDElementBase> displayElements = new LinkedList<MDElementBase>();
        for (MDElementBase element : this.elements) {
            if (element.hasSubParts) {
                displayElements.addAll(element.subParts);
                continue;
            }
            displayElements.add(element);
        }
        return displayElements;
    }

    @Override
    public boolean onUpdate() {
        return super.onUpdate();
    }

    @Override
    public void renderElement(Minecraft minecraft, int mouseX, int mouseY, float partialTicks) {
        super.renderElement(minecraft, mouseX, mouseY, partialTicks);
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    @Override
    public void ySizeChanged(MGuiElementBase elementChanged) {
        if (elementChanged == this) {
            super.ySizeChanged(elementChanged);
        }
    }

    public void handleLinkClick(String linkURL, int button) {
        if (this.linkClickCallback != null) {
            this.linkClickCallback.accept(linkURL, button);
        }
    }

    public void setLinkClickCallback(BiConsumer<String, Integer> linkClickCallback) {
        this.linkClickCallback = linkClickCallback;
    }

    public void inherit(MDElementContainer parent) {
        this.linkClickCallback = parent.linkClickCallback;
        this.linkDisplayTarget = parent.linkDisplayTarget;
        this.linkDisplayZOffset = parent.linkDisplayZOffset;
        this.parentContainer = parent;
    }

    public MDElementContainer getTopLevelContainer() {
        return this.parentContainer == null ? this : this.parentContainer.getTopLevelContainer();
    }
}

