/*
 * Decompiled with CFR 0.152.
 */
package betterquesting.questing.tasks;

import betterquesting.api.questing.IQuest;
import betterquesting.api2.client.gui.misc.IGuiRect;
import betterquesting.api2.client.gui.panels.IGuiPanel;
import betterquesting.api2.storage.DBEntry;
import betterquesting.api2.utils.ParticipantInfo;
import betterquesting.client.gui2.tasks.PanelTaskLocation;
import betterquesting.core.BetterQuesting;
import betterquesting.questing.tasks.ITaskTickable;
import betterquesting.questing.tasks.factory.FactoryTaskLocation;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.StringUtils;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import org.apache.logging.log4j.Level;

public class TaskLocation
implements ITaskTickable {
    private final Set<UUID> completeUsers = new TreeSet<UUID>();
    public String name = "New Location";
    public String structure = "";
    public String biome = "";
    public int x = 0;
    public int y = 0;
    public int z = 0;
    public int dim = 0;
    public int range = -1;
    public boolean visible = false;
    public boolean hideInfo = false;
    public boolean invert = false;
    public boolean taxiCab = false;

    @Override
    public ResourceLocation getFactoryID() {
        return FactoryTaskLocation.INSTANCE.getRegistryName();
    }

    @Override
    public String getUnlocalisedName() {
        return "bq_standard.task.location";
    }

    @Override
    public boolean isComplete(UUID uuid) {
        return this.completeUsers.contains(uuid);
    }

    @Override
    public void setComplete(UUID uuid) {
        this.completeUsers.add(uuid);
    }

    @Override
    public void resetUser(@Nullable UUID uuid) {
        if (uuid == null) {
            this.completeUsers.clear();
        } else {
            this.completeUsers.remove(uuid);
        }
    }

    @Override
    public void tickTask(@Nonnull ParticipantInfo pInfo, DBEntry<IQuest> quest) {
        if (pInfo.PLAYER.field_70173_aa % 100 == 0) {
            this.internalDetect(pInfo, quest);
        }
    }

    @Override
    public void detect(@Nonnull ParticipantInfo pInfo, DBEntry<IQuest> quest) {
        this.internalDetect(pInfo, quest);
    }

    private void internalDetect(@Nonnull ParticipantInfo pInfo, DBEntry<IQuest> quest) {
        if (!pInfo.PLAYER.func_70089_S() || !(pInfo.PLAYER instanceof EntityPlayerMP)) {
            return;
        }
        EntityPlayerMP playerMP = (EntityPlayerMP)pInfo.PLAYER;
        boolean flag = false;
        if (playerMP.field_71093_bK == this.dim && (this.range <= 0 || this.getDistance((EntityPlayer)playerMP) <= (double)this.range)) {
            if (!StringUtils.func_151246_b((String)this.biome) && !new ResourceLocation(this.biome).equals((Object)playerMP.func_71121_q().func_180494_b(playerMP.func_180425_c()).getRegistryName())) {
                if (!this.invert) {
                    return;
                }
            } else if (!StringUtils.func_151246_b((String)this.structure) && !playerMP.func_71121_q().func_72863_F().func_193413_a(playerMP.field_70170_p, this.structure, playerMP.func_180425_c())) {
                if (!this.invert) {
                    return;
                }
            } else if (this.visible && this.range > 0) {
                Vec3d tPos;
                Vec3d pPos = new Vec3d(playerMP.field_70165_t, playerMP.field_70163_u + (double)playerMP.func_70047_e(), playerMP.field_70161_v);
                RayTraceResult mop = playerMP.field_70170_p.func_147447_a(pPos, tPos = new Vec3d((double)this.x, (double)this.y, (double)this.z), false, true, false);
                if (mop == null || mop.field_72313_a != RayTraceResult.Type.BLOCK) {
                    flag = true;
                }
            } else {
                flag = true;
            }
        }
        if (flag != this.invert) {
            pInfo.ALL_UUIDS.forEach(uuid -> {
                if (!this.isComplete((UUID)uuid)) {
                    this.setComplete((UUID)uuid);
                }
            });
            pInfo.markDirtyParty(Collections.singletonList(quest.getID()));
        }
    }

    private double getDistance(EntityPlayer player) {
        if (!this.taxiCab) {
            return player.func_70011_f((double)this.x, (double)this.y, (double)this.z);
        }
        BlockPos pPos = player.func_180425_c();
        return Math.abs(pPos.func_177958_n() - this.x) + Math.abs(pPos.func_177956_o() - this.y) + Math.abs(pPos.func_177952_p() - this.z);
    }

    @Override
    public NBTTagCompound writeToNBT(NBTTagCompound nbt) {
        nbt.func_74778_a("name", this.name);
        nbt.func_74768_a("posX", this.x);
        nbt.func_74768_a("posY", this.y);
        nbt.func_74768_a("posZ", this.z);
        nbt.func_74768_a("dimension", this.dim);
        nbt.func_74778_a("biome", this.biome);
        nbt.func_74778_a("structure", this.structure);
        nbt.func_74768_a("range", this.range);
        nbt.func_74757_a("visible", this.visible);
        nbt.func_74757_a("hideInfo", this.hideInfo);
        nbt.func_74757_a("invert", this.invert);
        nbt.func_74757_a("taxiCabDist", this.taxiCab);
        return nbt;
    }

    @Override
    public void readFromNBT(NBTTagCompound nbt) {
        this.name = nbt.func_74779_i("name");
        this.x = nbt.func_74762_e("posX");
        this.y = nbt.func_74762_e("posY");
        this.z = nbt.func_74762_e("posZ");
        this.dim = nbt.func_74762_e("dimension");
        this.biome = nbt.func_74779_i("biome");
        this.structure = nbt.func_74779_i("structure");
        this.range = nbt.func_74762_e("range");
        this.visible = nbt.func_74767_n("visible");
        this.hideInfo = nbt.func_74767_n("hideInfo");
        this.invert = nbt.func_74767_n("invert") || nbt.func_74767_n("invertDistance");
        this.taxiCab = nbt.func_74767_n("taxiCabDist");
    }

    @Override
    public NBTTagCompound writeProgressToNBT(NBTTagCompound nbt, @Nullable List<UUID> users) {
        NBTTagList jArray = new NBTTagList();
        this.completeUsers.forEach(uuid -> {
            if (users == null || users.contains(uuid)) {
                jArray.func_74742_a((NBTBase)new NBTTagString(uuid.toString()));
            }
        });
        nbt.func_74782_a("completeUsers", (NBTBase)jArray);
        return nbt;
    }

    @Override
    public void readProgressFromNBT(NBTTagCompound nbt, boolean merge) {
        if (!merge) {
            this.completeUsers.clear();
        }
        NBTTagList cList = nbt.func_150295_c("completeUsers", 8);
        for (int i = 0; i < cList.func_74745_c(); ++i) {
            try {
                this.completeUsers.add(UUID.fromString(cList.func_150307_f(i)));
                continue;
            }
            catch (Exception e) {
                BetterQuesting.logger.log(Level.ERROR, "Unable to load UUID for task", (Throwable)e);
            }
        }
    }

    @Override
    public IGuiPanel getTaskGui(IGuiRect rect, DBEntry<IQuest> quest) {
        return new PanelTaskLocation(rect, this);
    }

    @Override
    public GuiScreen getTaskEditor(GuiScreen parent, DBEntry<IQuest> quest) {
        return null;
    }

    @Override
    public List<String> getTextForSearch() {
        return Collections.singletonList(this.name);
    }
}

