/*
 * Decompiled with CFR 0.152.
 */
package betterquesting.importers.hqm;

import betterquesting.api.placeholders.PlaceholderConverter;
import betterquesting.api.utils.BigItemStack;
import betterquesting.api.utils.JsonHelper;
import betterquesting.core.BetterQuesting;
import betterquesting.importers.hqm.converters.items.HQMItem;
import betterquesting.importers.hqm.converters.items.HQMItemBag;
import betterquesting.importers.hqm.converters.items.HQMItemHeart;
import com.google.gson.JsonObject;
import java.util.HashMap;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.JsonToNBT;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.oredict.OreDictionary;
import org.apache.logging.log4j.Level;

public class HQMUtilities {
    private static HashMap<String, HQMItem> itemConverters = new HashMap();

    public static BigItemStack HQMStackT1(JsonObject json) {
        HQMItem hqm;
        String iID = JsonHelper.GetString(json, "id", "minecraft:stone");
        Item item = (Item)Item.field_150901_e.func_82594_a((Object)new ResourceLocation(iID));
        int amount = JsonHelper.GetNumber(json, "amount", 1).intValue();
        int damage = JsonHelper.GetNumber(json, "damage", 0).intValue();
        NBTTagCompound tags = null;
        if (json.has("nbt")) {
            try {
                String rawNbt = json.get("nbt").toString();
                rawNbt = rawNbt.replaceFirst("\"", "");
                rawNbt = rawNbt.substring(0, rawNbt.length() - 1);
                rawNbt = rawNbt.replace(":\\\"", ":\"");
                rawNbt = rawNbt.replace("\\\",", "\",");
                rawNbt = rawNbt.replace("\\\"}", "\"}");
                rawNbt = rawNbt.replace("\\\"]", "\"]");
                rawNbt = rawNbt.replace("[\\\"", "[\"");
                rawNbt = rawNbt.replace("\\n", "\n");
                tags = JsonToNBT.func_180713_a((String)rawNbt);
            }
            catch (Exception e) {
                BetterQuesting.logger.log(Level.ERROR, "Unable to convert HQM NBT data. This is likely a HQM Gson/Json formatting issue", (Throwable)e);
            }
        }
        if ((hqm = itemConverters.get(iID.toLowerCase())) != null) {
            return hqm.convertItem(damage, amount, tags);
        }
        return PlaceholderConverter.convertItem(item, iID, amount, damage, "", tags);
    }

    public static BigItemStack HQMStackT2(JsonObject rJson) {
        int[] oreId;
        HQMItem hqm;
        JsonObject json = JsonHelper.GetObject(rJson, "item");
        String iID = JsonHelper.GetString(json, "id", "minecraft:stone");
        Item item = (Item)Item.field_150901_e.func_82594_a((Object)new ResourceLocation(iID));
        int amount = JsonHelper.GetNumber(rJson, "required", 1).intValue();
        int damage = JsonHelper.GetNumber(json, "damage", 0).intValue();
        boolean oreDict = JsonHelper.GetString(rJson, "precision", "").equalsIgnoreCase("ORE_DICTIONARY");
        NBTTagCompound tags = null;
        if (json.has("nbt")) {
            try {
                String rawNbt = json.get("nbt").toString();
                rawNbt = rawNbt.replaceFirst("\"", "");
                rawNbt = rawNbt.substring(0, rawNbt.length() - 1);
                rawNbt = rawNbt.replace(":\\\"", ":\"");
                rawNbt = rawNbt.replace("\\\",", "\",");
                rawNbt = rawNbt.replace("\\\"}", "\"}");
                rawNbt = rawNbt.replace("\\\"]", "\"]");
                rawNbt = rawNbt.replace("[\\\"", "[\"");
                rawNbt = rawNbt.replace("\\n", "\n");
                tags = JsonToNBT.func_180713_a((String)rawNbt);
            }
            catch (Exception e) {
                BetterQuesting.logger.log(Level.ERROR, "Unable to convert HQM NBT data. This is likely a HQM Gson/Json formatting issue", (Throwable)e);
            }
        }
        if ((hqm = itemConverters.get(iID.toLowerCase())) != null) {
            return hqm.convertItem(damage, amount, tags);
        }
        BigItemStack stack = PlaceholderConverter.convertItem(item, iID, amount, damage, "", tags);
        if (oreDict && item != null && (oreId = OreDictionary.getOreIDs((ItemStack)stack.getBaseStack())).length > 0) {
            stack.setOreDict(OreDictionary.getOreName((int)oreId[0]));
        }
        return stack;
    }

    public static FluidStack HQMStackT3(JsonObject json) {
        String name = JsonHelper.GetString(json, "fluid", "water");
        Fluid fluid = FluidRegistry.getFluid((String)name);
        int amount = JsonHelper.GetNumber(json, "required", 1000).intValue();
        return PlaceholderConverter.convertFluid(fluid, name, amount, null);
    }

    static {
        itemConverters.put("hardcorequesting:hearts", new HQMItemHeart());
        itemConverters.put("hardcorequesting:bags", new HQMItemBag());
    }
}

