/*
 * Decompiled with CFR 0.152.
 */
package betterquesting.commands;

import betterquesting.api.network.QuestingPacket;
import betterquesting.api.questing.IQuest;
import betterquesting.api2.storage.DBEntry;
import betterquesting.network.PacketSender;
import betterquesting.questing.QuestDatabase;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nonnull;
import net.minecraft.command.CommandBase;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;

public class BQ_CopyProgress
extends CommandBase {
    private static final ResourceLocation ID_NAME = new ResourceLocation("betterquesting:quest_sync");
    private static final String COMMAND_NAME = "bq_copyquests";
    private static final String COMMAND_USAGE = "/bq_copyquests [toPlayer] <fromPlayer>";

    public int func_82362_a() {
        return 2;
    }

    @Nonnull
    public String func_71517_b() {
        return COMMAND_NAME;
    }

    @Nonnull
    public String func_71518_a(@Nonnull ICommandSender sender) {
        return COMMAND_USAGE;
    }

    @Nonnull
    public List<String> func_71514_a() {
        return Collections.singletonList(this.func_71517_b());
    }

    public void func_184881_a(@Nonnull MinecraftServer server, @Nonnull ICommandSender sender, @Nonnull String[] args) throws CommandException {
        if (sender instanceof EntityPlayer) {
            if (args.length == 0 || args.length > 2) {
                throw new CommandException(COMMAND_USAGE, new Object[0]);
            }
            UUID ownUUID = args.length == 2 ? BQ_CopyProgress.func_184888_a((MinecraftServer)server, (ICommandSender)sender, (String)args[1]).getPersistentID() : ((EntityPlayer)sender).getPersistentID();
            EntityPlayerMP addPlayer = BQ_CopyProgress.func_184888_a((MinecraftServer)server, (ICommandSender)sender, (String)args[0]);
            UUID addUUID = addPlayer.getPersistentID();
            long current = System.currentTimeMillis();
            int questsCompleted = 0;
            for (DBEntry questDBEntry : QuestDatabase.INSTANCE.getEntries()) {
                IQuest quest = (IQuest)questDBEntry.getValue();
                if (!quest.isComplete(ownUUID) || quest.isComplete(addUUID)) continue;
                quest.setComplete(addUUID, current);
                PacketSender.INSTANCE.sendToPlayers(new QuestingPacket(ID_NAME, quest.getCompletionInfo(addUUID)), addPlayer);
                ++questsCompleted;
            }
            sender.func_145747_a((ITextComponent)new TextComponentString("Completed " + questsCompleted + " for " + addPlayer.getDisplayNameString()));
        }
    }
}

