/*
 * Decompiled with CFR 0.152.
 */
package betterquesting.client.importers;

import betterquesting.api.questing.IQuest;
import betterquesting.api.questing.IQuestDatabase;
import betterquesting.api2.storage.DBEntry;
import betterquesting.api2.storage.SimpleDatabase;
import betterquesting.questing.QuestInstance;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;

public class ImportedQuests
extends SimpleDatabase<IQuest>
implements IQuestDatabase {
    @Override
    public IQuest createNew(int id) {
        return this.add(id, new QuestInstance()).getValue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<DBEntry<IQuest>> bulkLookup(int ... ids) {
        if (ids == null || ids.length <= 0) {
            return Collections.emptyList();
        }
        ArrayList<DBEntry<IQuest>> values = new ArrayList<DBEntry<IQuest>>();
        ImportedQuests importedQuests = this;
        synchronized (importedQuests) {
            for (int i : ids) {
                IQuest v = (IQuest)this.getValue(i);
                if (v == null) continue;
                values.add(new DBEntry<IQuest>(i, v));
            }
        }
        return values;
    }

    @Override
    public NBTTagList writeToNBT(NBTTagList nbt, List<Integer> subset) {
        for (DBEntry entry : this.getEntries()) {
            if (subset != null && !subset.contains(entry.getID())) continue;
            NBTTagCompound jq = new NBTTagCompound();
            ((IQuest)entry.getValue()).writeToNBT(jq);
            jq.func_74768_a("questID", entry.getID());
            nbt.func_74742_a((NBTBase)jq);
        }
        return nbt;
    }

    @Override
    public void readFromNBT(NBTTagList nbt, boolean merge) {
        if (!merge) {
            this.reset();
        }
        for (int i = 0; i < nbt.func_74745_c(); ++i) {
            int qID;
            NBTTagCompound qTag = nbt.func_150305_b(i);
            int n = qID = qTag.func_150297_b("questID", 99) ? qTag.func_74762_e("questID") : -1;
            if (qID < 0) continue;
            IQuest quest = (IQuest)this.getValue(qID);
            quest = quest != null ? quest : this.createNew(qID);
            quest.readFromNBT(qTag);
        }
    }

    @Override
    public NBTTagList writeProgressToNBT(NBTTagList nbt, @Nullable List<UUID> users) {
        return nbt;
    }

    @Override
    public void readProgressFromNBT(NBTTagList nbt, boolean merge) {
    }
}

