/*
 * Decompiled with CFR 0.152.
 */
package betterquesting.client.gui2.tasks;

import betterquesting.api.api.QuestingAPI;
import betterquesting.api2.client.gui.misc.GuiAlign;
import betterquesting.api2.client.gui.misc.GuiRectangle;
import betterquesting.api2.client.gui.misc.GuiTransform;
import betterquesting.api2.client.gui.misc.IGuiRect;
import betterquesting.api2.client.gui.panels.CanvasMinimum;
import betterquesting.api2.client.gui.panels.content.PanelFluidSlot;
import betterquesting.api2.client.gui.panels.content.PanelTextBox;
import betterquesting.api2.client.gui.themes.presets.PresetColor;
import betterquesting.api2.utils.QuestTranslation;
import betterquesting.core.BetterQuesting;
import betterquesting.questing.tasks.TaskFluid;
import java.util.UUID;
import mezz.jei.Internal;
import mezz.jei.api.recipe.IFocus;
import mezz.jei.gui.Focus;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.common.Optional;

public class PanelTaskFluid
extends CanvasMinimum {
    private final IGuiRect initialRect;
    private final TaskFluid task;

    public PanelTaskFluid(IGuiRect rect, TaskFluid task) {
        super(rect);
        this.initialRect = rect;
        this.task = task;
    }

    @Override
    public void initPanel() {
        super.initPanel();
        int listW = this.initialRect.getWidth();
        UUID uuid = QuestingAPI.getQuestingUUID((EntityPlayer)Minecraft.func_71410_x().field_71439_g);
        int[] progress = this.task.getUsersProgress(uuid);
        boolean isComplete = this.task.isComplete(uuid);
        String sCon = (this.task.consume ? TextFormatting.RED : TextFormatting.GREEN) + QuestTranslation.translate(this.task.consume ? "gui.yes" : "gui.no", new Object[0]);
        this.addPanel(new PanelTextBox(new GuiTransform(GuiAlign.TOP_EDGE, 0, 0, listW, 12, 0), QuestTranslation.translate("bq_standard.btn.consume", sCon)).setColor(PresetColor.TEXT_MAIN.getColor()));
        for (int i = 0; i < this.task.requiredFluids.size(); ++i) {
            FluidStack stack = (FluidStack)this.task.requiredFluids.get(i);
            PanelFluidSlot slot = new PanelFluidSlot((IGuiRect)new GuiRectangle(0, i * 28 + 12, 28, 28, 0), -1, stack);
            if (BetterQuesting.hasJEI) {
                slot.setCallback(this::lookupRecipe);
            }
            this.addPanel(slot);
            StringBuilder sb = new StringBuilder();
            sb.append(stack.getLocalizedName()).append("\n");
            sb.append(progress[i]).append("/").append(stack.amount).append("mB\n");
            if (progress[i] >= stack.amount || isComplete) {
                sb.append(TextFormatting.GREEN).append(QuestTranslation.translate("betterquesting.tooltip.complete", new Object[0]));
            } else {
                sb.append(TextFormatting.RED).append(QuestTranslation.translate("betterquesting.tooltip.incomplete", new Object[0]));
            }
            PanelTextBox text = new PanelTextBox(new GuiRectangle(36, i * 28 + 12, listW - 36, 28, 0), sb.toString());
            text.setColor(PresetColor.TEXT_MAIN.getColor());
            this.addPanel(text);
        }
        this.recalculateSizes();
    }

    @Optional.Method(modid="jei")
    private void lookupRecipe(FluidStack fluid) {
        if (fluid == null || Internal.getRuntime() == null) {
            return;
        }
        Internal.getRuntime().getRecipesGui().show((IFocus)new Focus(IFocus.Mode.OUTPUT, (Object)fluid));
    }
}

