/*
 * Decompiled with CFR 0.152.
 */
package betterquesting.client.gui2.tasks;

import betterquesting.api.api.QuestingAPI;
import betterquesting.api.questing.IQuest;
import betterquesting.api2.client.gui.controls.PanelButton;
import betterquesting.api2.client.gui.misc.GuiAlign;
import betterquesting.api2.client.gui.misc.GuiTransform;
import betterquesting.api2.client.gui.misc.IGuiRect;
import betterquesting.api2.client.gui.panels.CanvasMinimum;
import betterquesting.api2.client.gui.resources.colors.GuiColorStatic;
import betterquesting.api2.client.gui.themes.presets.PresetIcon;
import betterquesting.api2.storage.DBEntry;
import betterquesting.network.handlers.NetTaskCheckbox;
import betterquesting.questing.tasks.TaskCheckbox;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.player.EntityPlayer;

public class PanelTaskCheckbox
extends CanvasMinimum {
    private final IGuiRect initialRect;
    private final DBEntry<IQuest> quest;
    private final TaskCheckbox task;

    public PanelTaskCheckbox(IGuiRect rect, DBEntry<IQuest> quest, TaskCheckbox task) {
        super(rect);
        this.initialRect = rect;
        this.quest = quest;
        this.task = task;
    }

    @Override
    public void initPanel() {
        super.initPanel();
        boolean isComplete = this.task.isComplete(QuestingAPI.getQuestingUUID((EntityPlayer)Minecraft.func_71410_x().field_71439_g));
        final int questID = this.quest.getID();
        final int taskID = this.quest.getValue().getTasks().getID(this.task);
        PanelButton btnCheck = new PanelButton(new GuiTransform(GuiAlign.TOP_LEFT, (this.initialRect.getWidth() - 32) / 2, 0, 32, 32, 0), -1, ""){

            @Override
            public void onButtonClick() {
                this.setIcon(PresetIcon.ICON_TICK.getTexture(), new GuiColorStatic(-16711936), 4);
                this.setActive(false);
                NetTaskCheckbox.requestClick(questID, taskID);
            }
        };
        btnCheck.setIcon(isComplete ? PresetIcon.ICON_TICK.getTexture() : PresetIcon.ICON_CROSS.getTexture(), new GuiColorStatic(isComplete ? -16711936 : -65536), 4);
        btnCheck.setActive(!isComplete);
        this.addPanel(btnCheck);
        this.recalculateSizes();
    }
}

