/*
 * Decompiled with CFR 0.152.
 */
package betterquesting.client.gui2.editors.tasks;

import betterquesting.api.api.ApiReference;
import betterquesting.api.api.QuestingAPI;
import betterquesting.api.client.gui.misc.IVolatileScreen;
import betterquesting.api.network.QuestingPacket;
import betterquesting.api.questing.IQuest;
import betterquesting.api2.client.gui.GuiScreenCanvas;
import betterquesting.api2.client.gui.controls.PanelButton;
import betterquesting.api2.client.gui.controls.PanelTextField;
import betterquesting.api2.client.gui.controls.filters.FieldFilterNumber;
import betterquesting.api2.client.gui.controls.io.ValueFuncIO;
import betterquesting.api2.client.gui.misc.GuiAlign;
import betterquesting.api2.client.gui.misc.GuiPadding;
import betterquesting.api2.client.gui.misc.GuiTransform;
import betterquesting.api2.client.gui.panels.CanvasTextured;
import betterquesting.api2.client.gui.panels.content.PanelEntityPreview;
import betterquesting.api2.client.gui.panels.content.PanelTextBox;
import betterquesting.api2.client.gui.themes.gui_args.GArgsCallback;
import betterquesting.api2.client.gui.themes.gui_args.GArgsNBT;
import betterquesting.api2.client.gui.themes.presets.PresetColor;
import betterquesting.api2.client.gui.themes.presets.PresetGUIs;
import betterquesting.api2.client.gui.themes.presets.PresetTexture;
import betterquesting.api2.storage.DBEntry;
import betterquesting.api2.utils.QuestTranslation;
import betterquesting.questing.tasks.TaskMeeting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.passive.EntityVillager;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import org.lwjgl.input.Keyboard;

public class GuiEditTaskMeeting
extends GuiScreenCanvas
implements IVolatileScreen {
    private final DBEntry<IQuest> quest;
    private final TaskMeeting task;
    private static final ResourceLocation QUEST_EDIT = new ResourceLocation("betterquesting:quest_edit");

    public GuiEditTaskMeeting(GuiScreen parent, DBEntry<IQuest> quest, TaskMeeting task) {
        super(parent);
        this.quest = quest;
        this.task = task;
    }

    @Override
    public void initPanel() {
        Entity target;
        super.initPanel();
        Keyboard.enableRepeatEvents((boolean)true);
        CanvasTextured cvBackground = new CanvasTextured(new GuiTransform(), PresetTexture.PANEL_MAIN.getTexture());
        this.addPanel(cvBackground);
        cvBackground.addPanel(new PanelTextBox(new GuiTransform(GuiAlign.TOP_EDGE, new GuiPadding(16, 16, 16, -32), 0), QuestTranslation.translate("bq_standard.title.edit_meeting", new Object[0])).setAlignment(1).setColor(PresetColor.TEXT_HEADER.getColor()));
        ResourceLocation targetRes = new ResourceLocation(this.task.idName);
        if (EntityList.func_180125_b((ResourceLocation)targetRes)) {
            target = EntityList.func_188429_b((ResourceLocation)targetRes, (World)Minecraft.func_71410_x().field_71441_e);
            if (target != null) {
                target.func_70020_e(this.task.targetTags);
            }
        } else {
            target = null;
        }
        this.addPanel(new PanelEntityPreview(new GuiTransform(GuiAlign.HALF_TOP, new GuiPadding(16, 32, 16, 0), 0), target).setRotationDriven(new ValueFuncIO<Float>(() -> Float.valueOf(15.0f)), new ValueFuncIO<Float>(() -> Float.valueOf((float)((double)(Minecraft.func_71386_F() % 30000L) / 30000.0 * 360.0)))));
        cvBackground.addPanel(new PanelTextBox(new GuiTransform(GuiAlign.MID_CENTER, -100, 4, 96, 12, 0), QuestTranslation.translate("bq_standard.gui.amount", new Object[0])).setAlignment(2).setColor(PresetColor.TEXT_MAIN.getColor()));
        cvBackground.addPanel(new PanelTextField<Integer>(new GuiTransform(GuiAlign.MID_CENTER, 0, 0, 100, 16, 0), "" + this.task.amount, FieldFilterNumber.INT).setCallback(value -> {
            this.task.amount = value;
        }));
        final GuiEditTaskMeeting screenRef = this;
        cvBackground.addPanel(new PanelButton(new GuiTransform(GuiAlign.MID_CENTER, -100, 16, 200, 16, 0), -1, QuestTranslation.translate("bq_standard.btn.select_mob", new Object[0])){

            @Override
            public void onButtonClick() {
                GuiEditTaskMeeting.this.field_146297_k.func_147108_a(QuestingAPI.getAPI(ApiReference.THEME_REG).getGui(PresetGUIs.EDIT_ENTITY, new GArgsCallback<Entity>(screenRef, target, value -> {
                    Entity tmp = value != null ? value : new EntityVillager((World)GuiEditTaskMeeting.this.field_146297_k.field_71441_e);
                    ResourceLocation res = EntityList.func_191306_a(tmp.getClass());
                    ((GuiEditTaskMeeting)GuiEditTaskMeeting.this).task.idName = res != null ? res.toString() : "minecraft:villager";
                    ((GuiEditTaskMeeting)GuiEditTaskMeeting.this).task.targetTags = new NBTTagCompound();
                    tmp.func_70039_c(((GuiEditTaskMeeting)GuiEditTaskMeeting.this).task.targetTags);
                })));
            }
        });
        cvBackground.addPanel(new PanelButton(new GuiTransform(GuiAlign.MID_CENTER, -100, 32, 200, 16, 0), -1, QuestTranslation.translate("betterquesting.btn.advanced", new Object[0])){

            @Override
            public void onButtonClick() {
                GuiEditTaskMeeting.this.field_146297_k.func_147108_a(QuestingAPI.getAPI(ApiReference.THEME_REG).getGui(PresetGUIs.EDIT_NBT, new GArgsNBT<NBTTagCompound>(screenRef, GuiEditTaskMeeting.this.task.writeToNBT(new NBTTagCompound()), GuiEditTaskMeeting.this.task::readFromNBT, null)));
            }
        });
        cvBackground.addPanel(new PanelButton(new GuiTransform(GuiAlign.BOTTOM_CENTER, -100, -16, 200, 16, 0), -1, QuestTranslation.translate("gui.back", new Object[0])){

            @Override
            public void onButtonClick() {
                GuiEditTaskMeeting.this.sendChanges();
                GuiEditTaskMeeting.this.field_146297_k.func_147108_a(GuiEditTaskMeeting.this.parent);
            }
        });
    }

    private void sendChanges() {
        NBTTagCompound payload = new NBTTagCompound();
        NBTTagList dataList = new NBTTagList();
        NBTTagCompound entry = new NBTTagCompound();
        entry.func_74768_a("questID", this.quest.getID());
        entry.func_74782_a("config", (NBTBase)this.quest.getValue().writeToNBT(new NBTTagCompound()));
        dataList.func_74742_a((NBTBase)entry);
        payload.func_74782_a("data", (NBTBase)dataList);
        payload.func_74768_a("action", 0);
        QuestingAPI.getAPI(ApiReference.PACKET_SENDER).sendToServer(new QuestingPacket(QUEST_EDIT, payload));
    }
}

