/*
 * Decompiled with CFR 0.152.
 */
package betterquesting.client.gui2.editors;

import betterquesting.api.client.gui.misc.INeedsRefresh;
import betterquesting.api.client.gui.misc.IVolatileScreen;
import betterquesting.api.enums.EnumLogic;
import betterquesting.api.enums.EnumQuestVisibility;
import betterquesting.api.properties.NativeProps;
import betterquesting.api.questing.IQuest;
import betterquesting.api2.client.gui.GuiScreenCanvas;
import betterquesting.api2.client.gui.controls.IPanelButton;
import betterquesting.api2.client.gui.controls.PanelButton;
import betterquesting.api2.client.gui.controls.PanelTextField;
import betterquesting.api2.client.gui.controls.filters.FieldFilterString;
import betterquesting.api2.client.gui.events.IPEventListener;
import betterquesting.api2.client.gui.events.PEventBroadcaster;
import betterquesting.api2.client.gui.events.PanelEvent;
import betterquesting.api2.client.gui.events.types.PEventButton;
import betterquesting.api2.client.gui.misc.GuiAlign;
import betterquesting.api2.client.gui.misc.GuiPadding;
import betterquesting.api2.client.gui.misc.GuiTransform;
import betterquesting.api2.client.gui.panels.CanvasTextured;
import betterquesting.api2.client.gui.panels.content.PanelTextBox;
import betterquesting.api2.client.gui.themes.presets.PresetColor;
import betterquesting.api2.client.gui.themes.presets.PresetTexture;
import betterquesting.api2.utils.QuestTranslation;
import betterquesting.client.gui2.editors.GuiPrerequisiteEditor;
import betterquesting.client.gui2.editors.GuiRewardEditor;
import betterquesting.client.gui2.editors.GuiTaskEditor;
import betterquesting.client.gui2.editors.GuiTextEditor;
import betterquesting.client.gui2.editors.nbt.GuiItemSelection;
import betterquesting.client.gui2.editors.nbt.GuiNbtEditor;
import betterquesting.network.handlers.NetQuestEdit;
import betterquesting.questing.QuestDatabase;
import java.util.Collections;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import org.lwjgl.input.Keyboard;

public class GuiQuestEditor
extends GuiScreenCanvas
implements IPEventListener,
IVolatileScreen,
INeedsRefresh {
    private final int questID;
    private IQuest quest;
    private PanelTextBox pnTitle;
    private PanelTextField<String> flName;
    private PanelTextField<String> flDesc;
    private PanelButton btnLogic;
    private PanelButton btnVis;

    public GuiQuestEditor(GuiScreen parent, int questID) {
        super(parent);
        this.questID = questID;
    }

    @Override
    public void refreshGui() {
        this.quest = (IQuest)QuestDatabase.INSTANCE.getValue(this.questID);
        if (this.quest == null) {
            this.field_146297_k.func_147108_a(this.parent);
        } else {
            this.pnTitle.setText(QuestTranslation.translate("betterquesting.title.edit_quest", QuestTranslation.translate(this.quest.getProperty(NativeProps.NAME), new Object[0])));
            if (!this.flName.isFocused()) {
                this.flName.setText(this.quest.getProperty(NativeProps.NAME));
            }
            if (!this.flDesc.isFocused()) {
                this.flDesc.setText(this.quest.getProperty(NativeProps.DESC));
            }
            this.btnLogic.setText(QuestTranslation.translate("betterquesting.btn.logic", new Object[0]) + ": " + (Object)((Object)this.quest.getProperty(NativeProps.LOGIC_QUEST)));
            this.btnVis.setText(QuestTranslation.translate("betterquesting.btn.show", new Object[0]) + ": " + (Object)((Object)this.quest.getProperty(NativeProps.VISIBILITY)));
            this.btnVis.setTooltip(Collections.singletonList(QuestTranslation.translate(String.format("betterquesting.btn.show.%s", this.quest.getProperty(NativeProps.VISIBILITY).toString().toLowerCase()), new Object[0])));
        }
    }

    @Override
    public void initPanel() {
        super.initPanel();
        this.quest = (IQuest)QuestDatabase.INSTANCE.getValue(this.questID);
        if (this.quest == null) {
            this.field_146297_k.func_147108_a(this.parent);
            return;
        }
        PEventBroadcaster.INSTANCE.register(this, PEventButton.class);
        Keyboard.enableRepeatEvents((boolean)true);
        CanvasTextured cvBackground = new CanvasTextured(new GuiTransform(GuiAlign.FULL_BOX, new GuiPadding(0, 0, 0, 0), 0), PresetTexture.PANEL_MAIN.getTexture());
        this.addPanel(cvBackground);
        this.pnTitle = new PanelTextBox(new GuiTransform(GuiAlign.TOP_EDGE, new GuiPadding(0, 16, 0, -32), 0), QuestTranslation.translate("betterquesting.title.edit_quest", QuestTranslation.translate(this.quest.getProperty(NativeProps.NAME), new Object[0]))).setAlignment(1);
        this.pnTitle.setColor(PresetColor.TEXT_HEADER.getColor());
        cvBackground.addPanel(this.pnTitle);
        cvBackground.addPanel(new PanelButton(new GuiTransform(GuiAlign.BOTTOM_CENTER, -100, -16, 200, 16, 0), 0, QuestTranslation.translate("gui.back", new Object[0])));
        PanelTextBox pnName = new PanelTextBox(new GuiTransform(GuiAlign.MID_CENTER, -100, -60, 200, 12, 0), QuestTranslation.translate("betterquesting.gui.name", new Object[0]));
        pnName.setColor(PresetColor.TEXT_MAIN.getColor());
        cvBackground.addPanel(pnName);
        this.flName = new PanelTextField<String>(new GuiTransform(GuiAlign.MID_CENTER, -100, -48, 200, 16, 0), this.quest.getProperty(NativeProps.NAME), FieldFilterString.INSTANCE);
        this.flName.setMaxLength(Integer.MAX_VALUE);
        cvBackground.addPanel(this.flName);
        PanelTextBox pnDesc = new PanelTextBox(new GuiTransform(GuiAlign.MID_CENTER, -100, -28, 200, 12, 0), QuestTranslation.translate("betterquesting.gui.description", new Object[0]));
        pnDesc.setColor(PresetColor.TEXT_MAIN.getColor());
        cvBackground.addPanel(pnDesc);
        this.flDesc = new PanelTextField<String>(new GuiTransform(GuiAlign.MID_CENTER, -100, -16, 184, 16, 0), this.quest.getProperty(NativeProps.DESC), FieldFilterString.INSTANCE);
        this.flDesc.setMaxLength(Integer.MAX_VALUE);
        cvBackground.addPanel(this.flDesc);
        PanelButton btnDesc = new PanelButton(new GuiTransform(GuiAlign.MID_CENTER, 84, -16, 16, 16, 0), 7, "Aa");
        cvBackground.addPanel(btnDesc);
        PanelButton btnTsk = new PanelButton(new GuiTransform(GuiAlign.MID_CENTER, -100, 16, 100, 16, 0), 1, QuestTranslation.translate("betterquesting.btn.tasks", new Object[0]));
        cvBackground.addPanel(btnTsk);
        PanelButton btnRew = new PanelButton(new GuiTransform(GuiAlign.MID_CENTER, 0, 16, 100, 16, 0), 2, QuestTranslation.translate("betterquesting.btn.rewards", new Object[0]));
        cvBackground.addPanel(btnRew);
        PanelButton btnReq = new PanelButton(new GuiTransform(GuiAlign.MID_CENTER, -100, 32, 100, 16, 0), 3, QuestTranslation.translate("betterquesting.btn.requirements", new Object[0]));
        cvBackground.addPanel(btnReq);
        PanelButton btnIco = new PanelButton(new GuiTransform(GuiAlign.MID_CENTER, 0, 32, 100, 16, 0), 8, QuestTranslation.translate("betterquesting.btn.icon", new Object[0]));
        cvBackground.addPanel(btnIco);
        this.btnVis = new PanelButton(new GuiTransform(GuiAlign.MID_CENTER, -100, 48, 100, 16, 0), 5, QuestTranslation.translate("betterquesting.btn.show", new Object[0]) + ": " + (Object)((Object)this.quest.getProperty(NativeProps.VISIBILITY)));
        this.btnVis.setTooltip(Collections.singletonList(QuestTranslation.translate(String.format("betterquesting.btn.show.%s", this.quest.getProperty(NativeProps.VISIBILITY).toString().toLowerCase()), new Object[0])));
        cvBackground.addPanel(this.btnVis);
        this.btnLogic = new PanelButton(new GuiTransform(GuiAlign.MID_CENTER, 0, 48, 100, 16, 0), 6, QuestTranslation.translate("betterquesting.btn.logic", new Object[0]) + ": " + (Object)((Object)this.quest.getProperty(NativeProps.LOGIC_QUEST)));
        cvBackground.addPanel(this.btnLogic);
        PanelButton btnAdv = new PanelButton(new GuiTransform(GuiAlign.MID_CENTER, -100, 64, 200, 16, 0), 4, QuestTranslation.translate("betterquesting.btn.advanced", new Object[0]));
        cvBackground.addPanel(btnAdv);
    }

    @Override
    public boolean onMouseClick(int mx, int my, int button) {
        boolean result = super.onMouseClick(mx, my, button);
        boolean flag = false;
        if (!this.quest.getProperty(NativeProps.NAME).equals(this.flName.getValue())) {
            this.quest.setProperty(NativeProps.NAME, this.flName.getValue());
            flag = true;
        }
        if (!this.quest.getProperty(NativeProps.DESC).equals(this.flDesc.getValue())) {
            this.quest.setProperty(NativeProps.DESC, this.flDesc.getValue());
            flag = true;
        }
        if (flag) {
            this.SendChanges();
        }
        return result;
    }

    @Override
    public void onPanelEvent(PanelEvent event) {
        if (event instanceof PEventButton) {
            this.onButtonPress((PEventButton)event);
        }
    }

    private void onButtonPress(PEventButton event) {
        IPanelButton btn = event.getButton();
        switch (btn.getButtonID()) {
            case 0: {
                this.field_146297_k.func_147108_a(this.parent);
                break;
            }
            case 1: {
                this.field_146297_k.func_147108_a((GuiScreen)new GuiTaskEditor(this, this.quest));
                break;
            }
            case 2: {
                this.field_146297_k.func_147108_a((GuiScreen)new GuiRewardEditor(this, this.quest));
                break;
            }
            case 3: {
                this.field_146297_k.func_147108_a((GuiScreen)new GuiPrerequisiteEditor(this, this.quest));
                break;
            }
            case 4: {
                this.field_146297_k.func_147108_a((GuiScreen)new GuiNbtEditor((GuiScreen)this, this.quest.writeToNBT(new NBTTagCompound()), value -> {
                    this.quest.readFromNBT(value);
                    this.SendChanges();
                }));
                break;
            }
            case 5: {
                EnumQuestVisibility[] visList = EnumQuestVisibility.values();
                EnumQuestVisibility vis = this.quest.getProperty(NativeProps.VISIBILITY);
                vis = visList[(vis.ordinal() + 1) % visList.length];
                this.quest.setProperty(NativeProps.VISIBILITY, vis);
                ((PanelButton)btn).setText(QuestTranslation.translate("betterquesting.btn.show", new Object[0]) + ": " + (Object)((Object)vis));
                this.SendChanges();
                break;
            }
            case 6: {
                EnumLogic[] logicList = EnumLogic.values();
                EnumLogic logic = this.quest.getProperty(NativeProps.LOGIC_QUEST);
                logic = logicList[(logic.ordinal() + 1) % logicList.length];
                this.quest.setProperty(NativeProps.LOGIC_QUEST, logic);
                ((PanelButton)btn).setText(QuestTranslation.translate("betterquesting.btn.logic", new Object[0]) + ": " + (Object)((Object)logic));
                this.SendChanges();
                break;
            }
            case 7: {
                this.field_146297_k.func_147108_a((GuiScreen)new GuiTextEditor(this, this.quest.getProperty(NativeProps.DESC), value -> {
                    this.quest.setProperty(NativeProps.DESC, value);
                    this.SendChanges();
                }));
                break;
            }
            case 8: {
                this.field_146297_k.func_147108_a((GuiScreen)new GuiItemSelection((GuiScreen)this, this.quest.getProperty(NativeProps.ICON), value -> {
                    this.quest.setProperty(NativeProps.ICON, value);
                    this.SendChanges();
                }));
            }
        }
    }

    private void SendChanges() {
        NBTTagCompound payload = new NBTTagCompound();
        NBTTagList dataList = new NBTTagList();
        NBTTagCompound entry = new NBTTagCompound();
        entry.func_74768_a("questID", this.questID);
        entry.func_74782_a("config", (NBTBase)this.quest.writeToNBT(new NBTTagCompound()));
        dataList.func_74742_a((NBTBase)entry);
        payload.func_74782_a("data", (NBTBase)dataList);
        payload.func_74768_a("action", 0);
        NetQuestEdit.sendEdit(payload);
    }
}

