/*
 * Decompiled with CFR 0.152.
 */
package betterquesting.client.gui2;

import betterquesting.api.utils.BigItemStack;
import betterquesting.api2.client.gui.GuiScreenCanvas;
import betterquesting.api2.client.gui.misc.GuiAlign;
import betterquesting.api2.client.gui.misc.GuiTransform;
import betterquesting.api2.client.gui.misc.IGuiRect;
import betterquesting.api2.client.gui.panels.content.PanelGeneric;
import betterquesting.api2.client.gui.panels.content.PanelItemSlot;
import betterquesting.api2.client.gui.panels.content.PanelTextBox;
import betterquesting.api2.client.gui.resources.textures.IGuiTexture;
import betterquesting.api2.utils.QuestTranslation;
import betterquesting.client.themes.BQSTextures;
import java.util.List;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.audio.PositionedSoundRecord;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;

public class GuiLootChest
extends GuiScreenCanvas {
    private final String title;
    private final List<BigItemStack> rewards;

    public GuiLootChest(GuiScreen parent, List<BigItemStack> rewards, String title) {
        super(parent);
        this.rewards = rewards;
        this.title = title;
    }

    @Override
    public void initPanel() {
        super.initPanel();
        this.field_146297_k.func_147118_V().func_147682_a((ISound)PositionedSoundRecord.func_184371_a((SoundEvent)new SoundEvent(new ResourceLocation("random.chestopen")), (float)1.0f));
        this.addPanel(new PanelGeneric(new GuiTransform(GuiAlign.MID_CENTER, -64, 0, 128, 68, 0), BQSTextures.LOOT_CHEST.getTexture()));
        this.addPanel(new PanelTextBox(new GuiTransform(GuiAlign.MID_CENTER, -64, 40, 128, 56, -1), QuestTranslation.translate(this.title, new Object[0])).setAlignment(1));
        IGuiTexture texGlow = BQSTextures.LOOT_GLOW.getTexture();
        int rowMax = (int)Math.max(1.0, Math.ceil((double)this.rewards.size() / 8.0));
        rowMax = this.rewards.size() / rowMax;
        for (int i = 0; i < this.rewards.size(); ++i) {
            BigItemStack stack = this.rewards.get(i);
            int rowX = i % rowMax;
            int rowY = i / rowMax;
            int rowSize = Math.min(this.rewards.size() - rowY * rowMax, rowMax);
            rowX = -(rowSize * 36) / 2 + rowX * 36;
            rowY = -36 - rowY * 36;
            this.addPanel(new PanelGeneric(new GuiTransform(GuiAlign.MID_CENTER, rowX + 2, rowY + 2, 32, 32, 0), texGlow));
            this.addPanel(new PanelItemSlot((IGuiRect)new GuiTransform(GuiAlign.MID_CENTER, rowX + 10, rowY + 10, 16, 16, -1), -1, stack).setTextures(null, null, null));
        }
    }
}

