/*
 * Decompiled with CFR 0.152.
 */
package betterquesting.api2.client.gui.resources.factories.textures;

import betterquesting.api.utils.JsonHelper;
import betterquesting.api2.client.gui.misc.GuiPadding;
import betterquesting.api2.client.gui.misc.GuiRectangle;
import betterquesting.api2.client.gui.resources.textures.IGuiTexture;
import betterquesting.api2.client.gui.resources.textures.SlicedTexture;
import betterquesting.api2.client.gui.themes.presets.PresetTexture;
import betterquesting.api2.registry.IFactoryData;
import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;

public class FactorySlicedTexture
implements IFactoryData<IGuiTexture, JsonObject> {
    public static final FactorySlicedTexture INSTANCE = new FactorySlicedTexture();
    private static final ResourceLocation RES_ID = new ResourceLocation("betterquesting", "texture_sliced");

    @Override
    public SlicedTexture loadFromData(JsonObject data) {
        ResourceLocation atlas = new ResourceLocation(JsonHelper.GetString(data, "atlas", PresetTexture.TX_NULL.toString()));
        int sliceMode = MathHelper.func_76125_a((int)JsonHelper.GetNumber(data, "sliceMode", 0).intValue(), (int)0, (int)SlicedTexture.SliceMode.values().length);
        int[] bounds = new int[]{0, 0, 16, 16};
        JsonArray jAry = JsonHelper.GetArray(data, "bounds");
        for (int i = 0; i < jAry.size() && i < bounds.length; ++i) {
            if (!jAry.get(i).isJsonPrimitive()) continue;
            try {
                bounds[i] = jAry.get(i).getAsInt();
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        int[] padding = new int[]{0, 0, 16, 16};
        JsonArray jAry2 = JsonHelper.GetArray(data, "padding");
        for (int i = 0; i < jAry.size() && i < padding.length; ++i) {
            if (!jAry2.get(i).isJsonPrimitive()) continue;
            try {
                padding[i] = jAry2.get(i).getAsInt();
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return new SlicedTexture(atlas, new GuiRectangle(bounds[0], bounds[1], bounds[2], bounds[3]), new GuiPadding(padding[0], padding[1], padding[2], padding[3])).setSliceMode(SlicedTexture.SliceMode.values()[sliceMode]);
    }

    @Override
    public ResourceLocation getRegistryName() {
        return RES_ID;
    }

    @Override
    public SlicedTexture createNew() {
        return new SlicedTexture(PresetTexture.TX_NULL, new GuiRectangle(0, 0, 16, 16), new GuiPadding(1, 1, 1, 1));
    }
}

