/*
 * Decompiled with CFR 0.152.
 */
package zmaster587.advancedRocketry.tile.multiblock.machine;

import java.util.List;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.AxisAlignedBB;
import zmaster587.advancedRocketry.inventory.TextureResources;
import zmaster587.advancedRocketry.util.AudioRegistry;
import zmaster587.libVulpes.api.LibVulpesBlocks;
import zmaster587.libVulpes.api.material.Material;
import zmaster587.libVulpes.api.material.MaterialRegistry;
import zmaster587.libVulpes.block.BlockMeta;
import zmaster587.libVulpes.client.util.ProgressBarImage;
import zmaster587.libVulpes.inventory.modules.IModularInventory;
import zmaster587.libVulpes.inventory.modules.IProgressBar;
import zmaster587.libVulpes.inventory.modules.ModuleBase;
import zmaster587.libVulpes.inventory.modules.ModuleImage;
import zmaster587.libVulpes.inventory.modules.ModuleProgress;
import zmaster587.libVulpes.tile.multiblock.TileMultiBlock;
import zmaster587.libVulpes.tile.multiblock.TileMultiblockMachine;
import zmaster587.libVulpes.util.IconResource;

public class TilePrecisionAssembler
extends TileMultiblockMachine
implements IModularInventory,
IProgressBar {
    public static final Object[][][] structure = new Object[][][]{{{LibVulpesBlocks.blockStructureBlock, LibVulpesBlocks.blockStructureBlock, LibVulpesBlocks.blockStructureBlock, LibVulpesBlocks.blockStructureBlock}, {LibVulpesBlocks.blockStructureBlock, LibVulpesBlocks.blockStructureBlock, LibVulpesBlocks.blockStructureBlock, LibVulpesBlocks.blockStructureBlock}, {LibVulpesBlocks.blockStructureBlock, LibVulpesBlocks.blockStructureBlock, LibVulpesBlocks.blockStructureBlock, LibVulpesBlocks.blockStructureBlock}}, {{LibVulpesBlocks.blockStructureBlock, Blocks.field_150359_w, Blocks.field_150359_w, LibVulpesBlocks.blockStructureBlock}, {LibVulpesBlocks.blockStructureBlock, Blocks.field_150350_a, Blocks.field_150350_a, LibVulpesBlocks.blockStructureBlock}, {LibVulpesBlocks.blockStructureBlock, LibVulpesBlocks.blockStructureBlock, LibVulpesBlocks.blockStructureBlock, LibVulpesBlocks.blockStructureBlock}}, {{Character.valueOf('c'), Character.valueOf('*'), Character.valueOf('*'), Character.valueOf('*')}, {Character.valueOf('*'), "blockCoil", "blockCoil", Character.valueOf('*')}, {Character.valueOf('*'), LibVulpesBlocks.motors, LibVulpesBlocks.motors, Character.valueOf('*')}}};

    public Object[][][] getStructure() {
        return structure;
    }

    public float getTimeMultiplierForBlock(IBlockState state, TileEntity tile) {
        Material material = MaterialRegistry.getMaterialFromItemStack((ItemStack)new ItemStack(state.func_177230_c(), 1, state.func_177230_c().func_176201_c(state)));
        if (material == MaterialRegistry.getMaterialFromName((String)"Gold")) {
            return 0.9f;
        }
        if (material == MaterialRegistry.getMaterialFromName((String)"Aluminum")) {
            return 0.8f;
        }
        if (material == MaterialRegistry.getMaterialFromName((String)"Titanium")) {
            return 0.75f;
        }
        if (material == MaterialRegistry.getMaterialFromName((String)"Iridium")) {
            return 0.5f;
        }
        return super.getTimeMultiplierForBlock(state, tile);
    }

    public List<BlockMeta> getAllowableWildCardBlocks() {
        List list = super.getAllowableWildCardBlocks();
        list.add(new BlockMeta(LibVulpesBlocks.blockStructureBlock, -1));
        list.addAll(TileMultiBlock.getMapping((char)'O'));
        list.addAll(TileMultiBlock.getMapping((char)'I'));
        list.addAll(TileMultiBlock.getMapping((char)'P'));
        list.addAll(TileMultiBlock.getMapping((char)'l'));
        list.addAll(TileMultiBlock.getMapping((char)'L'));
        return list;
    }

    public AxisAlignedBB getRenderBoundingBox() {
        return new AxisAlignedBB(this.field_174879_c.func_177982_a(-4, -4, -4), this.field_174879_c.func_177982_a(4, 4, 4));
    }

    public List<ModuleBase> getModules(int ID, EntityPlayer player) {
        List modules = super.getModules(ID, player);
        int yOffset = 16;
        int xOffset = 65;
        if (this.field_145850_b.field_72995_K) {
            modules.add(new ModuleImage(xOffset, yOffset, new IconResource(132, 0, 53, 66, TextureResources.progressBars)));
        }
        modules.add(new ModuleProgress(xOffset + 35, yOffset + 22, 1, new ProgressBarImage(167, 22, 13, 15, 54, 42, 13, 15, EnumFacing.DOWN, TextureResources.progressBars), (IProgressBar)this));
        modules.add(new ModuleProgress(xOffset + 36, yOffset + 41, 2, new ProgressBarImage(168, 41, 11, 15, 67, 42, 11, 15, EnumFacing.DOWN, TextureResources.progressBars), (IProgressBar)this));
        modules.add(new ModuleProgress(xOffset + 31, yOffset + 62, 3, new ProgressBarImage(163, 62, 21, 3, 90, 42, 21, 3, EnumFacing.EAST, TextureResources.progressBars), (IProgressBar)this));
        return modules;
    }

    public int getProgress(int id) {
        if (id == 0) {
            return super.getProgress(id);
        }
        if (id == 1) {
            return Math.min(this.currentTime, this.completionTime / 3);
        }
        if (id == 2) {
            int relativeTime = this.currentTime - this.completionTime / 3;
            return relativeTime >= 0 ? Math.min(relativeTime, this.completionTime / 3) : 0;
        }
        int relativeTime = this.currentTime - 2 * this.completionTime / 3;
        return relativeTime >= 0 ? Math.min(relativeTime, this.completionTime / 3) : 0;
    }

    public int getTotalProgress(int id) {
        if (id == 0) {
            return super.getTotalProgress(id);
        }
        return this.completionTime / 3;
    }

    public SoundEvent getSound() {
        return AudioRegistry.precAss;
    }

    public void setTotalProgress(int id, int progress) {
        if (id == 0) {
            super.setTotalProgress(id, progress);
        }
    }

    public void setProgress(int id, int progress) {
        if (id == 0) {
            super.setProgress(id, progress);
        }
    }

    public float getNormallizedProgress(int id) {
        return (float)this.getProgress(id) / (float)this.getTotalProgress(id);
    }

    public String getMachineName() {
        return "container.precisionassemblingmachine";
    }
}

