/*
 * Decompiled with CFR 0.152.
 */
package zmaster587.advancedRocketry.tile.multiblock;

import io.netty.buffer.ByteBuf;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import zmaster587.advancedRocketry.AdvancedRocketry;
import zmaster587.advancedRocketry.api.AdvancedRocketryItems;
import zmaster587.advancedRocketry.dimension.DimensionManager;
import zmaster587.advancedRocketry.entity.EntityElevatorCapsule;
import zmaster587.advancedRocketry.inventory.TextureResources;
import zmaster587.advancedRocketry.inventory.modules.ModuleStellarBackground;
import zmaster587.advancedRocketry.item.ItemSpaceElevatorChip;
import zmaster587.advancedRocketry.util.DimensionBlockPosition;
import zmaster587.libVulpes.LibVulpes;
import zmaster587.libVulpes.api.LibVulpesBlocks;
import zmaster587.libVulpes.block.BlockMeta;
import zmaster587.libVulpes.block.RotatableBlock;
import zmaster587.libVulpes.interfaces.ILinkableTile;
import zmaster587.libVulpes.inventory.GuiHandler;
import zmaster587.libVulpes.inventory.modules.IButtonInventory;
import zmaster587.libVulpes.inventory.modules.ModuleBase;
import zmaster587.libVulpes.inventory.modules.ModuleButton;
import zmaster587.libVulpes.inventory.modules.ModuleContainerPan;
import zmaster587.libVulpes.inventory.modules.ModuleText;
import zmaster587.libVulpes.inventory.modules.ModuleTexturedSlotArray;
import zmaster587.libVulpes.items.ItemLinker;
import zmaster587.libVulpes.network.BasePacket;
import zmaster587.libVulpes.network.PacketHandler;
import zmaster587.libVulpes.network.PacketMachine;
import zmaster587.libVulpes.tile.multiblock.TileMultiPowerConsumer;
import zmaster587.libVulpes.util.EmbeddedInventory;
import zmaster587.libVulpes.util.HashedBlockPosition;
import zmaster587.libVulpes.util.INetworkMachine;

public class TileSpaceElevator
extends TileMultiPowerConsumer
implements ILinkableTile,
IInventory,
ITickable {
    Object[][][] structure = new Object[][][]{{{null, null, null, null, null, null, null}, {null, Blocks.field_150379_bu, null, Blocks.field_150350_a, null, Blocks.field_150379_bu, null}, {null, null, Blocks.field_150350_a, Blocks.field_150350_a, Blocks.field_150350_a, null, null}, {null, Blocks.field_150350_a, Blocks.field_150350_a, Blocks.field_150350_a, Blocks.field_150350_a, Blocks.field_150350_a, null}, {null, null, Blocks.field_150350_a, Blocks.field_150350_a, Blocks.field_150350_a, null, null}, {null, Blocks.field_150379_bu, null, Blocks.field_150350_a, null, Blocks.field_150379_bu, null}, {null, null, null, null, null, null, null}}, {{null, null, Character.valueOf('*'), Character.valueOf('*'), Character.valueOf('*'), null, null}, {null, Character.valueOf('*'), Character.valueOf('*'), Character.valueOf('*'), Character.valueOf('*'), Character.valueOf('*'), null}, {Character.valueOf('*'), Character.valueOf('*'), Blocks.field_150350_a, Blocks.field_150350_a, Blocks.field_150350_a, Character.valueOf('*'), Character.valueOf('*')}, {Character.valueOf('*'), Character.valueOf('*'), Blocks.field_150350_a, Blocks.field_150350_a, Blocks.field_150350_a, Character.valueOf('*'), Character.valueOf('*')}, {Character.valueOf('*'), Character.valueOf('*'), Blocks.field_150350_a, Blocks.field_150350_a, Blocks.field_150350_a, Character.valueOf('*'), Character.valueOf('*')}, {null, Character.valueOf('*'), Character.valueOf('*'), Character.valueOf('*'), Character.valueOf('*'), Character.valueOf('*'), null}, {null, null, Character.valueOf('*'), Character.valueOf('*'), Character.valueOf('*'), null, null}}, {{null, Character.valueOf('*'), Character.valueOf('*'), null, Character.valueOf('c'), Character.valueOf('*'), null}, {Character.valueOf('*'), Character.valueOf('*'), Character.valueOf('*'), null, Character.valueOf('*'), Character.valueOf('*'), Character.valueOf('*')}, {Character.valueOf('*'), Character.valueOf('*'), Blocks.field_150350_a, Blocks.field_150350_a, Blocks.field_150350_a, Character.valueOf('*'), Character.valueOf('*')}, {Character.valueOf('*'), Character.valueOf('*'), Blocks.field_150350_a, Blocks.field_150350_a, Blocks.field_150350_a, Character.valueOf('*'), Character.valueOf('*')}, {Character.valueOf('*'), Character.valueOf('*'), Blocks.field_150350_a, Blocks.field_150350_a, Blocks.field_150350_a, Character.valueOf('*'), Character.valueOf('*')}, {Character.valueOf('*'), Character.valueOf('*'), Character.valueOf('*'), Character.valueOf('*'), Character.valueOf('*'), Character.valueOf('*'), Character.valueOf('*')}, {null, Character.valueOf('*'), Character.valueOf('*'), Character.valueOf('*'), Character.valueOf('*'), Character.valueOf('*'), null}}, {{Character.valueOf('*'), Character.valueOf('*'), Character.valueOf('*'), null, Character.valueOf('*'), Character.valueOf('*'), Character.valueOf('*')}, {Character.valueOf('*'), Character.valueOf('*'), Character.valueOf('*'), null, Character.valueOf('*'), Character.valueOf('*'), Character.valueOf('*')}, {Character.valueOf('*'), Character.valueOf('*'), Blocks.field_150350_a, Blocks.field_150350_a, Blocks.field_150350_a, Character.valueOf('*'), Character.valueOf('*')}, {Character.valueOf('*'), Character.valueOf('*'), Blocks.field_150350_a, Blocks.field_150350_a, Blocks.field_150350_a, Character.valueOf('*'), Character.valueOf('*')}, {Character.valueOf('*'), Character.valueOf('*'), Blocks.field_150350_a, Blocks.field_150350_a, Blocks.field_150350_a, Character.valueOf('*'), Character.valueOf('*')}, {Character.valueOf('*'), Character.valueOf('*'), Character.valueOf('*'), Character.valueOf('*'), Character.valueOf('*'), Character.valueOf('*'), Character.valueOf('*')}, {Character.valueOf('*'), Character.valueOf('*'), Character.valueOf('*'), Character.valueOf('*'), Character.valueOf('*'), Character.valueOf('*'), Character.valueOf('*')}}, {{Character.valueOf('*'), Character.valueOf('*'), Character.valueOf('*'), Character.valueOf('*'), Character.valueOf('*'), Character.valueOf('*'), Character.valueOf('*')}, {Character.valueOf('*'), Character.valueOf('*'), "blockCoil", "blockCoil", "blockCoil", Character.valueOf('*'), Character.valueOf('*')}, {LibVulpesBlocks.motors, "blockCoil", Blocks.field_150350_a, Blocks.field_150350_a, Blocks.field_150350_a, "blockCoil", LibVulpesBlocks.motors}, {Character.valueOf('P'), "blockCoil", Blocks.field_150350_a, Blocks.field_150350_a, Blocks.field_150350_a, "blockCoil", Character.valueOf('P')}, {LibVulpesBlocks.motors, "blockCoil", Blocks.field_150350_a, Blocks.field_150350_a, Blocks.field_150350_a, "blockCoil", LibVulpesBlocks.motors}, {Character.valueOf('*'), Character.valueOf('*'), "blockCoil", "blockCoil", "blockCoil", Character.valueOf('*'), Character.valueOf('*')}, {Character.valueOf('*'), Character.valueOf('*'), LibVulpesBlocks.motors, Character.valueOf('P'), LibVulpesBlocks.motors, Character.valueOf('*'), Character.valueOf('*')}}};
    EmbeddedInventory inv = new EmbeddedInventory(1);
    EntityElevatorCapsule capsule = null;
    boolean firstTick = true;
    DimensionBlockPosition dimBlockPos;
    private ModuleText landingPadDisplayText = new ModuleText(256, 16, "", 65280, 2.0f);
    private static final byte SUMMON_PACKET = 2;
    private static final byte SELECT_DST = 3;
    private static final int BUTTON_ID_OFFSET = 5;

    public TileSpaceElevator() {
        this.landingPadDisplayText.setColor(65280);
        this.dimBlockPos = null;
    }

    public void deconstructMultiBlock(World world, BlockPos destroyedPos, boolean blockBroken, IBlockState state) {
        super.deconstructMultiBlock(world, destroyedPos, blockBroken, state);
        EntityElevatorCapsule e = this.getCapsuleOnLine();
        if (e != null) {
            e.func_70106_y();
        }
    }

    public Object[][][] getStructure() {
        return this.structure;
    }

    public String getMachineName() {
        return "tile.spaceElevatorController.name";
    }

    public AxisAlignedBB getRenderBoundingBox() {
        return new AxisAlignedBB(this.field_174879_c.func_177982_a(-5, -3, -5), this.field_174879_c.func_177982_a(5, 3000, 5));
    }

    public List<ModuleBase> getModules(int ID, EntityPlayer player) {
        List modules = super.getModules(ID, player);
        if (ID == GuiHandler.guiId.MODULAR.ordinal()) {
            modules.add(new ModuleButton(50, 47, 1, LibVulpes.proxy.getLocalizedString("msg.spaceElevator.button.summon"), (IButtonInventory)this, zmaster587.libVulpes.inventory.TextureResources.buttonBuild, 80, 18));
            modules.add(new ModuleButton(50, 67, 2, LibVulpes.proxy.getLocalizedString("msg.label.selectDst"), (IButtonInventory)this, zmaster587.libVulpes.inventory.TextureResources.buttonBuild, 80, 18));
            modules.add(new ModuleTexturedSlotArray(50, 20, (IInventory)this, 0, 1, TextureResources.idChip));
            modules.add(new ModuleText(70, 23, LibVulpes.proxy.getLocalizedString("msg.spaceElevator.label.chip"), 0x2D2D2D));
        } else {
            modules.clear();
            modules.add(new ModuleStellarBackground(0, 0, zmaster587.libVulpes.inventory.TextureResources.starryBG));
            LinkedList<ModuleButton> list2 = new LinkedList<ModuleButton>();
            ModuleButton button = new ModuleButton(0, 0, 5, LibVulpes.proxy.getLocalizedString("msg.label.clear"), (IButtonInventory)this, TextureResources.buttonGeneric, 256, 18);
            list2.add(button);
            ItemStack stack = this.getChip();
            if (stack != null) {
                List<DimensionBlockPosition> list = ((ItemSpaceElevatorChip)AdvancedRocketryItems.itemSpaceElevatorChip).getBlockPositions(stack);
                int i = 1;
                for (DimensionBlockPosition pos : list) {
                    button = new ModuleButton(0, i * 18, i + 5, pos.toString(), (IButtonInventory)this, TextureResources.buttonGeneric, 256, 18);
                    list2.add(button);
                    if (!TileSpaceElevator.isDstValid(this.field_145850_b, pos, new HashedBlockPosition(this.func_174877_v()))) {
                        button.setColor(-56798);
                    }
                    ++i;
                }
            }
            ModuleContainerPan pan = new ModuleContainerPan(25, 25, list2, new LinkedList(), null, 512, 256, 0, -48, 258, 256);
            modules.add(pan);
            this.landingPadDisplayText.setText(this.dimBlockPos != null ? this.dimBlockPos.toString() : LibVulpes.proxy.getLocalizedString("msg.label.noneSelected"));
            modules.add(this.landingPadDisplayText);
        }
        return modules;
    }

    public static boolean isDstValid(World worldObj, DimensionBlockPosition pos, HashedBlockPosition myPos) {
        if (pos == null || pos.pos == null) {
            return false;
        }
        return worldObj.field_73011_w.getDimension() != pos.dimid && DimensionManager.getInstance().areDimensionsInSamePlanetMoonSystem(DimensionManager.getEffectiveDimId(pos.dimid, pos.pos.getBlockPos()).getId(), DimensionManager.getEffectiveDimId(worldObj, myPos.getBlockPos()).getId());
    }

    public boolean attemptLaunch() {
        if (!(this.isComplete() && this.enabled && this.hasEnergy(50000))) {
            return false;
        }
        this.useEnergy(50000);
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public void onInventoryButtonPressed(int buttonId) {
        if (buttonId == 1) {
            PacketHandler.sendToServer((BasePacket)new PacketMachine((INetworkMachine)this, 2));
        } else if (buttonId == 2) {
            PacketHandler.sendToServer((BasePacket)new PacketMachine((INetworkMachine)this, 3));
        }
        if (buttonId >= 5) {
            PacketHandler.sendToServer((BasePacket)new PacketMachine((INetworkMachine)this, (byte)buttonId));
        }
        super.onInventoryButtonPressed(buttonId);
    }

    public void notifyLanded(EntityElevatorCapsule e) {
        if (this.capsule != null && this.capsule != e && !this.capsule.field_70128_L) {
            e.func_70106_y();
        } else {
            this.capsule = e;
            this.capsule.setSourceTile(new DimensionBlockPosition(this.field_145850_b.field_73011_w.getDimension(), new HashedBlockPosition(this.field_174879_c)));
            this.capsule.setDst(this.dimBlockPos);
        }
        this.capsule.func_70107_b(this.getLandingLocationX(), this.func_174877_v().func_177956_o() - 1, this.getLandingLocationZ());
        EnumFacing facing = RotatableBlock.getFront((IBlockState)this.field_145850_b.func_180495_p(this.func_174877_v()));
        switch (facing) {
            case EAST: {
                this.capsule.field_70177_z = 180.0f;
                break;
            }
            case SOUTH: {
                this.capsule.field_70177_z = 90.0f;
                break;
            }
            case NORTH: {
                this.capsule.field_70177_z = 270.0f;
                break;
            }
            default: {
                this.capsule.field_70177_z = 0.0f;
            }
        }
    }

    public void func_73660_a() {
        super.func_73660_a();
    }

    public void writeDataToNetwork(ByteBuf out, byte id) {
        super.writeDataToNetwork(out, id);
    }

    public void readDataFromNetwork(ByteBuf in, byte packetId, NBTTagCompound nbt) {
        super.readDataFromNetwork(in, packetId, nbt);
    }

    public void useNetworkData(EntityPlayer player, Side side, byte id, NBTTagCompound nbt) {
        ItemStack stack;
        if (id == 2) {
            this.summonCapsule();
        } else if (id == 3) {
            player.func_71053_j();
            player.openGui((Object)LibVulpes.instance, GuiHandler.guiId.MODULARFULLSCREEN.ordinal(), player.field_70170_p, this.field_174879_c.func_177958_n(), this.field_174879_c.func_177956_o(), this.field_174879_c.func_177952_p());
        } else if (id == 5) {
            this.dimBlockPos = null;
            this.capsule.setDst(null);
            this.func_70296_d();
            this.field_145850_b.func_184138_a(this.field_174879_c, this.field_145850_b.func_180495_p(this.field_174879_c), this.field_145850_b.func_180495_p(this.field_174879_c), 3);
        } else if (id > 5 && (stack = this.inv.func_70301_a(0)) != null && stack.func_77973_b() instanceof ItemSpaceElevatorChip) {
            List<DimensionBlockPosition> list = ((ItemSpaceElevatorChip)AdvancedRocketryItems.itemSpaceElevatorChip).getBlockPositions(stack);
            try {
                DimensionBlockPosition dstpos = list.get(id - 5 - 1);
                if (TileSpaceElevator.isDstValid(this.field_145850_b, dstpos, new HashedBlockPosition(this.func_174877_v()))) {
                    TileEntity tile;
                    this.dimBlockPos = dstpos;
                    WorldServer world = net.minecraftforge.common.DimensionManager.getWorld((int)this.dimBlockPos.dimid);
                    if (world == null) {
                        net.minecraftforge.common.DimensionManager.initDimension((int)this.dimBlockPos.dimid);
                        world = net.minecraftforge.common.DimensionManager.getWorld((int)this.dimBlockPos.dimid);
                    }
                    if (world != null && (tile = world.func_175625_s(this.dimBlockPos.pos.getBlockPos())) instanceof TileSpaceElevator) {
                        this.summonCapsule();
                        this.capsule.setDst(this.dimBlockPos);
                        this.capsule.setSourceTile(new DimensionBlockPosition(this.func_145831_w().field_73011_w.getDimension(), new HashedBlockPosition(this.func_174877_v())));
                        this.func_70296_d();
                        this.field_145850_b.func_184138_a(this.field_174879_c, world.func_180495_p(this.field_174879_c), world.func_180495_p(this.field_174879_c), 3);
                        return;
                    }
                }
            }
            catch (IndexOutOfBoundsException e) {
                AdvancedRocketry.logger.warn("Space Elevator at location " + this.field_174879_c + " recieved invalid button press!");
            }
            this.dimBlockPos = null;
        }
        super.useNetworkData(player, side, id, nbt);
    }

    public EntityElevatorCapsule getCapsuleOnLine() {
        if (this.capsule != null && this.capsule.field_70128_L) {
            this.capsule = null;
        }
        double capsulePosX = this.getLandingLocationX();
        double capsulePosZ = this.getLandingLocationZ();
        for (EntityElevatorCapsule e : this.field_145850_b.func_72872_a(EntityElevatorCapsule.class, new AxisAlignedBB(capsulePosX - 3.0, (double)(this.func_174877_v().func_177956_o() - 1), capsulePosZ - 3.0, capsulePosX + 3.0, EntityElevatorCapsule.MAX_HEIGHT, capsulePosZ + 3.0))) {
            if (e.isInMotion() || e.field_70128_L) continue;
            this.capsule = e;
        }
        return this.capsule;
    }

    public double getLandingLocationX() {
        EnumFacing facing = RotatableBlock.getFront((IBlockState)this.field_145850_b.func_180495_p(this.func_174877_v()));
        return (double)(this.func_174877_v().func_177958_n() + facing.func_82601_c() * -3 - facing.func_82599_e()) + 0.5;
    }

    public double getLandingLocationZ() {
        EnumFacing facing = RotatableBlock.getFront((IBlockState)this.field_145850_b.func_180495_p(this.func_174877_v()));
        return (double)(this.func_174877_v().func_177952_p() + facing.func_82601_c() * 1 + facing.func_82599_e() * -3) + 0.5;
    }

    public void summonCapsule() {
        if (this.getCapsuleOnLine() != null) {
            return;
        }
        this.capsule = new EntityElevatorCapsule(this.field_145850_b);
        EnumFacing facing = RotatableBlock.getFront((IBlockState)this.field_145850_b.func_180495_p(this.func_174877_v()));
        switch (facing) {
            case EAST: {
                this.capsule.field_70177_z = 180.0f;
                break;
            }
            case SOUTH: {
                this.capsule.field_70177_z = 90.0f;
                break;
            }
            case NORTH: {
                this.capsule.field_70177_z = 270.0f;
                break;
            }
            default: {
                this.capsule.field_70177_z = 0.0f;
            }
        }
        double capsulePosX = this.getLandingLocationX();
        double capsulePosZ = this.getLandingLocationZ();
        this.capsule.func_70107_b(capsulePosX, this.func_174877_v().func_177956_o() - 1, capsulePosZ);
        this.capsule.setSourceTile(new DimensionBlockPosition(this.field_145850_b.field_73011_w.getDimension(), new HashedBlockPosition(this.func_174877_v())));
        this.field_145850_b.func_72838_d((Entity)this.capsule);
    }

    public List<BlockMeta> getAllowableWildCardBlocks() {
        List list = super.getAllowableWildCardBlocks();
        list.add(new BlockMeta(Blocks.field_150348_b));
        list.add(new BlockMeta(Blocks.field_150322_A));
        list.add(new BlockMeta(Blocks.field_150339_S));
        list.add(new BlockMeta(LibVulpesBlocks.blockStructureBlock));
        list.add(new BlockMeta(LibVulpesBlocks.blockAdvStructureBlock));
        return list;
    }

    public boolean onLinkStart(ItemStack item, TileEntity entity, EntityPlayer player, World world) {
        ItemLinker.setMasterCoords((ItemStack)item, (BlockPos)this.func_174877_v());
        ItemLinker.setDimId((ItemStack)item, (int)world.field_73011_w.getDimension());
        if (!world.field_72995_K) {
            player.func_145747_a((ITextComponent)new TextComponentTranslation("msg.linker.program", new Object[0]));
        }
        return true;
    }

    public boolean onLinkComplete(ItemStack item, TileEntity entity, EntityPlayer player, World myWorld) {
        if (!myWorld.field_72995_K) {
            TileEntity tile;
            int dimid = ItemLinker.getDimId((ItemStack)item);
            BlockPos pos = ItemLinker.getMasterCoords((ItemStack)item);
            DimensionBlockPosition dimPos = new DimensionBlockPosition(dimid, new HashedBlockPosition(pos));
            if (dimPos.dimid == this.field_145850_b.field_73011_w.getDimension()) {
                player.func_145747_a((ITextComponent)new TextComponentTranslation("msg.spaceElevator.sameDimensionError", new Object[0]));
                return false;
            }
            WorldServer world = net.minecraftforge.common.DimensionManager.getWorld((int)dimPos.dimid);
            if (world == null) {
                net.minecraftforge.common.DimensionManager.initDimension((int)dimPos.dimid);
                world = net.minecraftforge.common.DimensionManager.getWorld((int)dimPos.dimid);
            }
            if (world != null && (tile = world.func_175625_s(dimPos.pos.getBlockPos())) instanceof TileSpaceElevator) {
                boolean flag;
                boolean bl = flag = this.getChip() != null && ((TileSpaceElevator)tile).getChip() != null;
                if (flag) {
                    this.addEntryToList(dimPos);
                    this.addEntryToList(new DimensionBlockPosition(this.field_145850_b.field_73011_w.getDimension(), new HashedBlockPosition(this.func_174877_v())));
                    ((TileSpaceElevator)tile).addEntryToList(new DimensionBlockPosition(this.field_145850_b.field_73011_w.getDimension(), new HashedBlockPosition(this.func_174877_v())));
                    ((TileSpaceElevator)tile).addEntryToList(dimPos);
                    player.func_145747_a((ITextComponent)new TextComponentTranslation("msg.spaceElevator.newDstAdded", new Object[0]));
                    return true;
                }
                player.func_145747_a((ITextComponent)new TextComponentTranslation("msg.spaceElevator.noChipError", new Object[0]));
                return false;
            }
        }
        return false;
    }

    private ItemStack getChip() {
        if (this.inv.func_70301_a(0) != null && this.inv.func_70301_a(0).func_77973_b() instanceof ItemSpaceElevatorChip) {
            return this.inv.func_70301_a(0);
        }
        return null;
    }

    private boolean addEntryToList(DimensionBlockPosition pos) {
        ItemStack chip = this.getChip();
        if (chip != null) {
            List<DimensionBlockPosition> list = ((ItemSpaceElevatorChip)AdvancedRocketryItems.itemSpaceElevatorChip).getBlockPositions(chip);
            if (!list.contains(pos)) {
                list.add(pos);
            }
            ((ItemSpaceElevatorChip)AdvancedRocketryItems.itemSpaceElevatorChip).setBlockPositions(chip, list);
            return true;
        }
        return false;
    }

    public String func_70005_c_() {
        return this.getModularInventoryName();
    }

    public boolean func_145818_k_() {
        return false;
    }

    public int func_70302_i_() {
        return this.inv.func_70302_i_();
    }

    public ItemStack func_70301_a(int index) {
        return this.inv.func_70301_a(index);
    }

    public ItemStack func_70298_a(int index, int count) {
        return this.inv.func_70298_a(index, count);
    }

    public ItemStack func_70304_b(int index) {
        return this.inv.func_70304_b(index);
    }

    public void func_70299_a(int index, ItemStack stack) {
        this.inv.func_70299_a(index, stack);
    }

    public int func_70297_j_() {
        return this.inv.func_70297_j_();
    }

    public boolean func_70300_a(EntityPlayer player) {
        return true;
    }

    public boolean func_191420_l() {
        return this.inv.func_191420_l();
    }

    public void func_174889_b(EntityPlayer player) {
        this.inv.func_174889_b(player);
    }

    public void func_174886_c(EntityPlayer player) {
        this.inv.func_174886_c(player);
    }

    public boolean func_94041_b(int index, ItemStack stack) {
        return this.inv.func_94041_b(index, stack);
    }

    public int func_174887_a_(int id) {
        return this.inv.func_174887_a_(id);
    }

    public void func_174885_b(int id, int value) {
        this.inv.func_174885_b(id, value);
    }

    public int func_174890_g() {
        return this.inv.func_174890_g();
    }

    public void func_174888_l() {
        this.inv.func_174888_l();
    }

    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        this.inv.writeToNBT(nbt);
        return super.func_189515_b(nbt);
    }

    public void writeNetworkData(NBTTagCompound nbt) {
        if (this.dimBlockPos != null) {
            nbt.func_74768_a("dstDimId", this.dimBlockPos.dimid);
            nbt.func_74783_a("dstPos", new int[]{this.dimBlockPos.pos.x, this.dimBlockPos.pos.y, this.dimBlockPos.pos.z});
        }
        super.writeNetworkData(nbt);
    }

    public void func_145839_a(NBTTagCompound nbt) {
        this.inv.readFromNBT(nbt);
        super.func_145839_a(nbt);
    }

    public void readNetworkData(NBTTagCompound nbt) {
        super.readNetworkData(nbt);
        if (nbt.func_74764_b("dstDimId")) {
            int id = nbt.func_74762_e("dstDimId");
            int[] pos = nbt.func_74759_k("dstPos");
            this.dimBlockPos = new DimensionBlockPosition(id, new HashedBlockPosition(pos[0], pos[1], pos[2]));
        } else {
            this.dimBlockPos = null;
        }
        this.landingPadDisplayText.setText(this.dimBlockPos != null ? this.dimBlockPos.toString() : LibVulpes.proxy.getLocalizedString("msg.label.noneSelected"));
    }
}

