/*
 * Decompiled with CFR 0.152.
 */
package com.sinthoras.visualprospecting.integration.model.layers;

import com.dyonovan.tcnodetracker.TCNodeTracker;
import com.dyonovan.tcnodetracker.lib.NodeList;
import com.sinthoras.visualprospecting.integration.model.buttons.ThaumcraftNodeButtonManager;
import com.sinthoras.visualprospecting.integration.model.layers.WaypointProviderManager;
import com.sinthoras.visualprospecting.integration.model.locations.IWaypointAndLocationProvider;
import com.sinthoras.visualprospecting.integration.model.locations.ThaumcraftNodeLocation;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;

public class ThaumcraftNodeLayerManager
extends WaypointProviderManager {
    public static final ThaumcraftNodeLayerManager instance = new ThaumcraftNodeLayerManager();
    private int oldMinBlockX = 0;
    private int oldMinBlockZ = 0;
    private int oldMaxBlockX = 0;
    private int oldMaxBlockZ = 0;

    public ThaumcraftNodeLayerManager() {
        super(ThaumcraftNodeButtonManager.instance);
    }

    @Override
    protected boolean needsRegenerateVisibleElements(int minBlockX, int minBlockZ, int maxBlockX, int maxBlockZ) {
        if (minBlockX != this.oldMinBlockX || minBlockZ != this.oldMinBlockZ || maxBlockX != this.oldMaxBlockX || maxBlockZ != this.oldMaxBlockZ) {
            this.oldMinBlockX = minBlockX;
            this.oldMinBlockZ = minBlockZ;
            this.oldMaxBlockX = maxBlockX;
            this.oldMaxBlockZ = maxBlockZ;
            return true;
        }
        return false;
    }

    @Override
    protected List<? extends IWaypointAndLocationProvider> generateVisibleElements(int minBlockX, int minBlockZ, int maxBlockX, int maxBlockZ) {
        int playerDimensionId = Minecraft.func_71410_x().field_71439_g.field_71093_bK;
        ArrayList<ThaumcraftNodeLocation> thaumcraftNodeLocations = new ArrayList<ThaumcraftNodeLocation>();
        for (NodeList node : TCNodeTracker.nodelist) {
            if (node.dim != playerDimensionId || node.x < minBlockX || node.x > maxBlockX || node.z < minBlockZ || node.z > maxBlockZ) continue;
            thaumcraftNodeLocations.add(new ThaumcraftNodeLocation(node));
        }
        return thaumcraftNodeLocations;
    }

    public void deleteNode(ThaumcraftNodeLocation thaumcraftNodeLocation) {
        TCNodeTracker.nodelist.removeIf(thaumcraftNodeLocation::belongsToNode);
        if (thaumcraftNodeLocation.isActiveAsWaypoint()) {
            this.clearActiveWaypoint();
        }
        this.forceRefresh();
    }
}

