/*
 * Decompiled with CFR 0.152.
 */
package thaumicenergistics.common.integration.tc;

import com.djgiannuzz.thaumcraftneiplugin.items.ItemAspect;
import cpw.mods.fml.common.Loader;
import cpw.mods.fml.common.Optional;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import org.apache.commons.lang3.tuple.ImmutablePair;
import thaumcraft.api.aspects.Aspect;
import thaumcraft.api.aspects.AspectList;
import thaumcraft.api.aspects.IEssentiaContainerItem;
import thaumcraft.common.blocks.BlockJarItem;
import thaumcraft.common.blocks.ItemJarFilled;
import thaumcraft.common.config.ConfigBlocks;
import thaumcraft.common.config.ConfigItems;
import thaumcraft.common.items.ItemCrystalEssence;
import thaumcraft.common.items.ItemEssence;
import thaumcraft.common.items.ItemResource;
import thaumcraft.common.items.ItemWispEssence;
import thaumicenergistics.api.IThEEssentiaContainerPermission;
import thaumicenergistics.api.IThETransportPermissions;
import thaumicenergistics.api.ThEApi;
import thaumicenergistics.api.items.IRestrictedEssentiaContainerItem;
import thaumicenergistics.api.storage.IAspectStack;
import thaumicenergistics.common.items.ItemBlockEssentiaVibrationChamber;
import thaumicenergistics.common.storage.AspectStack;

public final class EssentiaItemContainerHelper {
    public static final EssentiaItemContainerHelper INSTANCE = new EssentiaItemContainerHelper();
    private static final String JAR_LABEL_NBT_KEY = "AspectFilter";
    private static final int JAR_CAPACITY = 64;
    private static final int PHIAL_CAPACITY = 8;
    private IThETransportPermissions perms = ThEApi.instance().transportPermissions();

    private EssentiaItemContainerHelper() {
    }

    private Aspect getAspectFromAnyContainerItem(ItemStack itemStack) {
        AspectList aspectList;
        if (itemStack.func_77973_b() instanceof IEssentiaContainerItem && (aspectList = ((IEssentiaContainerItem)itemStack.func_77973_b()).getAspects(itemStack)) != null) {
            return aspectList.getAspects()[0];
        }
        return null;
    }

    public ItemStack createEmptyJar(int metadata) {
        return new ItemStack(ConfigBlocks.blockJar, 1, metadata);
    }

    public ItemStack createEmptyPhial() {
        return new ItemStack(ConfigItems.itemEssence, 1, 0);
    }

    public ItemStack createFilledJar(Aspect aspect, int amount, int metadata, boolean withLabel) {
        ItemStack jar;
        if (aspect == null || amount <= 0 && !withLabel) {
            jar = this.createEmptyJar(metadata);
        } else {
            jar = new ItemStack(ConfigItems.itemJarFilled, 1, metadata);
            if (amount > 0) {
                if (amount > 64) {
                    amount = 64;
                }
                ((ItemJarFilled)jar.func_77973_b()).setAspects(jar, new AspectList().add(aspect, amount));
            }
            if (withLabel) {
                this.setJarLabel(jar, aspect);
            }
        }
        return jar;
    }

    public ItemStack createFilledPhial(Aspect aspect) {
        if (aspect == null) {
            return this.createEmptyPhial();
        }
        ItemStack phial = new ItemStack(ConfigItems.itemEssence, 1, 1);
        ((ItemEssence)phial.func_77973_b()).setAspects(phial, new AspectList().add(aspect, 8));
        return phial;
    }

    public boolean doesJarHaveLabel(ItemStack jar) {
        return this.getJarLabelAspect(jar) != null;
    }

    public ImmutablePair<Integer, ItemStack> extractFromContainer(ItemStack container, IAspectStack aspectStack) {
        if (this.getItemType(container) != AspectItemType.EssentiaContainer) {
            return null;
        }
        Item containerItem = container.func_77973_b();
        IThEEssentiaContainerPermission info = this.getContainerInfo(containerItem, container.func_77960_j());
        if (info == null) {
            return null;
        }
        AspectList aspectList = ((IEssentiaContainerItem)containerItem).getAspects(container);
        if (aspectStack.getAspect() != aspectList.getAspects()[0]) {
            return null;
        }
        int containerAmountStored = aspectList.getAmount(aspectStack.getAspect());
        if (containerAmountStored <= 0) {
            return null;
        }
        int amountToDrain = (int)aspectStack.getStackSize();
        if (!info.canHoldPartialAmount()) {
            if (amountToDrain < info.maximumCapacity()) {
                return null;
            }
            if (amountToDrain > info.maximumCapacity()) {
                amountToDrain = info.maximumCapacity();
            }
        } else if (amountToDrain > containerAmountStored) {
            amountToDrain = containerAmountStored;
        }
        ItemStack resultStack = null;
        if (amountToDrain == containerAmountStored || amountToDrain == info.maximumCapacity()) {
            if (containerItem instanceof ItemEssence) {
                resultStack = this.createEmptyPhial();
            } else if (containerItem instanceof ItemJarFilled) {
                resultStack = this.doesJarHaveLabel(container) ? this.createFilledJar(aspectStack.getAspect(), 0, container.func_77960_j(), true) : this.createEmptyJar(container.func_77960_j());
            }
        }
        if (resultStack == null) {
            resultStack = container.func_77946_l();
            aspectList.remove(aspectStack.getAspect(), amountToDrain);
            ((IEssentiaContainerItem)resultStack.func_77973_b()).setAspects(resultStack, aspectList);
        }
        return new ImmutablePair((Object)amountToDrain, (Object)resultStack);
    }

    public ImmutablePair<Integer, ItemStack> extractFromContainer(ItemStack container, int drainAmount_EU) {
        if (container == null) {
            return null;
        }
        AspectStack stack = new AspectStack(this.getAspectInContainer(container), drainAmount_EU);
        return this.extractFromContainer(container, stack);
    }

    public Aspect getAspectFromLabel(ItemStack label) {
        if (this.getItemType(label) != AspectItemType.JarLabel) {
            return null;
        }
        ItemResource rLabel = (ItemResource)label.func_77973_b();
        AspectList aspects = rLabel.getAspects(label);
        if (aspects == null || aspects.size() == 0) {
            return null;
        }
        return aspects.getAspects()[0];
    }

    public Aspect getAspectInContainer(ItemStack itemStack) {
        if (this.getItemType(itemStack) == AspectItemType.EssentiaContainer) {
            return this.getAspectFromAnyContainerItem(itemStack);
        }
        return null;
    }

    public IAspectStack getAspectStackFromContainer(ItemStack container) {
        Aspect aspect = this.getAspectInContainer(container);
        if (aspect == null) {
            return null;
        }
        int stored = this.getContainerStoredAmount(container);
        return new AspectStack(aspect, stored);
    }

    public int getContainerCapacity(ItemStack container) {
        Item containerItem;
        IThEEssentiaContainerPermission info;
        if (container != null && (info = this.getContainerInfo(containerItem = container.func_77973_b(), container.func_77960_j())) != null) {
            return info.maximumCapacity();
        }
        return 0;
    }

    public IThEEssentiaContainerPermission getContainerInfo(Item item, int metadata) {
        if (item != null) {
            return this.perms.getEssentiaContainerInfo(item.getClass(), metadata);
        }
        return null;
    }

    public IThEEssentiaContainerPermission getContainerInfo(ItemStack itemStack) {
        if (itemStack != null) {
            return this.perms.getEssentiaContainerInfo(itemStack.func_77973_b().getClass(), itemStack.func_77960_j());
        }
        return null;
    }

    public int getContainerStoredAmount(ItemStack container) {
        if (container != null && container.func_77973_b() instanceof IEssentiaContainerItem && this.isContainerWhitelisted(container)) {
            AspectList storedList = ((IEssentiaContainerItem)container.func_77973_b()).getAspects(container);
            if (storedList == null) {
                return 0;
            }
            return storedList.getAmount(storedList.getAspects()[0]);
        }
        return 0;
    }

    public Aspect getFilterAspectFromItem(ItemStack itemStack) {
        AspectItemType type = this.getItemType(itemStack);
        switch (type) {
            case JarLabel: {
                return this.getAspectFromLabel(itemStack);
            }
            case CrystallizedEssentia: 
            case EssentiaContainer: 
            case WispEssence: {
                return this.getAspectFromAnyContainerItem(itemStack);
            }
            case ItemAspect: {
                return this.getAspectFromItemAspect(itemStack);
            }
        }
        return null;
    }

    public AspectItemType getItemType(ItemStack itemStack) {
        Item item;
        if (itemStack != null && (item = itemStack.func_77973_b()) != null) {
            if (this.isContainerWhitelisted(itemStack)) {
                return AspectItemType.EssentiaContainer;
            }
            if (item instanceof IEssentiaContainerItem) {
                if (item instanceof ItemCrystalEssence) {
                    return AspectItemType.CrystallizedEssentia;
                }
                if (item instanceof ItemWispEssence) {
                    return AspectItemType.WispEssence;
                }
            }
            if (item instanceof ItemResource && itemStack.func_77960_j() == 13) {
                return AspectItemType.JarLabel;
            }
            if (Loader.isModLoaded((String)"thaumcraftneiplugin") && item instanceof ItemAspect) {
                return AspectItemType.ItemAspect;
            }
        }
        return AspectItemType.Invalid;
    }

    public Aspect getJarLabelAspect(ItemStack jar) {
        Aspect labelAspect = null;
        if (jar.func_77973_b() instanceof ItemJarFilled && jar.func_77942_o() && jar.field_77990_d.func_74764_b(JAR_LABEL_NBT_KEY)) {
            String tag = jar.field_77990_d.func_74779_i(JAR_LABEL_NBT_KEY);
            labelAspect = Aspect.getAspect((String)tag);
        }
        return labelAspect;
    }

    public ImmutablePair<Integer, ItemStack> injectIntoContainer(ItemStack container, IAspectStack aspectStack) {
        if (this.getItemType(container) != AspectItemType.EssentiaContainer) {
            return null;
        }
        Item containerItem = container.func_77973_b();
        if (containerItem == null) {
            return null;
        }
        if (containerItem instanceof ItemJarFilled ? this.doesJarHaveLabel(container) && aspectStack.getAspect() != this.getJarLabelAspect(container) : containerItem instanceof IRestrictedEssentiaContainerItem && !((IRestrictedEssentiaContainerItem)containerItem).acceptsAspect(aspectStack.getAspect())) {
            return null;
        }
        IThEEssentiaContainerPermission info = this.getContainerInfo(containerItem, container.func_77960_j());
        if (info == null) {
            return null;
        }
        int containerAmountStored = this.getContainerStoredAmount(container);
        int remainaingStorage = info.maximumCapacity() - containerAmountStored;
        if (remainaingStorage <= 0) {
            return null;
        }
        int amountToFill = (int)aspectStack.getStackSize();
        if (!info.canHoldPartialAmount()) {
            if (amountToFill < info.maximumCapacity()) {
                return null;
            }
            if (amountToFill > info.maximumCapacity()) {
                amountToFill = info.maximumCapacity();
            }
        } else if (amountToFill > containerAmountStored + info.maximumCapacity()) {
            amountToFill = info.maximumCapacity() - containerAmountStored;
        }
        ItemStack resultStack = null;
        if (containerItem instanceof ItemEssence) {
            resultStack = this.createFilledPhial(aspectStack.getAspect());
        } else if (containerItem instanceof BlockJarItem) {
            resultStack = this.createFilledJar(aspectStack.getAspect(), amountToFill, container.func_77960_j(), false);
        }
        if (resultStack == null) {
            AspectList aspectList = ((IEssentiaContainerItem)containerItem).getAspects(container);
            if (aspectList == null) {
                aspectList = new AspectList();
            } else if (aspectList.size() > 0 && aspectStack.getAspect() != aspectList.getAspects()[0]) {
                return null;
            }
            aspectList.add(aspectStack.getAspect(), amountToFill);
            resultStack = container.func_77946_l();
            ((IEssentiaContainerItem)resultStack.func_77973_b()).setAspects(resultStack, aspectList);
        }
        return new ImmutablePair((Object)amountToFill, (Object)resultStack);
    }

    public boolean isContainerEmpty(ItemStack container) {
        return this.getContainerStoredAmount(container) == 0;
    }

    public boolean isContainerFilled(ItemStack container) {
        return this.getContainerStoredAmount(container) > 0;
    }

    public boolean isContainerWhitelisted(Item container, int metadata) {
        return this.getContainerInfo(container, metadata) != null;
    }

    public boolean isContainerWhitelisted(ItemStack container) {
        return this.getContainerInfo(container) != null;
    }

    public void registerDefaultContainers() {
        this.perms.addEssentiaContainerItemToTransportPermissions(ItemEssence.class, 8, 0, false);
        this.perms.addEssentiaContainerItemToTransportPermissions(ItemEssence.class, 8, 1, false);
        this.perms.addEssentiaContainerItemToTransportPermissions(ItemJarFilled.class, 64, 0, true);
        this.perms.addEssentiaContainerItemToTransportPermissions(ItemJarFilled.class, 64, 3, true);
        this.perms.addEssentiaContainerItemToTransportPermissions(ItemBlockEssentiaVibrationChamber.class, 64, 0, true);
    }

    public ItemStack setJarLabel(ItemStack jar, Aspect OverrideAspect) {
        Aspect labelAspect;
        if (jar.func_77973_b() instanceof ItemJarFilled && (labelAspect = OverrideAspect != null ? OverrideAspect : this.getFilterAspectFromItem(jar)) != null) {
            if (!jar.func_77942_o()) {
                jar.field_77990_d = new NBTTagCompound();
            }
            jar.field_77990_d.func_74778_a(JAR_LABEL_NBT_KEY, labelAspect.getTag());
        }
        return jar;
    }

    public void setLabelAspect(ItemStack label, Aspect aspect) {
        if (this.getItemType(label) != AspectItemType.JarLabel) {
            return;
        }
        ItemResource rLabel = (ItemResource)label.func_77973_b();
        AspectList aspects = new AspectList();
        aspects.add(aspect, 1);
        rLabel.setAspects(label, aspects);
    }

    @Optional.Method(modid="thaumcraftneiplugin")
    public Aspect getAspectFromItemAspect(ItemStack itemStack) {
        return ItemAspect.getAspects((ItemStack)itemStack).getAspects()[0];
    }

    public static enum AspectItemType {
        Invalid,
        EssentiaContainer,
        JarLabel,
        CrystallizedEssentia,
        WispEssence,
        ItemAspect;

    }
}

