/*
 * Decompiled with CFR 0.152.
 */
package com.gtnewhorizon.structurelib.command;

import com.gtnewhorizon.structurelib.alignment.constructable.ChannelDataAccessor;
import com.gtnewhorizon.structurelib.item.ItemConstructableTrigger;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.command.CommandBase;
import net.minecraft.command.ICommandSender;
import net.minecraft.command.WrongUsageException;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.ChatComponentTranslation;
import net.minecraft.util.IChatComponent;

public class CommandConfigureChannels
extends CommandBase {
    public String func_71517_b() {
        return "sl_channel";
    }

    public String func_71518_a(ICommandSender p_71518_1_) {
        return "/sl_channel <wipe/getall>\n/sl_channel <get/unset> <channel name>\n/sl_channel <set> <channel name> <value>\n<channel name> can have space in it. <value> must be positive integer";
    }

    public int func_82362_a() {
        return 0;
    }

    public List<?> func_71516_a(ICommandSender p_71516_1_, String[] p_71516_2_) {
        if (p_71516_2_.length == 1) {
            return CommandConfigureChannels.func_71530_a((String[])p_71516_2_, (String[])new String[]{"get", "set", "unset", "wipe", "getall"});
        }
        return null;
    }

    public void func_71515_b(ICommandSender sender, String[] args) {
        String channel;
        if (args.length == 0) {
            throw new WrongUsageException(this.func_71518_a(sender), new Object[0]);
        }
        if (!(sender instanceof EntityPlayerMP)) {
            throw new WrongUsageException("must be a player", new Object[0]);
        }
        EntityPlayerMP player = (EntityPlayerMP)sender;
        ItemStack heldItem = player.func_70694_bm();
        if (heldItem == null || !(heldItem.func_77973_b() instanceof ItemConstructableTrigger)) {
            throw new WrongUsageException("must hold a hologram", new Object[0]);
        }
        switch (args[0]) {
            case "getall": {
                if (!ChannelDataAccessor.hasSubChannel(heldItem)) {
                    sender.func_145747_a((IChatComponent)new ChatComponentText("No subchannel"));
                } else {
                    sender.func_145747_a((IChatComponent)new ChatComponentTranslation("item.structurelib.constructableTrigger.desc.lshift.0", new Object[]{ChannelDataAccessor.countChannelData(heldItem)}));
                    ChannelDataAccessor.iterateChannelData(heldItem).map(e -> (String)e.getKey() + ": " + e.getValue()).map(ChatComponentText::new).forEach(arg_0 -> ((EntityPlayerMP)player).func_145747_a(arg_0));
                }
                return;
            }
            case "wipe": {
                ChannelDataAccessor.wipeChannelData(heldItem);
                return;
            }
            case "get": 
            case "unset": {
                if (args.length < 2) {
                    throw new WrongUsageException(this.func_71518_a(sender), new Object[0]);
                }
                channel = args.length == 2 ? args[1] : Arrays.stream(args).skip(1L).collect(Collectors.joining());
                break;
            }
            case "set": {
                if (args.length < 3) {
                    throw new WrongUsageException(this.func_71518_a(sender), new Object[0]);
                }
                channel = args.length == 3 ? args[1] : Arrays.stream(args).skip(1L).limit(args.length - 2).collect(Collectors.joining());
                break;
            }
            default: {
                throw new WrongUsageException(this.func_71518_a(sender), new Object[0]);
            }
        }
        switch (args[0]) {
            case "get": {
                if (ChannelDataAccessor.hasSubChannel(heldItem, channel)) {
                    sender.func_145747_a((IChatComponent)new ChatComponentText(channel + " value: " + ChannelDataAccessor.getChannelData(heldItem, channel)));
                    break;
                }
                sender.func_145747_a((IChatComponent)new ChatComponentText(channel + " value: N/A"));
                break;
            }
            case "clear": {
                if (ChannelDataAccessor.hasSubChannel(heldItem, channel)) {
                    sender.func_145747_a((IChatComponent)new ChatComponentText(channel + " no value"));
                    break;
                }
                ChannelDataAccessor.unsetChannelData(heldItem, channel);
                sender.func_145747_a((IChatComponent)new ChatComponentText(channel + " cleared"));
                player.field_71069_bz.func_75142_b();
                break;
            }
            case "set": {
                int value;
                try {
                    value = Integer.parseInt(args[args.length - 1]);
                }
                catch (NumberFormatException e2) {
                    throw new WrongUsageException("%s not a valid value", new Object[]{args[args.length - 1]});
                }
                if (value <= 0) {
                    throw new WrongUsageException("%s not a valid value", new Object[]{args[args.length - 1]});
                }
                ChannelDataAccessor.setChannelData(heldItem, channel, value);
                player.field_71069_bz.func_75142_b();
                sender.func_145747_a((IChatComponent)new ChatComponentText(channel + " value: " + value));
            }
        }
    }
}

