/*
 * Decompiled with CFR 0.152.
 */
package greymerk.roguelike.config;

import greymerk.roguelike.config.Configuration;
import greymerk.roguelike.config.ConfigurationParser;
import java.io.BufferedReader;
import java.io.Writer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class INIParser
implements ConfigurationParser {
    private static final String comment_regex = "^#";
    private static final String line_regex = "^([^=]+)=(.*)$";
    private Pattern line_pattern = Pattern.compile("^([^=]+)=(.*)$");
    private Pattern comment_pattern = Pattern.compile("^#");

    @Override
    public Configuration Parse(BufferedReader reader) throws Exception {
        String value;
        String key;
        Matcher matcher;
        String line;
        do {
            if ((line = reader.readLine()) != null) continue;
            return null;
        } while ((line = line.trim()).length() == 0 || this.comment_pattern.matcher(line).find() || !(matcher = this.line_pattern.matcher(line)).find() || (key = matcher.group(1).trim()).length() == 0 || (value = matcher.group(2).trim()).length() == 0);
        return new Configuration(key, value);
    }

    @Override
    public void Write(Writer writer, Configuration config) throws Exception {
        writer.write(config.Key);
        writer.write("=");
        writer.write(config.Value);
        writer.write(System.getProperty("line.separator"));
    }
}

