/*
 * Decompiled with CFR 0.152.
 */
package locusway.overloadedarmorbar;

import cpw.mods.fml.client.event.ConfigChangedEvent;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import java.io.File;
import net.minecraftforge.common.config.Configuration;

public class ConfigurationHandler {
    public static Configuration config;
    public static String[] colorValues;
    public static boolean alwaysShowArmorBar;
    public static boolean showEmptyArmorIcons;
    public static boolean offset;

    public static void init(String configDir) {
        if (config == null) {
            File path = new File(configDir + "/" + "overloadedarmorbar" + ".cfg");
            config = new Configuration(path);
            ConfigurationHandler.loadConfiguration();
        }
    }

    private static void loadConfiguration() {
        alwaysShowArmorBar = config.getBoolean("Always Show armor bar?", "general", false, "Always show armor bar");
        colorValues = config.getStringList("Armor Icon Colors", "general", new String[]{"#FFFFFF", "#FF5500", "#FFC747", "#27FFE3", "#00FF00", "#7F00FF"}, "Colors must be specified in #RRGGBB format");
        offset = config.getBoolean("Override for Armor shift", "general", false, "Set to true if the armor bar display's incorrectly");
        showEmptyArmorIcons = config.getBoolean("Show empty armor icons?", "general", false, "Show empty armor icons");
        if (config.hasChanged()) {
            config.save();
        }
    }

    @SubscribeEvent
    public void onConfigurationChangeEvent(ConfigChangedEvent.OnConfigChangedEvent event) {
        if (event.modID.equalsIgnoreCase("overloadedarmorbar")) {
            ConfigurationHandler.loadConfiguration();
        }
    }

    public static Configuration getConfig() {
        return config;
    }

    static {
        colorValues = new String[]{"#FFFFFF", "#FF5500", "#FFC747", "#27FFE3", "#00FF00", "#7F00FF"};
        alwaysShowArmorBar = false;
        showEmptyArmorIcons = false;
        offset = false;
    }
}

