/*
 * Decompiled with CFR 0.152.
 */
package ca.wescook.nutrition.utility;

import ca.wescook.nutrition.data.PlayerDataHandler;
import ca.wescook.nutrition.network.Sync;
import ca.wescook.nutrition.nutrients.Nutrient;
import ca.wescook.nutrition.nutrients.NutrientList;
import ca.wescook.nutrition.utility.DataImporter;
import com.google.common.primitives.Floats;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import net.minecraft.command.CommandBase;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.IChatComponent;

public class ChatCommand
extends CommandBase {
    private final List<String> playerSubCommands = Arrays.asList("get", "set", "add", "subtract", "reset");
    private final String helpString = "/nutrition <get/set/add/subtract/reset/reload> <player> <nutrient> <value>";

    public String func_71517_b() {
        return "nutrition";
    }

    public String func_71518_a(ICommandSender sender) {
        return "/nutrition <get/set/add/subtract/reset/reload> <player> <nutrient> <value>";
    }

    public int func_82362_a() {
        return 2;
    }

    public List<String> func_71516_a(ICommandSender sender, String[] args) {
        if (args.length == 1) {
            return ChatCommand.func_71531_a((String[])args, Arrays.asList("get", "set", "add", "subtract", "reset", "reload"));
        }
        if (args.length == 2 && this.playerSubCommands.contains(args[0])) {
            return ChatCommand.func_71530_a((String[])args, (String[])MinecraftServer.func_71276_C().func_71213_z());
        }
        if (args.length == 3) {
            ArrayList<String> nutrientList = new ArrayList<String>();
            for (Nutrient nutrient : NutrientList.get()) {
                nutrientList.add(nutrient.name);
            }
            return ChatCommand.func_71531_a((String[])args, nutrientList);
        }
        return Collections.emptyList();
    }

    public void func_71515_b(ICommandSender sender, String[] args) {
        EntityPlayerMP player = null;
        if (args.length > 0 && this.playerSubCommands.contains(args[0])) {
            player = CommandBase.func_82359_c((ICommandSender)sender, (String)args[1]);
        }
        if (args.length == 0 || args[0].equals("help")) {
            this.commandHelp(sender);
        } else if (args[0].equals("get")) {
            this.commandGetNutrition((EntityPlayer)player, sender, args);
        } else if (args[0].equals("set")) {
            this.commandSetNutrition((EntityPlayer)player, sender, args, actions.SET);
        } else if (args[0].equals("add")) {
            this.commandSetNutrition((EntityPlayer)player, sender, args, actions.ADD);
        } else if (args[0].equals("subtract")) {
            this.commandSetNutrition((EntityPlayer)player, sender, args, actions.SUBTRACT);
        } else if (args[0].equals("reset")) {
            this.commandResetNutrition((EntityPlayer)player, sender, args);
        } else if (args[0].equals("reload")) {
            this.commandReload(sender);
        }
    }

    private void commandHelp(ICommandSender sender) {
        sender.func_145747_a((IChatComponent)new ChatComponentText("/nutrition <get/set/add/subtract/reset/reload> <player> <nutrient> <value>"));
    }

    private void commandReload(ICommandSender sender) {
        DataImporter.reload();
        DataImporter.updatePlayerCapabilitiesOnServer(MinecraftServer.func_71276_C());
        sender.func_145747_a((IChatComponent)new ChatComponentText("Nutrients and effects reloaded"));
    }

    private void commandGetNutrition(EntityPlayer player, ICommandSender sender, String[] args) {
        Nutrient nutrient = NutrientList.getByName(args[2]);
        if (nutrient != null) {
            Float nutrientValue = PlayerDataHandler.getForPlayer(player).get(nutrient);
            sender.func_145747_a((IChatComponent)new ChatComponentText(nutrient.name + ": " + String.format("%.2f", nutrientValue) + "%"));
        } else {
            sender.func_145747_a((IChatComponent)new ChatComponentText("'" + args[2] + "' is not a valid nutrient"));
        }
    }

    private void commandSetNutrition(EntityPlayer player, ICommandSender sender, String[] args, actions action) {
        if (!this.validNumber(sender, args[3])) {
            return;
        }
        Nutrient nutrient = NutrientList.getByName(args[2]);
        if (nutrient != null) {
            if (action == actions.SET) {
                PlayerDataHandler.getForPlayer(player).set(nutrient, Float.valueOf(Float.parseFloat(args[3])));
            } else if (action == actions.ADD) {
                PlayerDataHandler.getForPlayer(player).add(nutrient, Float.parseFloat(args[3]));
            } else if (action == actions.SUBTRACT) {
                PlayerDataHandler.getForPlayer(player).subtract(nutrient, Float.parseFloat(args[3]));
            }
            Sync.serverRequest(player);
            sender.func_145747_a((IChatComponent)new ChatComponentText(nutrient.name + " updated!"));
        } else {
            sender.func_145747_a((IChatComponent)new ChatComponentText("'" + args[2] + "' is not a valid nutrient"));
        }
    }

    private void commandResetNutrition(EntityPlayer player, ICommandSender sender, String[] args) {
        if (args.length == 3) {
            Nutrient nutrient = NutrientList.getByName(args[2]);
            if (nutrient != null) {
                PlayerDataHandler.getForPlayer(player).reset(nutrient);
                sender.func_145747_a((IChatComponent)new ChatComponentText("Nutrient " + nutrient.name + " reset for " + player.func_146103_bH().getName() + "!"));
            }
        } else if (args.length == 2) {
            PlayerDataHandler.getForPlayer(player).reset();
            sender.func_145747_a((IChatComponent)new ChatComponentText("Nutrition reset for " + player.func_146103_bH().getName() + "!"));
        }
        Sync.serverRequest(player);
    }

    private boolean validNumber(ICommandSender sender, String value) {
        if (Floats.tryParse((String)value) == null) {
            sender.func_145747_a((IChatComponent)new ChatComponentText("'" + value + "' is not a number."));
            return false;
        }
        float newValue = Float.parseFloat(value);
        if (!(newValue >= 0.0f) || !(newValue <= 100.0f)) {
            sender.func_145747_a((IChatComponent)new ChatComponentText("'" + value + "' is not a number between 0 and 100."));
            return false;
        }
        return true;
    }

    private static enum actions {
        SET,
        ADD,
        SUBTRACT;

    }
}

