/*
 * Decompiled with CFR 0.152.
 */
package com.gtnewhorizons.modularui.common.widget;

import codechicken.lib.math.MathHelper;
import com.gtnewhorizons.modularui.api.drawable.UITexture;
import com.gtnewhorizons.modularui.api.math.Pos2d;
import com.gtnewhorizons.modularui.api.math.Size;
import com.gtnewhorizons.modularui.common.widget.SyncedWidget;
import com.gtnewhorizons.modularui.config.Config;
import java.io.IOException;
import java.util.function.Supplier;
import net.minecraft.network.PacketBuffer;
import org.jetbrains.annotations.NotNull;

public class ProgressBar
extends SyncedWidget {
    private Supplier<Float> progress;
    private UITexture emptyTexture;
    private final UITexture[] fullTexture = new UITexture[4];
    private Direction direction = Direction.RIGHT;
    private int imageSize = -1;
    private float lastProgress;

    @Override
    public void onInit() {
        if (this.direction == Direction.CIRCULAR_CW && this.fullTexture[0] != null) {
            UITexture base = this.fullTexture[0];
            this.fullTexture[0] = base.getSubArea(0.0f, 0.5f, 0.5f, 1.0f);
            this.fullTexture[1] = base.getSubArea(0.0f, 0.0f, 0.5f, 0.5f);
            this.fullTexture[2] = base.getSubArea(0.5f, 0.0f, 1.0f, 0.5f);
            this.fullTexture[3] = base.getSubArea(0.5f, 0.5f, 1.0f, 1.0f);
        }
    }

    @Override
    public void onRebuild() {
        if (this.imageSize < 0) {
            this.imageSize = this.size.width;
        }
    }

    @Override
    public void draw(float partialTicks) {
        float progress;
        if (this.emptyTexture != null) {
            this.emptyTexture.draw(Pos2d.ZERO, this.getSize(), partialTicks);
        }
        float f = progress = this.syncsToClient() ? this.lastProgress : this.progress.get().floatValue();
        if (this.fullTexture[0] != null && progress > 0.0f) {
            if (this.direction == Direction.CIRCULAR_CW) {
                this.drawCircular(progress);
                return;
            }
            if (progress >= 1.0f) {
                this.fullTexture[0].draw(Pos2d.ZERO, this.getSize(), partialTicks);
            } else {
                progress = this.getProgressUV(progress);
                float u0 = 0.0f;
                float v0 = 0.0f;
                float u1 = 1.0f;
                float v1 = 1.0f;
                float x = 0.0f;
                float y = 0.0f;
                float width = this.size.width;
                float height = this.size.height;
                switch (this.direction) {
                    case RIGHT: {
                        u1 = progress;
                        width *= progress;
                        break;
                    }
                    case LEFT: {
                        u0 = 1.0f - progress;
                        x = (float)this.size.width - (width *= progress);
                        break;
                    }
                    case DOWN: {
                        v1 = progress;
                        height *= progress;
                        break;
                    }
                    case UP: {
                        v0 = 1.0f - progress;
                        y = (float)this.size.height - (height *= progress);
                    }
                }
                this.fullTexture[0].drawSubArea(x, y, width, height, u0, v0, u1, v1);
            }
        }
    }

    public float getProgressUV(float uv) {
        if (Config.smoothProgressbar) {
            return uv;
        }
        return (float)(Math.floor(uv * (float)this.imageSize) / (double)this.imageSize);
    }

    private void drawCircular(float progress) {
        float[] subAreas = new float[]{this.getProgressUV((float)MathHelper.clip((double)(progress / 0.25f), (double)0.0, (double)1.0)), this.getProgressUV((float)MathHelper.clip((double)((progress - 0.25f) / 0.25f), (double)0.0, (double)1.0)), this.getProgressUV((float)MathHelper.clip((double)((progress - 0.5f) / 0.25f), (double)0.0, (double)1.0)), this.getProgressUV((float)MathHelper.clip((double)((progress - 0.75f) / 0.25f), (double)0.0, (double)1.0))};
        float halfWidth = (float)this.size.width / 2.0f;
        float halfHeight = (float)this.size.height / 2.0f;
        float progressScaled = subAreas[0] * halfHeight;
        this.fullTexture[0].drawSubArea(0.0f, (float)this.size.height - progressScaled, halfWidth, progressScaled, 0.0f, 1.0f - progressScaled / halfHeight, 1.0f, 1.0f);
        progressScaled = subAreas[1] * halfWidth;
        this.fullTexture[1].drawSubArea(0.0f, 0.0f, progressScaled, halfHeight, 0.0f, 0.0f, progressScaled / halfWidth, 1.0f);
        progressScaled = subAreas[2] * halfHeight;
        this.fullTexture[2].drawSubArea(halfWidth, 0.0f, halfWidth, progressScaled, 0.0f, 0.0f, 1.0f, progressScaled / halfHeight);
        progressScaled = subAreas[3] * halfWidth;
        this.fullTexture[3].drawSubArea((float)this.size.width - progressScaled, halfHeight, progressScaled, halfHeight, 1.0f - progressScaled / halfWidth, 0.0f, 1.0f, 1.0f);
    }

    @Override
    @NotNull
    protected Size determineSize(int maxWidth, int maxHeight) {
        return new Size(20, 20);
    }

    @Override
    public boolean syncsToServer() {
        return false;
    }

    @Override
    public void readOnClient(int id, PacketBuffer buf) throws IOException {
        if (id == 0) {
            this.lastProgress = buf.readFloat();
        }
    }

    @Override
    public void readOnServer(int id, PacketBuffer buf) throws IOException {
    }

    @Override
    public void detectAndSendChanges(boolean init) {
        if (!this.syncsToClient()) {
            return;
        }
        float newProgress = this.progress.get().floatValue();
        if (init || newProgress != this.lastProgress) {
            this.lastProgress = newProgress;
            this.syncToClient(0, buffer -> buffer.writeFloat(this.lastProgress));
        }
    }

    @Override
    public void markForUpdate() {
    }

    @Override
    public void unMarkForUpdate() {
    }

    @Override
    public boolean isMarkedForUpdate() {
        return false;
    }

    public ProgressBar setProgress(Supplier<Float> progress) {
        this.progress = progress;
        return this;
    }

    public ProgressBar setProgress(float progress) {
        this.progress = () -> Float.valueOf(progress);
        return this;
    }

    public ProgressBar setTexture(UITexture emptyTexture, UITexture fullTexture, int imageSize) {
        this.emptyTexture = emptyTexture;
        this.fullTexture[0] = fullTexture;
        this.imageSize = imageSize;
        return this;
    }

    public ProgressBar setTexture(UITexture texture, int imageSize) {
        return this.setTexture(texture.getSubArea(0.0f, 0.0f, 1.0f, 0.5f), texture.getSubArea(0.0f, 0.5f, 1.0f, 1.0f), imageSize);
    }

    public ProgressBar setDirection(Direction direction) {
        this.direction = direction;
        return this;
    }

    public static enum Direction {
        LEFT,
        RIGHT,
        UP,
        DOWN,
        CIRCULAR_CW;

    }
}

