/*
 * Decompiled with CFR 0.152.
 */
package com.gtnewhorizons.modularui.common.widget;

import com.gtnewhorizons.modularui.ModularUI;
import com.gtnewhorizons.modularui.api.math.Size;
import com.gtnewhorizons.modularui.api.widget.IWidgetParent;
import com.gtnewhorizons.modularui.api.widget.Widget;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class MultiChildWidget
extends Widget
implements IWidgetParent {
    protected final List<Widget> children = new ArrayList<Widget>();

    public MultiChildWidget addChild(Widget widget) {
        if (MultiChildWidget.checkChild(this, widget)) {
            this.children.add(widget);
            this.checkNeedsRebuild();
        }
        return this;
    }

    public void removeChild(Widget widget) {
        if (MultiChildWidget.checkEditable(this)) {
            this.children.remove(widget);
            this.checkNeedsRebuild();
        }
    }

    public void removeChild(int index) {
        if (MultiChildWidget.checkEditable(this)) {
            this.children.remove(index);
            this.checkNeedsRebuild();
        }
    }

    @Override
    public List<Widget> getChildren() {
        return Collections.unmodifiableList(this.children);
    }

    @Override
    @NotNull
    protected Size determineSize(int maxWidth, int maxHeight) {
        if (!this.getChildren().isEmpty()) {
            return IWidgetParent.getSizeOf(this.getChildren());
        }
        return new Size(maxWidth, maxHeight);
    }

    @Deprecated
    public static Size getSizeOf(List<Widget> widgets) {
        return IWidgetParent.getSizeOf(widgets);
    }

    public static boolean checkChild(Widget parent, Widget widget) {
        if (widget == null) {
            ModularUI.logger.error("Tried adding null widget to " + parent.getClass().getSimpleName());
            return false;
        }
        if (widget == parent) {
            ModularUI.logger.error("Can't add self!");
            return false;
        }
        return MultiChildWidget.checkEditable(parent);
    }

    public static boolean checkEditable(Widget parent) {
        if (parent.isInitialised() && !parent.getContext().isClientOnly()) {
            throw new IllegalStateException("Can only dynamically add/remove widgets when the ui is client only!");
        }
        return true;
    }
}

