/*
 * Decompiled with CFR 0.152.
 */
package com.gtnewhorizons.modularui.common.internal.network;

import com.google.common.base.Charsets;
import com.gtnewhorizons.modularui.ModularUI;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.relauncher.Side;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.nio.charset.StandardCharsets;
import java.util.function.Consumer;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTSizeTracker;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.fluids.FluidStack;
import org.jetbrains.annotations.Nullable;

public class NetworkUtils {
    public static final Consumer<PacketBuffer> EMPTY_PACKET = buffer -> {};
    private static final Method CompressedStreamTools$func_150663_a;
    private static final Method CompressedStreamTools$func_152455_a;

    public static boolean isDedicatedClient() {
        return FMLCommonHandler.instance().getSide().isClient();
    }

    public static boolean isClient() {
        return FMLCommonHandler.instance().getEffectiveSide() == Side.CLIENT;
    }

    public static void writePacketBuffer(PacketBuffer writeTo, PacketBuffer writeFrom) {
        writeTo.func_150787_b(writeFrom.readableBytes());
        writeTo.writeBytes((ByteBuf)writeFrom);
    }

    public static PacketBuffer readPacketBuffer(PacketBuffer buf) {
        ByteBuf directSliceBuffer = buf.readBytes(buf.func_150792_a());
        ByteBuf copiedDataBuffer = Unpooled.copiedBuffer((ByteBuf)directSliceBuffer);
        directSliceBuffer.release();
        return new PacketBuffer(copiedDataBuffer);
    }

    public static void writeFluidStack(PacketBuffer buffer, @Nullable FluidStack fluidStack) {
        if (fluidStack == null) {
            buffer.writeBoolean(true);
        } else {
            buffer.writeBoolean(false);
            NBTTagCompound fluidStackTag = fluidStack.writeToNBT(new NBTTagCompound());
            try {
                buffer.func_150786_a(fluidStackTag);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    @Nullable
    public static FluidStack readFluidStack(PacketBuffer buffer) throws IOException {
        if (buffer.readBoolean()) {
            return null;
        }
        return FluidStack.loadFluidStackFromNBT((NBTTagCompound)buffer.func_150793_b());
    }

    public static void writeStringSafe(PacketBuffer buffer, String string) {
        byte[] bytes;
        if (string == null) {
            buffer.func_150787_b(-1);
            return;
        }
        byte[] bytesTest = string.getBytes(StandardCharsets.UTF_8);
        if (bytesTest.length > Short.MAX_VALUE) {
            bytes = new byte[Short.MAX_VALUE];
            System.arraycopy(bytesTest, 0, bytes, 0, Short.MAX_VALUE);
            ModularUI.logger.warn("Warning! Synced string exceeds max length!");
        } else {
            bytes = bytesTest;
        }
        buffer.func_150787_b(bytes.length);
        buffer.writeBytes(bytes);
    }

    public static String readStringSafe(PacketBuffer buffer, int maxLength) {
        String string;
        int length = buffer.func_150792_a();
        if (length == -1) {
            return null;
        }
        if (length > maxLength * 4) {
            ModularUI.logger.warn("Warning! Received string exceeds max length!");
        }
        if ((string = new String(buffer.readBytes(Math.min(length, maxLength * 4)).array(), Charsets.UTF_8)).length() > maxLength) {
            return string.substring(0, maxLength);
        }
        return string;
    }

    public static String readStringSafe(PacketBuffer buffer) {
        return NetworkUtils.readStringSafe(buffer, Short.MAX_VALUE);
    }

    public static void writeNBTBase(PacketBuffer buffer, NBTBase nbt) throws IOException {
        if (nbt == null) {
            buffer.writeShort(-1);
        } else {
            byte[] abyte = NetworkUtils.compressNBTBase(nbt);
            buffer.writeShort((int)((short)abyte.length));
            buffer.writeBytes(abyte);
        }
    }

    public static NBTBase readNBTBase(PacketBuffer buffer) throws IOException {
        short short1 = buffer.readShort();
        if (short1 < 0) {
            return null;
        }
        byte[] abyte = new byte[short1];
        buffer.readBytes(abyte);
        return NetworkUtils.read(abyte, new NBTSizeTracker(0x200000L));
    }

    private static byte[] compressNBTBase(NBTBase nbt) throws IOException {
        ByteArrayOutputStream bytearrayoutputstream = new ByteArrayOutputStream();
        try (DataOutputStream dataoutputstream = new DataOutputStream(new GZIPOutputStream(bytearrayoutputstream));){
            CompressedStreamTools$func_150663_a.invoke(null, nbt, dataoutputstream);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
        return bytearrayoutputstream.toByteArray();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static NBTBase read(byte[] abyte, NBTSizeTracker accounter) throws IOException {
        NBTBase nbt;
        try (DataInputStream datainputstream = new DataInputStream(new BufferedInputStream(new GZIPInputStream(new ByteArrayInputStream(abyte))));){
            nbt = NetworkUtils.read(datainputstream, accounter);
        }
        return nbt;
    }

    private static NBTBase read(DataInput input, NBTSizeTracker accounter) {
        try {
            return (NBTBase)CompressedStreamTools$func_152455_a.invoke(null, input, 0, accounter);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    static {
        try {
            CompressedStreamTools$func_150663_a = CompressedStreamTools.class.getDeclaredMethod("func_150663_a", NBTBase.class, DataOutput.class);
            CompressedStreamTools$func_150663_a.setAccessible(true);
            CompressedStreamTools$func_152455_a = CompressedStreamTools.class.getDeclaredMethod("func_152455_a", DataInput.class, Integer.TYPE, NBTSizeTracker.class);
            CompressedStreamTools$func_152455_a.setAccessible(true);
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException(e);
        }
    }
}

