/*
 * Decompiled with CFR 0.152.
 */
package com.kuba6000.mobsinfo.mixin;

import com.google.common.io.Files;
import java.nio.file.Path;

public enum TargetedMod {
    VANILLA("Minecraft", "unused", true),
    INFERNAL_MOBS("InfernalMobs", "InfernalMobs-", true),
    ENDER_IO("EnderIO", "EnderIO", true),
    DRACONIC_EVOLUTION("DraconicEvolution", "Draconic-Evolution-", true),
    DQ_RESPECT("DQMIIINext", "[1.7.10]DQRmod", true),
    CHOCO_CRAFT("chococraft", "ChocoCraftPlus-", true),
    BATTLE_GEAR_2("battlegear2", "battlegear2-", true),
    HARDCORE_ENDER_EXPANSION("HardcoreEnderExpansion", "HardcoreEnderExpansion-", true),
    FORESTRY("Forestry", "Forestry-", true);

    public final String modName;
    public final String jarNamePrefixLowercase;
    public final boolean loadInDevelopment;

    private TargetedMod(String modName, String jarNamePrefix, boolean loadInDevelopment) {
        this.modName = modName;
        this.jarNamePrefixLowercase = jarNamePrefix.toLowerCase();
        this.loadInDevelopment = loadInDevelopment;
    }

    public boolean isMatchingJar(Path path) {
        String pathString = path.toString();
        String nameLowerCase = Files.getNameWithoutExtension((String)pathString).toLowerCase();
        String fileExtension = Files.getFileExtension((String)pathString);
        return nameLowerCase.startsWith(this.jarNamePrefixLowercase) && "jar".equals(fileExtension);
    }

    public String toString() {
        return "TargetedMod{modName='" + this.modName + '\'' + ", jarNamePrefixLowercase='" + this.jarNamePrefixLowercase + '\'' + '}';
    }
}

