/*
 * Decompiled with CFR 0.152.
 */
package com.kuba6000.mobsinfo.api;

import com.kuba6000.mobsinfo.api.ConstructableItemStack;
import com.kuba6000.mobsinfo.api.IChanceModifier;
import com.kuba6000.mobsinfo.api.helper.ByteBufHelper;
import com.kuba6000.mobsinfo.api.utils.GSONUtils;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.util.ArrayList;
import java.util.HashMap;
import net.minecraft.item.ItemStack;

public class MobDrop {
    @GSONUtils.SkipGSON
    public ItemStack stack;
    public ConstructableItemStack reconstructableStack;
    public DropType type;
    public int chance;
    public Integer enchantable;
    public HashMap<Integer, Integer> damages;
    public boolean lootable = false;
    public boolean playerOnly = false;
    public boolean variableChance = false;
    public ArrayList<IChanceModifier> chanceModifiers = new ArrayList();
    public ArrayList<String> additionalInfo = new ArrayList();
    private static final ByteBuf BufHelper = Unpooled.buffer();

    private MobDrop() {
    }

    public MobDrop(ItemStack stack, DropType type, int chance, Integer enchantable, HashMap<Integer, Integer> damages, boolean lootable, boolean playerOnly) {
        this.stack = stack;
        this.reconstructableStack = new ConstructableItemStack(stack);
        this.type = type;
        this.chance = chance;
        this.enchantable = enchantable;
        this.damages = damages;
        this.lootable = lootable;
        this.playerOnly = playerOnly;
    }

    public MobDrop copy() {
        MobDrop copy = new MobDrop(this.stack.func_77946_l(), this.type, this.chance, this.enchantable, this.damages == null ? null : (HashMap)this.damages.clone(), this.lootable, this.playerOnly);
        copy.variableChance = this.variableChance;
        copy.chanceModifiers = (ArrayList)this.chanceModifiers.clone();
        copy.additionalInfo = (ArrayList)this.additionalInfo.clone();
        return copy;
    }

    public void reconstructStack() {
        this.stack = this.reconstructableStack.construct();
    }

    public void clampChance() {
        if (this.chance > 10000) {
            int div = (int)Math.ceil((double)this.chance / 10000.0);
            this.stack.field_77994_a *= div;
            this.chance /= div;
            this.reconstructableStack = new ConstructableItemStack(this.stack);
        }
    }

    public void writeToByteBuf(ByteBuf byteBuf) {
        BufHelper.clear();
        this.reconstructableStack.writeToByteBuf(BufHelper);
        BufHelper.writeInt(this.type.ordinal());
        BufHelper.writeInt(this.chance);
        BufHelper.writeBoolean(this.enchantable != null);
        if (this.enchantable != null) {
            BufHelper.writeInt(this.enchantable.intValue());
        }
        BufHelper.writeBoolean(this.damages != null);
        if (this.damages != null) {
            BufHelper.writeInt(this.damages.size());
            this.damages.forEach((k, v) -> {
                BufHelper.writeInt(k.intValue());
                BufHelper.writeInt(v.intValue());
            });
        }
        BufHelper.writeBoolean(this.lootable);
        BufHelper.writeBoolean(this.playerOnly);
        BufHelper.writeBoolean(this.variableChance);
        if (this.variableChance) {
            BufHelper.writeInt(this.chanceModifiers.size());
            this.chanceModifiers.forEach(i -> IChanceModifier.saveToByteBuf(BufHelper, i));
        }
        if (this.additionalInfo == null) {
            BufHelper.writeInt(0);
        } else {
            BufHelper.writeInt(this.additionalInfo.size());
            this.additionalInfo.forEach(i -> ByteBufHelper.writeString(BufHelper, i));
        }
        byteBuf.writeInt(BufHelper.readableBytes());
        byteBuf.writeBytes(BufHelper);
    }

    public static MobDrop readFromByteBuf(ByteBuf byteBuf) {
        int i;
        MobDrop mobDrop = new MobDrop();
        int size = byteBuf.readInt();
        mobDrop.reconstructableStack = ConstructableItemStack.readFromByteBuf(byteBuf);
        mobDrop.type = DropType.get(byteBuf.readInt());
        mobDrop.chance = byteBuf.readInt();
        mobDrop.enchantable = byteBuf.readBoolean() ? Integer.valueOf(byteBuf.readInt()) : null;
        if (byteBuf.readBoolean()) {
            mobDrop.damages = new HashMap();
            int damagessize = byteBuf.readInt();
            for (i = 0; i < damagessize; ++i) {
                mobDrop.damages.put(byteBuf.readInt(), byteBuf.readInt());
            }
        } else {
            mobDrop.damages = null;
        }
        mobDrop.lootable = byteBuf.readBoolean();
        mobDrop.playerOnly = byteBuf.readBoolean();
        mobDrop.variableChance = byteBuf.readBoolean();
        if (mobDrop.variableChance) {
            mobDrop.chanceModifiers = new ArrayList();
            int chanceModifiersSize = byteBuf.readInt();
            for (i = 0; i < chanceModifiersSize; ++i) {
                mobDrop.chanceModifiers.add(IChanceModifier.loadFromByteBuf(byteBuf));
            }
        }
        int additionalInfoSize = byteBuf.readInt();
        for (i = 0; i < additionalInfoSize; ++i) {
            mobDrop.additionalInfo.add(ByteBufHelper.readString(byteBuf));
        }
        mobDrop.reconstructStack();
        return mobDrop;
    }

    public static double getChanceBasedOnFromTo(int from, int to) {
        return ((double)to * (double)to + (double)to - (double)from * (double)from + (double)from) / (2.0 * ((double)to - (double)from + 1.0));
    }

    public static enum DropType {
        Normal,
        Rare,
        Additional,
        Infernal;

        private static final DropType[] values;

        public static DropType get(int ordinal) {
            return values[ordinal];
        }

        static {
            values = DropType.values();
        }
    }
}

