/*
 * Decompiled with CFR 0.152.
 */
package net.malisis.doors.door.tileentity;

import net.malisis.core.util.BlockPos;
import net.malisis.core.util.BlockState;
import net.malisis.core.util.TileEntityUtils;
import net.malisis.doors.door.DoorDescriptor;
import net.malisis.doors.door.DoorRegistry;
import net.malisis.doors.door.movement.FenceGateMovement;
import net.malisis.doors.door.tileentity.DoorTileEntity;
import net.minecraft.init.Blocks;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.S35PacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.common.util.ForgeDirection;
import org.apache.commons.lang3.tuple.Pair;

public class FenceGateTileEntity
extends DoorTileEntity {
    private BlockState camoState;
    private int camoColor;
    private boolean isWall;

    public FenceGateTileEntity() {
        DoorDescriptor descriptor = new DoorDescriptor();
        descriptor.setMovement(DoorRegistry.getMovement(FenceGateMovement.class));
        this.setDescriptor(descriptor);
    }

    public BlockState getCamoState() {
        return this.camoState;
    }

    public int getCamoColor() {
        return this.camoColor;
    }

    public boolean isWall() {
        return this.isWall;
    }

    public void updateAll() {
        if (!this.field_145850_b.field_72995_K) {
            return;
        }
        Pair<BlockState, Integer> pair = this.updateCamo();
        this.camoState = (BlockState)pair.getLeft();
        this.camoColor = (Integer)pair.getRight();
        this.isWall = this.updateWall();
        this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
    }

    private Pair<BlockState, Integer> updateCamo() {
        BlockPos pos = new BlockPos(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        ForgeDirection dir = this.getDirection() == 0 || this.getDirection() == 2 ? ForgeDirection.EAST : ForgeDirection.NORTH;
        BlockPos p = pos.offset(dir);
        FenceGateTileEntity te = (FenceGateTileEntity)((Object)TileEntityUtils.getTileEntity(FenceGateTileEntity.class, (IBlockAccess)this.field_145850_b, (BlockPos)p));
        if (te != null && this.isMatchingDoubleDoor(te)) {
            p = p.offset(dir);
        }
        BlockState state1 = new BlockState((IBlockAccess)this.field_145850_b, p);
        int color1 = state1.getBlock().func_149720_d((IBlockAccess)this.field_145850_b, p.getX(), p.getY(), p.getZ());
        if (state1.getBlock().isAir((IBlockAccess)this.field_145850_b, p.getX(), p.getY(), p.getZ())) {
            return Pair.of((Object)new BlockState((IBlockAccess)this.field_145850_b, pos), (Object)-1);
        }
        p = pos.offset(dir = dir.getOpposite());
        te = (FenceGateTileEntity)((Object)TileEntityUtils.getTileEntity(FenceGateTileEntity.class, (IBlockAccess)this.field_145850_b, (BlockPos)p));
        if (te != null && this.isMatchingDoubleDoor(te)) {
            p = p.offset(dir);
        }
        BlockState state2 = new BlockState((IBlockAccess)this.field_145850_b, p);
        int color2 = state2.getBlock().func_149720_d((IBlockAccess)this.field_145850_b, p.getX(), p.getY(), p.getZ());
        if (state1.getBlock().isAir((IBlockAccess)this.field_145850_b, p.getX(), p.getY(), p.getZ())) {
            return Pair.of((Object)new BlockState((IBlockAccess)this.field_145850_b, pos), (Object)-1);
        }
        if (state1.getBlock() != state2.getBlock() || state1.getMetadata() != state2.getMetadata() || color1 != color2) {
            return Pair.of((Object)new BlockState((IBlockAccess)this.field_145850_b, pos), (Object)-1);
        }
        return Pair.of((Object)state1, (Object)color1);
    }

    private boolean updateWall() {
        BlockPos pos = new BlockPos(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        ForgeDirection dir = this.getDirection() == 1 || this.getDirection() == 3 ? ForgeDirection.EAST : ForgeDirection.NORTH;
        BlockState state = new BlockState((IBlockAccess)this.field_145850_b, pos.offset(dir));
        if (state.getBlock() == Blocks.field_150463_bK) {
            return true;
        }
        state = new BlockState((IBlockAccess)this.field_145850_b, pos.offset(dir.getOpposite()));
        return state.getBlock() == Blocks.field_150463_bK;
    }

    public IIcon getCamoIcon() {
        if (this.camoState == null) {
            return this.func_145838_q().func_149691_a(0, 0);
        }
        return this.camoState.getBlock().func_149691_a(0, 0);
    }

    @Override
    public FenceGateTileEntity getDoubleDoor() {
        if (!this.descriptor.isDoubleDoor()) {
            return null;
        }
        int dir = this.getDirection();
        TileEntity te = null;
        if (dir == 1 || dir == 3) {
            te = this.field_145850_b.func_147438_o(this.field_145851_c, this.field_145848_d, this.field_145849_e + 1);
            if (te instanceof FenceGateTileEntity && this.isMatchingDoubleDoor((FenceGateTileEntity)te)) {
                return (FenceGateTileEntity)te;
            }
            te = this.field_145850_b.func_147438_o(this.field_145851_c, this.field_145848_d, this.field_145849_e - 1);
            if (te instanceof DoorTileEntity && this.isMatchingDoubleDoor((DoorTileEntity)te)) {
                return (FenceGateTileEntity)te;
            }
        } else {
            te = this.field_145850_b.func_147438_o(this.field_145851_c + 1, this.field_145848_d, this.field_145849_e);
            if (te instanceof FenceGateTileEntity && this.isMatchingDoubleDoor((DoorTileEntity)te)) {
                return (FenceGateTileEntity)te;
            }
            te = this.field_145850_b.func_147438_o(this.field_145851_c - 1, this.field_145848_d, this.field_145849_e);
            if (te instanceof FenceGateTileEntity && this.isMatchingDoubleDoor((DoorTileEntity)te)) {
                return (FenceGateTileEntity)te;
            }
        }
        return null;
    }

    @Override
    public boolean isMatchingDoubleDoor(DoorTileEntity te) {
        if (this.func_145838_q() != te.func_145838_q()) {
            return false;
        }
        if ((this.getDirection() == 1 || this.getDirection() == 3) != (te.getDirection() == 1 || te.getDirection() == 3)) {
            return false;
        }
        if (this.getMovement() != te.getMovement()) {
            return false;
        }
        return (this.func_145832_p() & 4) == (te.func_145832_p() & 4);
    }

    @Override
    public AxisAlignedBB getRenderBoundingBox() {
        return AxisAlignedBB.func_72330_a((double)this.field_145851_c, (double)this.field_145848_d, (double)this.field_145849_e, (double)(this.field_145851_c + 1), (double)(this.field_145848_d + 1), (double)(this.field_145849_e + 1));
    }

    @Override
    public void onDataPacket(NetworkManager net, S35PacketUpdateTileEntity packet) {
        super.onDataPacket(net, packet);
        this.updateAll();
    }
}

