/*
 * Decompiled with CFR 0.152.
 */
package net.malisis.core.util;

import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.List;
import net.malisis.core.block.BoundingBoxType;
import net.malisis.core.block.IBoundingBox;
import net.malisis.core.util.Point;
import net.malisis.core.util.Ray;
import net.malisis.core.util.Vector;
import net.minecraft.block.Block;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.Vec3;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import org.apache.commons.lang3.tuple.Pair;

public class RaytraceBlock {
    private WeakReference<World> world;
    private int x;
    private int y;
    private int z;
    private Block block;
    private Point src;
    private Point dest;
    private Ray ray;

    private RaytraceBlock(World world, Ray ray, int x, int y, int z) {
        this.world = new WeakReference<World>(world);
        this.src = ray.origin;
        this.ray = ray;
        this.x = x;
        this.y = y;
        this.z = z;
        this.block = this.world().func_147439_a(x, y, z);
    }

    public RaytraceBlock(World world, Point src, Vector v, int x, int y, int z) {
        this(world, new Ray(src, v), x, y, z);
    }

    public RaytraceBlock(World world, Point src, Point dest, int x, int y, int z) {
        this(world, new Ray(src, new Vector(src, dest)), x, y, z);
        this.dest = dest;
    }

    public RaytraceBlock(World world, Vec3 src, Vec3 dest, int x, int y, int z) {
        this(world, new Ray(src, dest), x, y, z);
        this.dest = new Point(dest);
    }

    public World world() {
        return (World)this.world.get();
    }

    public Vector direction() {
        return this.ray.direction;
    }

    public double distance() {
        return this.ray.direction.length();
    }

    public MovingObjectPosition trace() {
        if (!(this.block instanceof IBoundingBox)) {
            return this.block.func_149731_a(this.world(), this.x, this.y, this.z, this.ray.origin.toVec3(), this.dest.toVec3());
        }
        IBoundingBox block = (IBoundingBox)this.block;
        AxisAlignedBB[] aabbs = block.getBoundingBox((IBlockAccess)this.world(), this.x, this.y, this.z, BoundingBoxType.RAYTRACE);
        if (aabbs == null || aabbs.length == 0) {
            return null;
        }
        ArrayList<Pair<ForgeDirection, Point>> points = new ArrayList<Pair<ForgeDirection, Point>>();
        double maxDist = Point.distanceSquared(this.src, this.dest);
        for (AxisAlignedBB aabb : aabbs) {
            if (aabb == null) continue;
            aabb.func_72317_d((double)this.x, (double)this.y, (double)this.z);
            for (Pair<ForgeDirection, Point> pair : this.ray.intersect(aabb)) {
                if (!(Point.distanceSquared(this.src, (Point)pair.getRight()) < maxDist)) continue;
                points.add(pair);
            }
        }
        if (points.size() == 0) {
            return null;
        }
        Pair<ForgeDirection, Point> closest = this.getClosest(points);
        if (closest == null) {
            return null;
        }
        return new MovingObjectPosition(this.x, this.y, this.z, ((ForgeDirection)closest.getLeft()).ordinal(), ((Point)closest.getRight()).toVec3());
    }

    private Pair<ForgeDirection, Point> getClosest(List<Pair<ForgeDirection, Point>> points) {
        double distance = Double.MAX_VALUE;
        Pair<ForgeDirection, Point> ret = null;
        for (Pair<ForgeDirection, Point> pair : points) {
            double d = Point.distanceSquared(this.src, (Point)pair.getRight());
            if (!(distance > d)) continue;
            distance = d;
            ret = pair;
        }
        return ret;
    }
}

