/*
 * Decompiled with CFR 0.152.
 */
package net.malisis.core.inventory.message;

import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.common.network.simpleimpl.IMessageHandler;
import cpw.mods.fml.common.network.simpleimpl.MessageContext;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import io.netty.buffer.ByteBuf;
import net.malisis.core.MalisisCore;
import net.malisis.core.inventory.IInventoryProvider;
import net.malisis.core.inventory.MalisisInventory;
import net.malisis.core.network.MalisisMessage;
import net.malisis.core.util.TileEntityUtils;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityClientPlayerMP;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.IBlockAccess;

@MalisisMessage
public class OpenInventoryMessage
implements IMessageHandler<Packet, IMessage> {
    public OpenInventoryMessage() {
        MalisisCore.network.registerMessage(this, Packet.class, Side.CLIENT);
    }

    public IMessage onMessage(Packet message, MessageContext ctx) {
        if (ctx.side == Side.CLIENT) {
            this.openGui(message.type, message.x, message.y, message.z, message.windowId);
        }
        return null;
    }

    @SideOnly(value=Side.CLIENT)
    private void openGui(ContainerType type, int x, int y, int z, int windowId) {
        ItemStack itemStack;
        EntityClientPlayerMP player = Minecraft.func_71410_x().field_71439_g;
        IInventoryProvider inventoryProvider = null;
        ItemStack data = null;
        if (type == ContainerType.TYPE_TILEENTITY) {
            inventoryProvider = TileEntityUtils.getTileEntity(IInventoryProvider.class, (IBlockAccess)Minecraft.func_71410_x().field_71441_e, x, y, z);
        } else if (type == ContainerType.TYPE_ITEM && (itemStack = player.func_71045_bC()) != null && itemStack.func_77973_b() instanceof IInventoryProvider) {
            inventoryProvider = (IInventoryProvider)itemStack.func_77973_b();
            data = itemStack;
        }
        if (inventoryProvider != null) {
            MalisisInventory.open(player, inventoryProvider, windowId, data);
        }
    }

    public static void send(IInventoryProvider container, EntityPlayerMP player, int windowId) {
        Packet packet = new Packet(container, windowId);
        MalisisCore.network.sendTo(packet, player);
    }

    public static class Packet
    implements IMessage {
        private ContainerType type;
        private int x;
        private int y;
        private int z;
        private int windowId;

        public Packet() {
        }

        public Packet(IInventoryProvider container, int windowId) {
            this.windowId = windowId;
            if (container instanceof TileEntity) {
                this.type = ContainerType.TYPE_TILEENTITY;
                this.x = ((TileEntity)container).field_145851_c;
                this.y = ((TileEntity)container).field_145848_d;
                this.z = ((TileEntity)container).field_145849_e;
            }
            if (container instanceof Item) {
                this.type = ContainerType.TYPE_ITEM;
            }
        }

        public void fromBytes(ByteBuf buf) {
            this.type = ContainerType.values()[buf.readByte()];
            if (this.type == ContainerType.TYPE_TILEENTITY) {
                this.x = buf.readInt();
                this.y = buf.readInt();
                this.z = buf.readInt();
            }
            this.windowId = buf.readInt();
        }

        public void toBytes(ByteBuf buf) {
            buf.writeByte(this.type.ordinal());
            if (this.type == ContainerType.TYPE_TILEENTITY) {
                buf.writeInt(this.x);
                buf.writeInt(this.y);
                buf.writeInt(this.z);
            }
            buf.writeInt(this.windowId);
        }
    }

    public static enum ContainerType {
        TYPE_TILEENTITY,
        TYPE_ITEM;

    }
}

