/*
 * Decompiled with CFR 0.152.
 */
package net.malisis.core.inventory;

public class InventoryState {
    public static int PLAYER_INSERT = 1;
    public static int PLAYER_EXTRACT = 2;
    public static int AUTO_INSERT = 4;
    public static int AUTO_EXTRACT = 8;
    public static int FROZEN = 16;
    private int state = PLAYER_INSERT | PLAYER_EXTRACT | AUTO_INSERT | AUTO_EXTRACT;

    public int get() {
        return this.state;
    }

    public void set(int state) {
        this.state = state;
    }

    public void unset(int state) {
        this.state &= ~state;
    }

    public boolean is(int state) {
        return (this.state & state) == state;
    }

    public void allowPlayer() {
        this.state |= PLAYER_INSERT | PLAYER_EXTRACT;
    }

    public void denyPlayer() {
        this.state &= ~(PLAYER_INSERT | PLAYER_EXTRACT);
    }

    public void allowAutomation() {
        this.state |= AUTO_INSERT | AUTO_EXTRACT;
    }

    public void denyAutomation() {
        this.state &= ~(AUTO_INSERT | AUTO_EXTRACT);
    }

    public void freeze() {
        this.state |= FROZEN;
    }

    public void unfreeze() {
        this.state &= ~FROZEN;
    }
}

