/*
 * Decompiled with CFR 0.152.
 */
package com.jamesswafford.chess4j.hash;

import com.jamesswafford.chess4j.Color;
import com.jamesswafford.chess4j.board.Board;
import com.jamesswafford.chess4j.board.CastlingRights;
import com.jamesswafford.chess4j.board.squares.Square;
import com.jamesswafford.chess4j.pieces.Bishop;
import com.jamesswafford.chess4j.pieces.King;
import com.jamesswafford.chess4j.pieces.Knight;
import com.jamesswafford.chess4j.pieces.Pawn;
import com.jamesswafford.chess4j.pieces.Piece;
import com.jamesswafford.chess4j.pieces.Queen;
import com.jamesswafford.chess4j.pieces.Rook;
import com.jamesswafford.chess4j.utils.PieceFactory;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;

public final class Zobrist {
    private static Map<Piece, Long[]> pieceMap = new HashMap<Piece, Long[]>();
    private static Map<Color, Long> playerMap = new HashMap<Color, Long>();
    private static Map<CastlingRights, Long> castlingMap = new HashMap<CastlingRights, Long>();
    private static Map<Square, Long> epMap = new HashMap<Square, Long>();

    private Zobrist() {
    }

    private static void createZobristKeys(Piece p) {
        Random r = new Random();
        Long[] keys = new Long[64];
        for (int i = 0; i < keys.length; ++i) {
            keys[i] = r.nextLong();
        }
        pieceMap.put(p, keys);
    }

    public static long getPieceKey(Square sq, Piece p) {
        return pieceMap.get(p)[sq.value()];
    }

    public static long getPlayerKey(Color c) {
        return playerMap.get((Object)c);
    }

    public static long getCastlingKey(CastlingRights cr) {
        return castlingMap.get((Object)cr);
    }

    public static long getEnPassantKey(Square sq) {
        return epMap.get(sq);
    }

    public static long getPawnKey(Board b) {
        long key = 0L;
        List<Square> sqs = Square.allSquares();
        for (Square sq : sqs) {
            Piece p = b.getPiece(sq);
            if (!(p instanceof Pawn)) continue;
            key ^= Zobrist.getPieceKey(sq, p);
        }
        return key;
    }

    public static long getBoardKey(Board b) {
        long key = 0L;
        List<Square> sqs = Square.allSquares();
        for (Square square : sqs) {
            Piece p = b.getPiece(square);
            if (p == null) continue;
            key ^= Zobrist.getPieceKey(square, p);
        }
        EnumSet<CastlingRights> crs = EnumSet.allOf(CastlingRights.class);
        for (CastlingRights cr : crs) {
            if (!b.hasCastlingRight(cr)) continue;
            key ^= castlingMap.get((Object)cr).longValue();
        }
        Square square = b.getEPSquare();
        if (square != null) {
            key ^= epMap.get(square).longValue();
        }
        return key ^= playerMap.get((Object)b.getPlayerToMove()).longValue();
    }

    public static List<Long> getAllKeys() {
        String[] strPieces;
        ArrayList<Long> keys = new ArrayList<Long>();
        for (String strPiece : strPieces = new String[]{"P", "R", "N", "B", "Q", "K", "p", "r", "n", "b", "q", "k"}) {
            Piece piece = PieceFactory.getPiece(strPiece);
            Long[] pieceKeys = pieceMap.get(piece);
            for (int i = 0; i < 64; ++i) {
                keys.add(pieceKeys[i]);
            }
        }
        keys.add(playerMap.get((Object)Color.WHITE));
        keys.add(playerMap.get((Object)Color.BLACK));
        keys.add(castlingMap.get((Object)CastlingRights.BLACK_QUEENSIDE));
        keys.add(castlingMap.get((Object)CastlingRights.BLACK_KINGSIDE));
        keys.add(castlingMap.get((Object)CastlingRights.WHITE_QUEENSIDE));
        keys.add(castlingMap.get((Object)CastlingRights.WHITE_KINGSIDE));
        for (int i = 0; i < 64; ++i) {
            keys.add(epMap.get(Square.valueOf(i)));
        }
        return keys;
    }

    public static void setKeys(List<Long> keys) {
        String[] strPieces = new String[]{"P", "R", "N", "B", "Q", "K", "p", "r", "n", "b", "q", "k"};
        int ind = 0;
        for (String strPiece : strPieces) {
            Piece piece = PieceFactory.getPiece(strPiece);
            Long[] pieceKeys = new Long[64];
            for (int i = 0; i < 64; ++i) {
                pieceKeys[i] = keys.get(ind++);
            }
            pieceMap.put(piece, pieceKeys);
        }
        playerMap.put(Color.WHITE, keys.get(ind++));
        playerMap.put(Color.BLACK, keys.get(ind++));
        castlingMap.put(CastlingRights.BLACK_QUEENSIDE, keys.get(ind++));
        castlingMap.put(CastlingRights.BLACK_KINGSIDE, keys.get(ind++));
        castlingMap.put(CastlingRights.WHITE_QUEENSIDE, keys.get(ind++));
        castlingMap.put(CastlingRights.WHITE_KINGSIDE, keys.get(ind++));
        for (int i = 0; i < 64; ++i) {
            epMap.put(Square.valueOf(i), keys.get(ind++));
        }
    }

    static {
        Random r = new Random();
        Zobrist.createZobristKeys(Pawn.BLACK_PAWN);
        Zobrist.createZobristKeys(Pawn.WHITE_PAWN);
        Zobrist.createZobristKeys(Rook.BLACK_ROOK);
        Zobrist.createZobristKeys(Rook.WHITE_ROOK);
        Zobrist.createZobristKeys(Knight.BLACK_KNIGHT);
        Zobrist.createZobristKeys(Knight.WHITE_KNIGHT);
        Zobrist.createZobristKeys(Bishop.BLACK_BISHOP);
        Zobrist.createZobristKeys(Bishop.WHITE_BISHOP);
        Zobrist.createZobristKeys(Queen.BLACK_QUEEN);
        Zobrist.createZobristKeys(Queen.WHITE_QUEEN);
        Zobrist.createZobristKeys(King.BLACK_KING);
        Zobrist.createZobristKeys(King.WHITE_KING);
        playerMap.put(Color.BLACK, r.nextLong());
        playerMap.put(Color.WHITE, r.nextLong());
        EnumSet<CastlingRights> crs = EnumSet.allOf(CastlingRights.class);
        for (CastlingRights cr : crs) {
            castlingMap.put(cr, r.nextLong());
        }
        List<Square> sqs = Square.allSquares();
        for (Square sq : sqs) {
            epMap.put(sq, r.nextLong());
        }
    }
}

