/*
 * Decompiled with CFR 0.152.
 */
package com.jamesswafford.chess4j.board;

import com.jamesswafford.chess4j.board.squares.Square;
import com.jamesswafford.chess4j.pieces.Piece;

public class Move {
    private Square from;
    private Square to;
    private Piece captured;
    private Piece promotion;

    public Move(Square from, Square to) {
        this.from = from;
        this.to = to;
    }

    public Move(Square from, Square to, Piece captured) {
        this(from, to);
        this.captured = captured;
    }

    public Move(Square from, Square to, Piece captured, Piece promotion) {
        this(from, to, captured);
        this.promotion = promotion;
    }

    public Piece captured() {
        return this.captured;
    }

    public Square from() {
        return this.from;
    }

    public Piece promotion() {
        return this.promotion;
    }

    public Square to() {
        return this.to;
    }

    public String toString() {
        String s = this.from.toString() + this.to.toString();
        if (this.promotion != null) {
            s = s + "=" + this.promotion.toString();
        }
        return s;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof Move)) {
            return false;
        }
        Move mv = (Move)obj;
        if (!mv.from().equals(this.from())) {
            return false;
        }
        if (!mv.to().equals(this.to())) {
            return false;
        }
        if (mv.captured() == null ? this.captured() != null : !mv.captured().equals(this.captured())) {
            return false;
        }
        if (mv.promotion() == null) {
            return this.promotion() == null;
        }
        return mv.promotion().equals(this.promotion());
    }

    public int hashCode() {
        int hash = 1;
        hash = hash * 13 + this.from.hashCode();
        hash = hash * 17 + this.to.hashCode();
        hash = hash * 31 + (this.captured == null ? 0 : this.captured.hashCode());
        hash = hash * 37 + (this.promotion == null ? 0 : this.promotion.hashCode());
        return hash;
    }
}

