/*
 * Decompiled with CFR 0.152.
 */
package logisticspipes.pipes.upgrades;

import java.util.EnumSet;
import java.util.UUID;
import logisticspipes.LogisticsPipes;
import logisticspipes.interfaces.IGuiOpenControler;
import logisticspipes.interfaces.IPipeUpgradeManager;
import logisticspipes.interfaces.ISlotUpgradeManager;
import logisticspipes.network.NewGuiHandler;
import logisticspipes.network.guis.pipe.UpgradeManagerGui;
import logisticspipes.pipes.basic.CoreRoutedPipe;
import logisticspipes.pipes.upgrades.AdvancedSatelliteUpgrade;
import logisticspipes.pipes.upgrades.CCRemoteControlUpgrade;
import logisticspipes.pipes.upgrades.CombinedSneakyUpgrade;
import logisticspipes.pipes.upgrades.ConnectionUpgrade;
import logisticspipes.pipes.upgrades.CraftingByproductUpgrade;
import logisticspipes.pipes.upgrades.CraftingCleanupUpgrade;
import logisticspipes.pipes.upgrades.CraftingMonitoringUpgrade;
import logisticspipes.pipes.upgrades.FluidCraftingUpgrade;
import logisticspipes.pipes.upgrades.FuzzyUpgrade;
import logisticspipes.pipes.upgrades.IPipeUpgrade;
import logisticspipes.pipes.upgrades.LogicControllerUpgrade;
import logisticspipes.pipes.upgrades.OpaqueUpgrade;
import logisticspipes.pipes.upgrades.PatternUpgrade;
import logisticspipes.pipes.upgrades.PowerTransportationUpgrade;
import logisticspipes.pipes.upgrades.SneakyUpgrade;
import logisticspipes.pipes.upgrades.SpeedUpgrade;
import logisticspipes.pipes.upgrades.UpgradeModuleUpgrade;
import logisticspipes.pipes.upgrades.power.IC2PowerSupplierUpgrade;
import logisticspipes.pipes.upgrades.power.RFPowerSupplierUpgrade;
import logisticspipes.proxy.MainProxy;
import logisticspipes.proxy.SimpleServiceLocator;
import logisticspipes.utils.ISimpleInventoryEventHandler;
import logisticspipes.utils.PlayerCollectionList;
import logisticspipes.utils.gui.DummyContainer;
import logisticspipes.utils.item.SimpleStackInventory;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class UpgradeManager
implements ISimpleInventoryEventHandler,
ISlotUpgradeManager,
IPipeUpgradeManager {
    private final SimpleStackInventory inv = new SimpleStackInventory(9, "UpgradeInventory", 16);
    private final SimpleStackInventory sneakyInv = new SimpleStackInventory(9, "SneakyUpgradeInventory", 1);
    private final SimpleStackInventory secInv = new SimpleStackInventory(1, "SecurityInventory", 16);
    private final IPipeUpgrade[] upgrades = new IPipeUpgrade[9];
    private final IPipeUpgrade[] sneakyUpgrades = new IPipeUpgrade[9];
    private final CoreRoutedPipe pipe;
    private int securityDelay = 0;
    private ForgeDirection sneakyOrientation = ForgeDirection.UNKNOWN;
    private final ForgeDirection[] combinedSneakyOrientation = new ForgeDirection[9];
    private int speedUpgradeCount = 0;
    private final EnumSet<ForgeDirection> disconnectedSides = EnumSet.noneOf(ForgeDirection.class);
    private boolean isAdvancedCrafter = false;
    private boolean isFuzzyUpgrade = false;
    private boolean isCombinedSneakyUpgrade = false;
    private int liquidCrafter = 0;
    private boolean hasByproductExtractor = false;
    private UUID uuid = null;
    private String uuidS = null;
    private boolean hasPatternUpgrade = false;
    private boolean hasPowerPassUpgrade = false;
    private boolean hasRFPowerUpgrade = false;
    private int getIC2PowerLevel = 0;
    private boolean hasCCRemoteControlUpgrade = false;
    private boolean hasCraftingMonitoringUpgrade = false;
    private boolean hasOpaqueUpgrade = false;
    private int craftingCleanup = 0;
    private boolean hasLogicControll = false;
    private boolean hasUpgradeModuleUpgarde = false;
    private boolean needsContainerPositionUpdate = false;

    public UpgradeManager(CoreRoutedPipe pipe) {
        this.pipe = pipe;
        this.inv.addListener(this);
        this.sneakyInv.addListener(this);
        this.secInv.addListener(this);
    }

    public void readFromNBT(NBTTagCompound nbttagcompound) {
        this.inv.readFromNBT(nbttagcompound, "UpgradeInventory_");
        this.sneakyInv.readFromNBT(nbttagcompound, "SneakyUpgradeInventory_");
        this.secInv.readFromNBT(nbttagcompound, "SecurityInventory_");
        if (this.sneakyInv.func_70301_a(8) != null && this.sneakyInv.func_70301_a(8).func_77973_b() == LogisticsPipes.LogisticsItemCard && this.sneakyInv.func_70301_a(8).func_77960_j() == 1) {
            this.secInv.func_70299_a(0, this.sneakyInv.func_70301_a(8));
            this.sneakyInv.func_70299_a(8, null);
        }
        this.InventoryChanged(this.inv);
    }

    public void writeToNBT(NBTTagCompound nbttagcompound) {
        this.inv.writeToNBT(nbttagcompound, "UpgradeInventory_");
        this.sneakyInv.writeToNBT(nbttagcompound, "SneakyUpgradeInventory_");
        this.secInv.writeToNBT(nbttagcompound, "SecurityInventory_");
        this.InventoryChanged(this.inv);
    }

    private boolean updateModule(int slot, IPipeUpgrade[] upgrades, IInventory inv) {
        upgrades[slot] = LogisticsPipes.UpgradeItem.getUpgradeForItem(inv.func_70301_a(slot), upgrades[slot]);
        if (upgrades[slot] == null) {
            inv.func_70299_a(slot, null);
            return false;
        }
        return upgrades[slot].needsUpdate();
    }

    private boolean removeUpgrade(int slot, IPipeUpgrade[] upgrades) {
        boolean needUpdate = upgrades[slot].needsUpdate();
        upgrades[slot] = null;
        return needUpdate;
    }

    @Override
    public void InventoryChanged(IInventory inventory) {
        IPipeUpgrade upgrade;
        int i;
        boolean needUpdate = false;
        for (int i2 = 0; i2 < this.inv.func_70302_i_(); ++i2) {
            ItemStack item = this.inv.func_70301_a(i2);
            if (item != null) {
                needUpdate |= this.updateModule(i2, this.upgrades, this.inv);
                continue;
            }
            if (item != null || this.upgrades[i2] == null) continue;
            needUpdate |= this.removeUpgrade(i2, this.upgrades);
        }
        this.sneakyOrientation = ForgeDirection.UNKNOWN;
        this.speedUpgradeCount = 0;
        this.isAdvancedCrafter = false;
        this.isFuzzyUpgrade = false;
        boolean combinedBuffer = this.isCombinedSneakyUpgrade;
        this.isCombinedSneakyUpgrade = false;
        this.liquidCrafter = 0;
        this.disconnectedSides.clear();
        this.hasByproductExtractor = false;
        this.hasPatternUpgrade = false;
        this.hasPowerPassUpgrade = false;
        this.hasRFPowerUpgrade = false;
        this.getIC2PowerLevel = 0;
        this.hasCCRemoteControlUpgrade = false;
        this.hasCraftingMonitoringUpgrade = false;
        this.hasOpaqueUpgrade = false;
        this.craftingCleanup = 0;
        this.hasLogicControll = false;
        this.hasUpgradeModuleUpgarde = false;
        for (i = 0; i < this.upgrades.length; ++i) {
            upgrade = this.upgrades[i];
            if (upgrade instanceof SneakyUpgrade && this.sneakyOrientation == ForgeDirection.UNKNOWN && !this.isCombinedSneakyUpgrade) {
                this.sneakyOrientation = ((SneakyUpgrade)upgrade).getSneakyOrientation();
                continue;
            }
            if (upgrade instanceof SpeedUpgrade) {
                this.speedUpgradeCount += this.inv.func_70301_a((int)i).field_77994_a;
                continue;
            }
            if (upgrade instanceof ConnectionUpgrade) {
                this.disconnectedSides.add(((ConnectionUpgrade)upgrade).getSide());
                continue;
            }
            if (upgrade instanceof AdvancedSatelliteUpgrade) {
                this.isAdvancedCrafter = true;
                continue;
            }
            if (upgrade instanceof FuzzyUpgrade) {
                this.isFuzzyUpgrade = true;
                continue;
            }
            if (upgrade instanceof CombinedSneakyUpgrade && this.sneakyOrientation == ForgeDirection.UNKNOWN) {
                this.isCombinedSneakyUpgrade = true;
                continue;
            }
            if (upgrade instanceof FluidCraftingUpgrade) {
                this.liquidCrafter += this.inv.func_70301_a((int)i).field_77994_a;
                continue;
            }
            if (upgrade instanceof CraftingByproductUpgrade) {
                this.hasByproductExtractor = true;
                continue;
            }
            if (upgrade instanceof PatternUpgrade) {
                this.hasPatternUpgrade = true;
                continue;
            }
            if (upgrade instanceof PowerTransportationUpgrade) {
                this.hasPowerPassUpgrade = true;
                continue;
            }
            if (upgrade instanceof RFPowerSupplierUpgrade) {
                this.hasRFPowerUpgrade = true;
                continue;
            }
            if (upgrade instanceof IC2PowerSupplierUpgrade) {
                this.getIC2PowerLevel = Math.max(this.getIC2PowerLevel, ((IC2PowerSupplierUpgrade)upgrade).getPowerLevel());
                continue;
            }
            if (upgrade instanceof CCRemoteControlUpgrade) {
                this.hasCCRemoteControlUpgrade = true;
                continue;
            }
            if (upgrade instanceof CraftingMonitoringUpgrade) {
                this.hasCraftingMonitoringUpgrade = true;
                continue;
            }
            if (upgrade instanceof OpaqueUpgrade) {
                this.hasOpaqueUpgrade = true;
                continue;
            }
            if (upgrade instanceof CraftingCleanupUpgrade) {
                this.craftingCleanup += this.inv.func_70301_a((int)i).field_77994_a;
                continue;
            }
            if (upgrade instanceof LogicControllerUpgrade) {
                this.hasLogicControll = true;
                continue;
            }
            if (!(upgrade instanceof UpgradeModuleUpgrade)) continue;
            this.hasUpgradeModuleUpgarde = true;
        }
        this.liquidCrafter = Math.min(this.liquidCrafter, 3);
        this.craftingCleanup = Math.min(this.craftingCleanup, 4);
        if (combinedBuffer != this.isCombinedSneakyUpgrade) {
            this.needsContainerPositionUpdate = true;
        }
        for (i = 0; i < this.sneakyInv.func_70302_i_() - 1; ++i) {
            ItemStack item = this.sneakyInv.func_70301_a(i);
            if (item != null) {
                needUpdate |= this.updateModule(i, this.sneakyUpgrades, this.sneakyInv);
                continue;
            }
            if (item != null || this.sneakyUpgrades[i] == null) continue;
            needUpdate |= this.removeUpgrade(i, this.sneakyUpgrades);
        }
        for (i = 0; i < this.sneakyUpgrades.length; ++i) {
            upgrade = this.sneakyUpgrades[i];
            if (!(upgrade instanceof SneakyUpgrade)) continue;
            this.combinedSneakyOrientation[i] = ((SneakyUpgrade)upgrade).getSneakyOrientation();
        }
        if (needUpdate) {
            this.pipe.connectionUpdate();
            if (this.pipe.container != null) {
                this.pipe.container.sendUpdateToClient();
            }
        }
        this.uuid = null;
        this.uuidS = null;
        ItemStack stack = this.secInv.func_70301_a(0);
        if (stack == null) {
            return;
        }
        if (stack.func_77973_b() != LogisticsPipes.LogisticsItemCard || stack.func_77960_j() != 1) {
            return;
        }
        if (!stack.func_77942_o()) {
            return;
        }
        if (!stack.func_77978_p().func_74764_b("UUID")) {
            return;
        }
        this.uuid = UUID.fromString(stack.func_77978_p().func_74779_i("UUID"));
        this.uuidS = this.uuid.toString();
    }

    @Override
    public boolean hasSneakyUpgrade() {
        return this.sneakyOrientation != ForgeDirection.UNKNOWN;
    }

    @Override
    public ForgeDirection getSneakyOrientation() {
        return this.sneakyOrientation;
    }

    @Override
    public int getSpeedUpgradeCount() {
        return this.speedUpgradeCount;
    }

    @Override
    public boolean hasCombinedSneakyUpgrade() {
        return this.isCombinedSneakyUpgrade;
    }

    @Override
    public ForgeDirection[] getCombinedSneakyOrientation() {
        return this.combinedSneakyOrientation;
    }

    public void openGui(EntityPlayer entityplayer, CoreRoutedPipe pipe) {
        NewGuiHandler.getGui(UpgradeManagerGui.class).setTilePos(pipe.container).open(entityplayer);
    }

    public IGuiOpenControler getGuiController() {
        return new IGuiOpenControler(){
            final PlayerCollectionList players = new PlayerCollectionList();

            @Override
            public void guiOpenedByPlayer(EntityPlayer player) {
                this.players.add(player);
            }

            @Override
            public void guiClosedByPlayer(EntityPlayer player) {
                this.players.remove(player);
                if (this.players.isEmpty() && !UpgradeManager.this.isCombinedSneakyUpgrade) {
                    UpgradeManager.this.sneakyInv.dropContents(UpgradeManager.this.pipe.getWorld(), UpgradeManager.this.pipe.getX(), UpgradeManager.this.pipe.getY(), UpgradeManager.this.pipe.getZ());
                }
            }
        };
    }

    public DummyContainer getDummyContainer(EntityPlayer player) {
        DummyContainer dummy = new DummyContainer(player, this.inv, this.getGuiController());
        dummy.addNormalSlotsForPlayerInventory(8, this.isCombinedSneakyUpgrade ? 90 : 60);
        for (int pipeSlot = 0; pipeSlot < 8; ++pipeSlot) {
            dummy.addRestrictedSlot(pipeSlot, (IInventory)this.inv, 8 + pipeSlot * 18, 18, itemStack -> {
                if (itemStack == null) {
                    return false;
                }
                if (itemStack.func_77973_b() == LogisticsPipes.UpgradeItem) {
                    return LogisticsPipes.UpgradeItem.getUpgradeForItem(itemStack, null).isAllowedForPipe(this.pipe);
                }
                return false;
            });
        }
        dummy.addStaticRestrictedSlot(0, (IInventory)this.secInv, 152, 18, itemStack -> {
            if (itemStack == null) {
                return false;
            }
            if (itemStack.func_77973_b() != LogisticsPipes.LogisticsItemCard) {
                return false;
            }
            if (itemStack.func_77960_j() != 1) {
                return false;
            }
            return SimpleServiceLocator.securityStationManager.isAuthorized(UUID.fromString(itemStack.func_77978_p().func_74779_i("UUID")));
        }, 1);
        int y = this.isCombinedSneakyUpgrade ? 58 : 100000;
        for (int pipeSlot = 0; pipeSlot < 9; ++pipeSlot) {
            dummy.addRestrictedSlot(pipeSlot, (IInventory)this.sneakyInv, 8 + pipeSlot * 18, y, itemStack -> {
                if (itemStack == null) {
                    return false;
                }
                if (itemStack.func_77973_b() == LogisticsPipes.UpgradeItem) {
                    IPipeUpgrade upgrade = LogisticsPipes.UpgradeItem.getUpgradeForItem(itemStack, null);
                    if (!(upgrade instanceof SneakyUpgrade)) {
                        return false;
                    }
                    return upgrade.isAllowedForPipe(this.pipe);
                }
                return false;
            });
        }
        return dummy;
    }

    public boolean isNeedingContainerUpdate() {
        boolean tmp = this.needsContainerPositionUpdate;
        this.needsContainerPositionUpdate = false;
        return tmp;
    }

    public void dropUpgrades() {
        this.inv.dropContents(this.pipe.getWorld(), this.pipe.getX(), this.pipe.getY(), this.pipe.getZ());
        this.sneakyInv.dropContents(this.pipe.getWorld(), this.pipe.getX(), this.pipe.getY(), this.pipe.getZ());
    }

    @Override
    public boolean isSideDisconnected(ForgeDirection side) {
        return this.disconnectedSides.contains(side);
    }

    public boolean tryIserting(World world, EntityPlayer entityplayer) {
        if (entityplayer.func_71045_bC() != null && entityplayer.func_71045_bC().func_77973_b() == LogisticsPipes.UpgradeItem) {
            if (MainProxy.isClient(world)) {
                return true;
            }
            IPipeUpgrade upgrade = LogisticsPipes.UpgradeItem.getUpgradeForItem(entityplayer.func_71045_bC(), null);
            if (upgrade.isAllowedForPipe(this.pipe)) {
                if (this.isCombinedSneakyUpgrade && upgrade instanceof SneakyUpgrade && this.insertIntInv(entityplayer, this.sneakyInv)) {
                    return true;
                }
                if (this.insertIntInv(entityplayer, this.inv)) {
                    return true;
                }
            }
        }
        if (entityplayer.func_71045_bC() != null && entityplayer.func_71045_bC().func_77973_b() == LogisticsPipes.LogisticsItemCard && entityplayer.func_71045_bC().func_77960_j() == 1) {
            if (MainProxy.isClient(world)) {
                return true;
            }
            if (this.secInv.func_70301_a(0) == null) {
                ItemStack newItem = entityplayer.func_71045_bC().func_77979_a(1);
                this.secInv.func_70299_a(0, newItem);
                this.InventoryChanged(this.secInv);
                return true;
            }
        }
        return false;
    }

    private boolean insertIntInv(EntityPlayer entityplayer, SimpleStackInventory inv) {
        for (int i = 0; i < inv.func_70302_i_(); ++i) {
            ItemStack item = inv.func_70301_a(i);
            if (item == null) {
                inv.func_70299_a(i, entityplayer.func_71045_bC().func_77979_a(1));
                this.InventoryChanged(inv);
                return true;
            }
            if (item.func_77960_j() != entityplayer.func_71045_bC().func_77960_j() || item.field_77994_a >= inv.func_70297_j_()) continue;
            ++item.field_77994_a;
            entityplayer.func_71045_bC().func_77979_a(1);
            inv.func_70299_a(i, item);
            this.InventoryChanged(inv);
            return true;
        }
        return false;
    }

    public UUID getSecurityID() {
        return this.uuid;
    }

    public void insetSecurityID(UUID id) {
        ItemStack stack = new ItemStack(LogisticsPipes.LogisticsItemCard, 1, 1);
        stack.func_77982_d(new NBTTagCompound());
        stack.func_77978_p().func_74778_a("UUID", id.toString());
        this.secInv.func_70299_a(0, stack);
        this.InventoryChanged(this.secInv);
    }

    public void securityTick() {
        if (this.getSecurityID() != null) {
            this.securityDelay = !SimpleServiceLocator.securityStationManager.isAuthorized(this.uuidS) ? ++this.securityDelay : 0;
            if (this.securityDelay > 20) {
                this.secInv.clearInventorySlotContents(0);
                this.InventoryChanged(this.secInv);
            }
        }
    }

    @Override
    public boolean isAdvancedSatelliteCrafter() {
        return this.isAdvancedCrafter;
    }

    @Override
    public boolean isFuzzyUpgrade() {
        return this.isFuzzyUpgrade;
    }

    @Override
    public int getFluidCrafter() {
        return this.liquidCrafter;
    }

    @Override
    public boolean hasByproductExtractor() {
        return this.hasByproductExtractor;
    }

    @Override
    public boolean hasPatternUpgrade() {
        return this.hasPatternUpgrade;
    }

    @Override
    public boolean hasPowerPassUpgrade() {
        return this.hasPowerPassUpgrade || this.hasRFPowerUpgrade || this.getIC2PowerLevel > 0;
    }

    @Override
    public boolean hasRFPowerSupplierUpgrade() {
        return this.hasRFPowerUpgrade;
    }

    @Override
    public int getIC2PowerLevel() {
        return this.getIC2PowerLevel;
    }

    @Override
    public boolean hasCCRemoteControlUpgrade() {
        return this.hasCCRemoteControlUpgrade;
    }

    @Override
    public boolean hasCraftingMonitoringUpgrade() {
        return this.hasCraftingMonitoringUpgrade;
    }

    @Override
    public boolean isOpaque() {
        return this.hasOpaqueUpgrade;
    }

    @Override
    public int getCrafterCleanup() {
        return this.craftingCleanup;
    }

    public boolean hasLogicControll() {
        return this.hasLogicControll;
    }

    @Override
    public boolean hasUpgradeModuleUpgrade() {
        return this.hasUpgradeModuleUpgarde;
    }

    @Override
    public boolean hasOwnSneakyUpgrade() {
        return false;
    }

    public SimpleStackInventory getInv() {
        return this.inv;
    }

    public SimpleStackInventory getSneakyInv() {
        return this.sneakyInv;
    }

    public SimpleStackInventory getSecInv() {
        return this.secInv;
    }
}

