/*
 * Decompiled with CFR 0.152.
 */
package logisticspipes.pipes.basic.debug;

import java.awt.Component;
import java.awt.GridLayout;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextPane;
import javax.swing.JTree;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import logisticspipes.pipes.basic.debug.StatusEntry;

public class LogWindow
extends JPanel {
    private static final Map<Integer, LogWindow> map = new HashMap<Integer, LogWindow>();
    private final JTextPane logArea;
    private final JScrollPane logPane;
    private final DefaultMutableTreeNode baseNode;
    private final JTree tree;
    private final JScrollPane treeView;
    private List<StatusEntry> currentLayout = new ArrayList<StatusEntry>(0);
    private JFrame frame;

    public static LogWindow getWindow(int id) {
        LogWindow window = map.get(id);
        if (window == null) {
            window = new LogWindow();
            map.put(id, window);
        }
        return window;
    }

    private LogWindow() {
        super(new GridLayout(1, 1));
        JTabbedPane tabbedPane = new JTabbedPane();
        this.logArea = new JTextPane();
        this.logPane = new JScrollPane(this.logArea);
        tabbedPane.addTab("Console", null, this.logPane, "");
        tabbedPane.setMnemonicAt(0, 49);
        this.baseNode = new DefaultMutableTreeNode("State Information");
        this.tree = new JTree(this.baseNode);
        this.treeView = new JScrollPane(this.tree);
        tabbedPane.addTab("Status List", null, this.treeView, "");
        tabbedPane.setMnemonicAt(1, 50);
        this.add(tabbedPane);
        this.createAndShowGUI();
    }

    private void createAndShowGUI() {
        this.frame = new JFrame("");
        this.frame.add((Component)this, "Center");
        this.frame.pack();
        this.frame.setVisible(true);
    }

    public void newLine(String data) {
        SimpleAttributeSet attr = new SimpleAttributeSet();
        StyleConstants.setFontFamily(attr, "SansSerif");
        StyleConstants.setFontSize(attr, 12);
        Document document = this.logArea.getDocument();
        if (document != null) {
            try {
                document.insertString(document.getLength(), data + "\n", attr);
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
        }
        this.validate();
    }

    public void clear() {
        this.logArea.setText("");
        this.validate();
    }

    public void updateStatus(List<StatusEntry> entries) {
        this.compareLists(entries, this.currentLayout, this.baseNode);
        this.currentLayout = entries;
    }

    private void compareLists(List<StatusEntry> newList, List<StatusEntry> oldList, DefaultMutableTreeNode node) {
        StatusEntry entry;
        int i;
        for (i = 0; i < newList.size() && i < oldList.size(); ++i) {
            if (newList.get(i).equals(oldList.get(i))) continue;
            entry = newList.get(i);
            DefaultMutableTreeNode child = (DefaultMutableTreeNode)node.getChildAt(i);
            child.setUserObject(entry.name);
            if (entry.subEntry != null) {
                if (oldList.get((int)i).subEntry != null) {
                    this.compareLists(entry.subEntry, oldList.get((int)i).subEntry, child);
                } else {
                    this.compareLists(entry.subEntry, new ArrayList<StatusEntry>(0), child);
                }
            } else if (oldList.get((int)i).subEntry != null) {
                child.removeAllChildren();
            }
            ((DefaultTreeModel)this.tree.getModel()).reload(child);
        }
        for (i = newList.size(); i < oldList.size(); ++i) {
            node.remove(i);
            ((DefaultTreeModel)this.tree.getModel()).reload(node);
        }
        for (i = oldList.size(); i < newList.size(); ++i) {
            entry = newList.get(i);
            DefaultMutableTreeNode newNode = new DefaultMutableTreeNode(entry.name);
            node.add(newNode);
            if (entry.subEntry != null) {
                this.compareLists(entry.subEntry, new ArrayList<StatusEntry>(0), newNode);
            }
            ((DefaultTreeModel)this.tree.getModel()).reload(node);
        }
    }

    public void setTitle(String title) {
        this.frame.setName(title);
    }
}

