/*
 * Decompiled with CFR 0.152.
 */
package logisticspipes.pipes.basic;

import buildcraft.api.core.EnumColor;
import buildcraft.api.transport.IPipe;
import buildcraft.api.transport.IPipeConnection;
import buildcraft.api.transport.IPipeTile;
import buildcraft.api.transport.pluggable.PipePluggable;
import buildcraft.transport.TileGenericPipe;
import cofh.api.transport.IItemDuct;
import cpw.mods.fml.common.Optional;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import li.cil.oc.api.machine.Arguments;
import li.cil.oc.api.machine.Context;
import li.cil.oc.api.network.Environment;
import li.cil.oc.api.network.ManagedPeripheral;
import li.cil.oc.api.network.Message;
import li.cil.oc.api.network.Node;
import li.cil.oc.api.network.SidedEnvironment;
import logisticspipes.LogisticsPipes;
import logisticspipes.api.ILPPipe;
import logisticspipes.api.ILPPipeTile;
import logisticspipes.blocks.LogisticsSolidTileEntity;
import logisticspipes.interfaces.IClientState;
import logisticspipes.interfaces.routing.IFilter;
import logisticspipes.logic.LogicController;
import logisticspipes.logic.interfaces.ILogicControllerTile;
import logisticspipes.network.LPDataInputStream;
import logisticspipes.network.LPDataOutputStream;
import logisticspipes.network.PacketHandler;
import logisticspipes.network.abstractpackets.ModernPacket;
import logisticspipes.network.packets.pipe.PipeTileStatePacket;
import logisticspipes.pipes.PipeItemsFirewall;
import logisticspipes.pipes.basic.CoreRoutedPipe;
import logisticspipes.pipes.basic.CoreUnroutedPipe;
import logisticspipes.pipes.basic.LogisticsBlockGenericPipe;
import logisticspipes.proxy.MainProxy;
import logisticspipes.proxy.SimpleServiceLocator;
import logisticspipes.proxy.buildcraft.subproxies.IBCPluggableState;
import logisticspipes.proxy.buildcraft.subproxies.IBCTilePart;
import logisticspipes.proxy.buildcraft.subproxies.IConnectionOverrideResult;
import logisticspipes.proxy.computers.wrapper.CCObjectWrapper;
import logisticspipes.proxy.opencomputers.IOCTile;
import logisticspipes.proxy.opencomputers.asm.BaseWrapperClass;
import logisticspipes.renderer.IIconProvider;
import logisticspipes.renderer.LogisticsTileRenderController;
import logisticspipes.renderer.state.PipeRenderState;
import logisticspipes.routing.pathfinder.IPipeInformationProvider;
import logisticspipes.transport.LPTravelingItem;
import logisticspipes.utils.AdjacentTile;
import logisticspipes.utils.OrientationsUtil;
import logisticspipes.utils.StackTraceUtil;
import logisticspipes.utils.TileBuffer;
import logisticspipes.utils.WorldUtil;
import logisticspipes.utils.item.ItemIdentifier;
import logisticspipes.utils.tuples.LPPosition;
import net.minecraft.block.Block;
import net.minecraft.crash.CrashReportCategory;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.Packet;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidHandler;
import org.apache.logging.log4j.Level;

@Optional.InterfaceList(value={@Optional.Interface(modid="CoFHCore", iface="cofh.api.transport.IItemDuct"), @Optional.Interface(modid="OpenComputers", iface="li.cil.oc.api.network.ManagedPeripheral"), @Optional.Interface(modid="OpenComputers", iface="li.cil.oc.api.network.Environment"), @Optional.Interface(modid="OpenComputers", iface="li.cil.oc.api.network.SidedEnvironment"), @Optional.Interface(modid="BuildCraft|Transport", iface="buildcraft.api.transport.IPipeTile"), @Optional.Interface(modid="BuildCraft|Transport", iface="buildcraft.api.transport.IPipeConnection")})
public class LogisticsTileGenericPipe
extends TileEntity
implements IOCTile,
ILPPipeTile,
IPipeInformationProvider,
IItemDuct,
ManagedPeripheral,
Environment,
SidedEnvironment,
IFluidHandler,
IPipeTile,
ILogicControllerTile,
IPipeConnection {
    public Object OPENPERIPHERAL_IGNORE;
    public boolean[] turtleConnect = new boolean[7];
    private LogisticsTileRenderController renderController;
    public HashMap<Object, ForgeDirection> connections;
    public Object currentPC;
    public Object node;
    private boolean addedToNetwork = false;
    private boolean sendInitPacket = true;
    public LogicController logicController = new LogicController();
    public final PipeRenderState renderState;
    public final CoreState coreState = new CoreState();
    public final IBCTilePart tilePart;
    public final IBCPluggableState bcPlugableState;
    private boolean initialized = false;
    public boolean[] pipeConnectionsBuffer = new boolean[6];
    public boolean[] pipeBCConnectionsBuffer = new boolean[6];
    public CoreUnroutedPipe pipe;
    private boolean deletePipe = false;
    private TileBuffer[] tileBuffer;
    private boolean sendClientUpdate = false;
    private boolean blockNeighborChange = false;
    private boolean refreshRenderState = false;
    private boolean pipeBound = false;

    public LogisticsTileGenericPipe() {
        if (SimpleServiceLocator.ccProxy.isCC()) {
            this.connections = new HashMap();
        }
        SimpleServiceLocator.openComputersProxy.initLogisticsTileGenericPipe(this);
        this.tilePart = SimpleServiceLocator.buildCraftProxy.getBCTilePart(this);
        this.renderState = new PipeRenderState(this.tilePart);
        this.bcPlugableState = this.tilePart.getBCPlugableState();
    }

    public void func_145843_s() {
        if (this.pipe == null) {
            this.field_145846_f = true;
            this.initialized = false;
            this.tileBuffer = null;
            if (this.pipe != null) {
                this.pipe.invalidate();
            }
            super.func_145843_s();
        } else if (!this.pipe.preventRemove()) {
            this.field_145846_f = true;
            this.initialized = false;
            this.tileBuffer = null;
            if (this.pipe != null) {
                this.pipe.invalidate();
            }
            super.func_145843_s();
            SimpleServiceLocator.openComputersProxy.handleInvalidate(this);
            this.tilePart.invalidate_LP();
        }
    }

    public void func_145829_t() {
        super.func_145829_t();
        this.initialized = false;
        this.tileBuffer = null;
        this.bindPipe();
        if (this.pipe != null) {
            this.pipe.validate();
        }
        this.tilePart.validate_LP();
    }

    public void onChunkUnload() {
        if (this.pipe != null) {
            this.pipe.onChunkUnload();
        }
        SimpleServiceLocator.openComputersProxy.handleChunkUnload(this);
    }

    public void func_145845_h() {
        StackTraceUtil.Info superDebug = StackTraceUtil.addSuperTraceInformation("Time: " + this.getWorld().func_72820_D(), new StackTraceUtil.Info[0]);
        StackTraceUtil.Info debug = StackTraceUtil.addTraceInformation("(" + this.getX() + ", " + this.getY() + ", " + this.getZ() + ")", superDebug);
        if (this.sendInitPacket && MainProxy.isServer(this.func_145831_w())) {
            this.sendInitPacket = false;
            this.getRenderController().sendInit();
        }
        if (!this.field_145850_b.field_72995_K) {
            if (this.deletePipe) {
                this.field_145850_b.func_147468_f(this.field_145851_c, this.field_145848_d, this.field_145849_e);
            }
            if (this.pipe == null) {
                debug.end();
                return;
            }
            if (!this.initialized) {
                this.initialize(this.pipe);
            }
        }
        if (!LogisticsBlockGenericPipe.isValid(this.pipe)) {
            debug.end();
            return;
        }
        this.pipe.updateEntity();
        if (this.field_145850_b.field_72995_K) {
            debug.end();
            return;
        }
        if (this.blockNeighborChange) {
            this.computeConnections();
            this.pipe.onNeighborBlockChange(0);
            this.blockNeighborChange = false;
            this.refreshRenderState = true;
        }
        this.tilePart.updateEntity_LP();
        if (this.refreshRenderState) {
            for (ForgeDirection o : ForgeDirection.VALID_DIRECTIONS) {
                this.renderState.pipeConnectionMatrix.setConnected(o, this.pipeConnectionsBuffer[o.ordinal()]);
                this.renderState.pipeConnectionMatrix.setBCConnected(o, this.pipeBCConnectionsBuffer[o.ordinal()]);
            }
            for (int i = 0; i < 7; ++i) {
                ForgeDirection o = ForgeDirection.getOrientation((int)i);
                this.renderState.textureMatrix.setIconIndex(o, this.pipe.getIconIndex(o));
            }
            this.renderState.textureMatrix.refreshStates(this.pipe);
            if (this.renderState.isDirty()) {
                this.renderState.clean();
                this.sendUpdateToClient();
            }
            this.refreshRenderState = false;
        }
        if (this.bcPlugableState.isDirty(true)) {
            this.sendUpdateToClient();
        }
        if (this.sendClientUpdate) {
            this.sendClientUpdate = false;
            MainProxy.sendPacketToAllWatchingChunk(this.field_145851_c, this.field_145849_e, MainProxy.getDimensionForWorld(this.field_145850_b), this.getLPDescriptionPacket());
        }
        this.getRenderController().onUpdate();
        if (!this.addedToNetwork) {
            this.addedToNetwork = true;
            SimpleServiceLocator.openComputersProxy.addToNetwork(this);
        }
        debug.end();
    }

    public Packet func_145844_m() {
        this.sendInitPacket = true;
        try {
            return PacketHandler.toFMLPacket(this.getLPDescriptionPacket());
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public void func_145828_a(CrashReportCategory par1CrashReportCategory) {
        try {
            super.func_145828_a(par1CrashReportCategory);
        }
        catch (Exception exception) {
            // empty catch block
        }
        par1CrashReportCategory.func_71507_a("LP-Version", (Object)"1.0.6-GTNH");
        if (this.pipe != null) {
            par1CrashReportCategory.func_71507_a("Pipe", (Object)this.pipe.getClass().getCanonicalName());
            if (this.pipe.transport != null) {
                par1CrashReportCategory.func_71507_a("Transport", (Object)this.pipe.transport.getClass().getCanonicalName());
            } else {
                par1CrashReportCategory.func_71507_a("Transport", (Object)"null");
            }
            if (this.pipe instanceof CoreRoutedPipe) {
                try {
                    ((CoreRoutedPipe)this.pipe).addCrashReport(par1CrashReportCategory);
                }
                catch (Exception e) {
                    par1CrashReportCategory.func_71499_a("Internal LogisticsPipes Error", (Throwable)e);
                }
            }
        }
    }

    public void scheduleNeighborChange() {
        this.tilePart.scheduleNeighborChange();
        this.blockNeighborChange = true;
        boolean[] connected = new boolean[6];
        WorldUtil world = new WorldUtil(this.getWorld(), this.field_145851_c, this.field_145848_d, this.field_145849_e);
        List<AdjacentTile> adjacent = world.getAdjacentTileEntities(false);
        for (AdjacentTile aTile : adjacent) {
            if (!SimpleServiceLocator.ccProxy.isTurtle(aTile.tile)) continue;
            connected[aTile.orientation.ordinal()] = true;
        }
        for (int i = 0; i < 6; ++i) {
            if (connected[i]) continue;
            this.turtleConnect[i] = false;
        }
    }

    public void func_145841_b(NBTTagCompound nbt) {
        super.func_145841_b(nbt);
        if (this.pipe != null) {
            nbt.func_74768_a("pipeId", Item.field_150901_e.func_148757_b((Object)this.pipe.item));
            this.pipe.writeToNBT(nbt);
        } else {
            nbt.func_74768_a("pipeId", this.coreState.pipeId);
        }
        this.tilePart.writeToNBT_LP(nbt);
        for (int i = 0; i < this.turtleConnect.length; ++i) {
            nbt.func_74757_a("turtleConnect_" + i, this.turtleConnect[i]);
        }
        SimpleServiceLocator.openComputersProxy.handleWriteToNBT(this, nbt);
        NBTTagCompound logicNBT = new NBTTagCompound();
        this.logicController.writeToNBT(logicNBT);
        nbt.func_74782_a("logicController", (NBTBase)logicNBT);
    }

    public void func_145839_a(NBTTagCompound nbt) {
        StackTraceElement[] trace;
        if (this.pipe != null && (trace = Thread.currentThread().getStackTrace()).length > 2 && trace[2].getMethodName().equals("handle") && trace[2].getClassName().equals("com.xcompwiz.lookingglass.network.packet.PacketTileEntityNBT")) {
            System.out.println("Prevented false data injection by LookingGlass");
            return;
        }
        super.func_145839_a(nbt);
        if (nbt.func_74764_b("redstoneInputSide[0]")) {
            this.tilePart.readOldRedStone(nbt);
        }
        this.coreState.pipeId = nbt.func_74762_e("pipeId");
        this.pipe = LogisticsBlockGenericPipe.createPipe(Item.func_150899_d((int)this.coreState.pipeId));
        this.bindPipe();
        if (this.pipe != null) {
            this.pipe.readFromNBT(nbt);
        } else {
            LogisticsPipes.log.log(Level.WARN, "Pipe failed to load from NBT at {},{},{}", new Object[]{this.field_145851_c, this.field_145848_d, this.field_145849_e});
            this.deletePipe = true;
        }
        this.tilePart.readFromNBT_LP(nbt);
        for (int i = 0; i < this.turtleConnect.length; ++i) {
            this.turtleConnect[i] = nbt.func_74767_n("turtleConnect_" + i);
        }
        SimpleServiceLocator.openComputersProxy.handleReadFromNBT(this, nbt);
        this.logicController.readFromNBT(nbt.func_74775_l("logicController"));
    }

    public boolean canPipeConnect(TileEntity with, ForgeDirection side) {
        if (MainProxy.isClient(this.field_145850_b)) {
            return false;
        }
        if (with == null) {
            return false;
        }
        if (this.tilePart.hasBlockingPluggable(side)) {
            return false;
        }
        if (!LogisticsBlockGenericPipe.isValid(this.pipe)) {
            return false;
        }
        if (SimpleServiceLocator.ccProxy.isTurtle(with) && !this.turtleConnect[OrientationsUtil.getOrientationOfTilewithTile(this, with).ordinal()]) {
            return false;
        }
        IConnectionOverrideResult result = SimpleServiceLocator.buildCraftProxy.checkConnectionOverride(with, side, this);
        if (result.forceDisconnect()) {
            return false;
        }
        if (result.forceConnect()) {
            return true;
        }
        if (!SimpleServiceLocator.buildCraftProxy.checkForPipeConnection(with, side, this)) {
            return false;
        }
        if (with instanceof LogisticsTileGenericPipe) {
            if (((LogisticsTileGenericPipe)with).tilePart.hasBlockingPluggable(side.getOpposite())) {
                return false;
            }
            CoreUnroutedPipe otherPipe = ((LogisticsTileGenericPipe)with).pipe;
            if (!LogisticsBlockGenericPipe.isValid(otherPipe)) {
                return false;
            }
            if (!otherPipe.canPipeConnect(this, side.getOpposite())) {
                return false;
            }
        }
        return this.pipe.canPipeConnect(with, side);
    }

    public void queueEvent(String event, Object[] arguments) {
        SimpleServiceLocator.ccProxy.queueEvent(event, arguments, this);
    }

    public void handleMesssage(int computerId, Object message, int sourceId) {
        SimpleServiceLocator.ccProxy.handleMesssage(computerId, message, this, sourceId);
    }

    public void setTurtleConnect(boolean flag) {
        SimpleServiceLocator.ccProxy.setTurtleConnect(flag, this);
    }

    public boolean getTurtleConnect() {
        return SimpleServiceLocator.ccProxy.getTurtleConnect(this);
    }

    public int getLastCCID() {
        return SimpleServiceLocator.ccProxy.getLastCCID(this);
    }

    public ItemStack insertItem(ForgeDirection dir, ItemStack stack) {
        int used = this.injectItem(stack, true, dir);
        if (used == stack.field_77994_a) {
            return null;
        }
        stack = stack.func_77946_l();
        stack.field_77994_a -= used;
        return stack;
    }

    public void addLaser(ForgeDirection dir, float length, int color, boolean reverse, boolean renderBall) {
        this.getRenderController().addLaser(dir, length, color, reverse, renderBall);
    }

    public void removeLaser(ForgeDirection dir, int color, boolean isBall) {
        this.getRenderController().removeLaser(dir, color, isBall);
    }

    public LogisticsTileRenderController getRenderController() {
        if (this.renderController == null) {
            this.renderController = new LogisticsTileRenderController(this);
        }
        return this.renderController;
    }

    @Override
    public boolean isCorrect() {
        return true;
    }

    @Override
    public int getX() {
        return this.field_145851_c;
    }

    @Override
    public int getY() {
        return this.field_145848_d;
    }

    @Override
    public int getZ() {
        return this.field_145849_e;
    }

    @Override
    public boolean isRouterInitialized() {
        return this.isInitialized() && (!this.isRoutingPipe() || !this.getRoutingPipe().stillNeedReplace());
    }

    @Override
    public boolean isRoutingPipe() {
        return this.pipe instanceof CoreRoutedPipe;
    }

    @Override
    public CoreRoutedPipe getRoutingPipe() {
        if (this.pipe instanceof CoreRoutedPipe) {
            return (CoreRoutedPipe)this.pipe;
        }
        throw new RuntimeException("This is no routing pipe");
    }

    @Override
    public boolean isFirewallPipe() {
        return this.pipe instanceof PipeItemsFirewall;
    }

    @Override
    public IFilter getFirewallFilter() {
        if (this.pipe instanceof PipeItemsFirewall) {
            return ((PipeItemsFirewall)this.pipe).getFilter();
        }
        throw new RuntimeException("This is no firewall pipe");
    }

    @Override
    public TileEntity getTile() {
        return this;
    }

    @Override
    public boolean divideNetwork() {
        return false;
    }

    @Override
    public boolean powerOnly() {
        return false;
    }

    @Override
    public boolean isOnewayPipe() {
        return false;
    }

    @Override
    public boolean isOutputOpen(ForgeDirection direction) {
        return true;
    }

    @Override
    public boolean isItemPipe() {
        return true;
    }

    @Override
    public boolean isFluidPipe() {
        return false;
    }

    @Override
    public boolean isPowerPipe() {
        return false;
    }

    @Override
    public boolean canConnect(TileEntity to, ForgeDirection direction, boolean flag) {
        if (this.pipe == null) {
            return false;
        }
        return this.pipe.canPipeConnect(to, direction, flag);
    }

    @Override
    public double getDistance() {
        return 1.0;
    }

    @Optional.Method(modid="BuildCraft|Transport")
    public boolean isBCPipeConnected(TileGenericPipe container, ForgeDirection o) {
        return container.isPipeConnected(o);
    }

    public int injectItem(ItemStack payload, boolean doAdd, ForgeDirection from) {
        if (LogisticsBlockGenericPipe.isValid(this.pipe) && this.pipe.transport != null && this.isPipeConnected(from) && doAdd && MainProxy.isServer(this.func_145831_w())) {
            int lastIterLeft;
            ItemStack leftStack = payload.func_77946_l();
            do {
                lastIterLeft = leftStack.field_77994_a;
                LPTravelingItem.LPTravelingItemServer travelingItem = SimpleServiceLocator.routedItemHelper.createNewTravelItem(leftStack);
                leftStack.field_77994_a = this.pipe.transport.injectItem(travelingItem, from.getOpposite());
            } while (leftStack.field_77994_a != lastIterLeft && leftStack.field_77994_a != 0);
            return payload.field_77994_a - leftStack.field_77994_a;
        }
        return 0;
    }

    @Optional.Method(modid="BuildCraft|Transport")
    public int injectItem(ItemStack payload, boolean doAdd, ForgeDirection from, EnumColor color) {
        return this.injectItem(payload, doAdd, from);
    }

    public boolean isOpaque() {
        return this.pipe.isOpaque();
    }

    @Optional.Method(modid="OpenComputers")
    public Node node() {
        return (Node)this.node;
    }

    @Optional.Method(modid="OpenComputers")
    public void onConnect(Node node1) {
    }

    @Optional.Method(modid="OpenComputers")
    public void onDisconnect(Node node1) {
    }

    @Optional.Method(modid="OpenComputers")
    public void onMessage(Message message) {
    }

    @Optional.Method(modid="OpenComputers")
    public Object[] invoke(String s, Context context, Arguments arguments) {
        BaseWrapperClass object = (BaseWrapperClass)((Object)CCObjectWrapper.getWrappedObject(this.pipe, BaseWrapperClass.WRAPPER));
        object.isDirectCall = true;
        return CCObjectWrapper.createArray((Object)object);
    }

    @Optional.Method(modid="OpenComputers")
    public String[] methods() {
        return new String[]{"getPipe"};
    }

    @SideOnly(value=Side.CLIENT)
    @Optional.Method(modid="OpenComputers")
    public boolean canConnect(ForgeDirection dir) {
        return !(this.getTile(dir) instanceof LogisticsTileGenericPipe) && !(this.getTile(dir) instanceof LogisticsSolidTileEntity);
    }

    @Optional.Method(modid="OpenComputers")
    public Node sidedNode(ForgeDirection dir) {
        if (this.getTile(dir) instanceof LogisticsTileGenericPipe || this.getTile(dir) instanceof LogisticsSolidTileEntity) {
            return null;
        }
        return this.node();
    }

    @Override
    public Object getOCNode() {
        return this.node();
    }

    public void initialize(CoreUnroutedPipe pipe) {
        this.field_145854_h = this.func_145838_q();
        if (pipe == null) {
            LogisticsPipes.log.log(Level.WARN, "Pipe failed to initialize at {},{},{}, deleting", new Object[]{this.field_145851_c, this.field_145848_d, this.field_145849_e});
            this.field_145850_b.func_147468_f(this.field_145851_c, this.field_145848_d, this.field_145849_e);
            return;
        }
        this.pipe = pipe;
        for (ForgeDirection o : ForgeDirection.VALID_DIRECTIONS) {
            TileEntity tile = this.getTile(o);
            if (tile instanceof LogisticsTileGenericPipe) {
                ((LogisticsTileGenericPipe)tile).scheduleNeighborChange();
            }
            SimpleServiceLocator.buildCraftProxy.notifyOfChange(this, tile, o);
        }
        this.bindPipe();
        this.computeConnections();
        this.scheduleRenderUpdate();
        if (pipe.needsInit()) {
            pipe.initialize();
        }
        this.initialized = true;
    }

    private void bindPipe() {
        if (!this.pipeBound && this.pipe != null) {
            this.pipe.setTile(this);
            this.coreState.pipeId = Item.func_150891_b((Item)this.pipe.item);
            this.pipeBound = true;
        }
    }

    public ModernPacket getLPDescriptionPacket() {
        this.bindPipe();
        PipeTileStatePacket packet = PacketHandler.getPacket(PipeTileStatePacket.class);
        packet.setTilePos(this);
        packet.setCoreState(this.coreState);
        packet.setRenderState(this.renderState);
        packet.setBcPluggableState(this.bcPlugableState);
        packet.setPipe(this.pipe);
        return packet;
    }

    public void afterStateUpdated() {
        if (this.pipe == null && this.coreState.pipeId != 0) {
            this.initialize(LogisticsBlockGenericPipe.createPipe((Item)Item.field_150901_e.func_148754_a(this.coreState.pipeId)));
        }
        if (this.pipe == null) {
            return;
        }
        this.field_145850_b.func_147458_c(this.field_145851_c, this.field_145848_d, this.field_145849_e, this.field_145851_c, this.field_145848_d, this.field_145849_e);
        if (this.renderState.needsRenderUpdate()) {
            this.field_145850_b.func_147458_c(this.field_145851_c, this.field_145848_d, this.field_145849_e, this.field_145851_c, this.field_145848_d, this.field_145849_e);
            this.renderState.clean();
        }
        this.tilePart.afterStateUpdated();
    }

    public void sendUpdateToClient() {
        this.sendClientUpdate = true;
    }

    public TileBuffer[] getTileCache() {
        if (this.tileBuffer == null && this.pipe != null) {
            this.tileBuffer = TileBuffer.makeBuffer(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e, this.pipe.transport.delveIntoUnloadedChunks());
        }
        return this.tileBuffer;
    }

    public void blockCreated(ForgeDirection from, Block block, TileEntity tile) {
        TileBuffer[] cache = this.getTileCache();
        if (cache != null) {
            cache[from.getOpposite().ordinal()].set(block, tile);
        }
    }

    @Override
    public TileEntity getTile(ForgeDirection to) {
        return this.getTile(to, false);
    }

    public TileEntity getTile(ForgeDirection to, boolean force) {
        TileBuffer[] cache = this.getTileCache();
        if (cache != null) {
            if (force) {
                cache[to.ordinal()].refresh();
            }
            return cache[to.ordinal()].getTile();
        }
        return null;
    }

    public Block getBlock(ForgeDirection to) {
        TileBuffer[] cache = this.getTileCache();
        if (cache != null) {
            return cache[to.ordinal()].getBlock();
        }
        return null;
    }

    private void computeConnections() {
        TileBuffer[] cache = this.getTileCache();
        if (cache == null) {
            return;
        }
        for (ForgeDirection side : ForgeDirection.VALID_DIRECTIONS) {
            TileBuffer t = cache[side.ordinal()];
            t.refresh();
            this.pipeConnectionsBuffer[side.ordinal()] = this.canPipeConnect(t.getTile(), side);
            this.pipeBCConnectionsBuffer[side.ordinal()] = this.pipeConnectionsBuffer[side.ordinal()] ? SimpleServiceLocator.buildCraftProxy.isTileGenericPipe(t.getTile()) : false;
        }
    }

    @Optional.Method(modid="BuildCraft|Transport")
    public boolean isPipeConnected(ForgeDirection with) {
        if (this.field_145850_b.field_72995_K) {
            return this.renderState.pipeConnectionMatrix.isConnected(with);
        }
        return this.pipeConnectionsBuffer[with.ordinal()];
    }

    public int fill(ForgeDirection from, FluidStack resource, boolean doFill) {
        if (LogisticsBlockGenericPipe.isValid(this.pipe) && this.pipe.transport instanceof IFluidHandler && !this.tilePart.hasBlockingPluggable(from)) {
            return ((IFluidHandler)this.pipe.transport).fill(from, resource, doFill);
        }
        return 0;
    }

    public FluidStack drain(ForgeDirection from, int maxDrain, boolean doDrain) {
        if (LogisticsBlockGenericPipe.isValid(this.pipe) && this.pipe.transport instanceof IFluidHandler && !this.tilePart.hasBlockingPluggable(from)) {
            return ((IFluidHandler)this.pipe.transport).drain(from, maxDrain, doDrain);
        }
        return null;
    }

    public FluidStack drain(ForgeDirection from, FluidStack resource, boolean doDrain) {
        if (LogisticsBlockGenericPipe.isValid(this.pipe) && this.pipe.transport instanceof IFluidHandler && !this.tilePart.hasBlockingPluggable(from)) {
            return ((IFluidHandler)this.pipe.transport).drain(from, resource, doDrain);
        }
        return null;
    }

    public boolean canFill(ForgeDirection from, Fluid fluid) {
        if (LogisticsBlockGenericPipe.isValid(this.pipe) && this.pipe.transport instanceof IFluidHandler && !this.tilePart.hasBlockingPluggable(from)) {
            return ((IFluidHandler)this.pipe.transport).canFill(from, fluid);
        }
        return false;
    }

    public boolean canDrain(ForgeDirection from, Fluid fluid) {
        if (LogisticsBlockGenericPipe.isValid(this.pipe) && this.pipe.transport instanceof IFluidHandler && !this.tilePart.hasBlockingPluggable(from)) {
            return ((IFluidHandler)this.pipe.transport).canDrain(from, fluid);
        }
        return false;
    }

    public FluidTankInfo[] getTankInfo(ForgeDirection from) {
        return null;
    }

    public void scheduleRenderUpdate() {
        this.refreshRenderState = true;
    }

    @SideOnly(value=Side.CLIENT)
    public IIconProvider getPipeIcons() {
        if (this.pipe == null) {
            return null;
        }
        return this.pipe.getIconProvider();
    }

    @SideOnly(value=Side.CLIENT)
    public double func_145833_n() {
        return 65536.0;
    }

    public boolean shouldRefresh(Block oldBlock, Block newBlock, int oldMeta, int newMeta, World world, int x, int y, int z) {
        return oldBlock != newBlock;
    }

    public boolean isSolidOnSide(ForgeDirection side) {
        return this.tilePart.isSolidOnSide(side);
    }

    public Block getBlock() {
        return this.func_145838_q();
    }

    @Override
    public World getWorld() {
        return this.field_145850_b;
    }

    public boolean isUseableByPlayer(EntityPlayer player) {
        return this.field_145850_b.func_147438_o(this.field_145851_c, this.field_145848_d, this.field_145849_e) == this;
    }

    @Optional.Method(modid="BuildCraft|Transport")
    public IPipeTile.PipeType getPipeType() {
        return (IPipeTile.PipeType)SimpleServiceLocator.buildCraftProxy.getLPPipeType();
    }

    public boolean func_145837_r() {
        if (this.pipe != null && this.pipe.preventRemove()) {
            return false;
        }
        return super.func_145837_r();
    }

    @Override
    public LogicController getLogicController() {
        return this.logicController;
    }

    @Override
    public ILPPipe getLPPipe() {
        return this.pipe;
    }

    @Optional.Method(modid="BuildCraft|Transport")
    public IPipe getPipe() {
        return (IPipe)this.tilePart.getBCPipePart().getOriginal();
    }

    @Optional.Method(modid="BuildCraft|Transport")
    public boolean canInjectItems(ForgeDirection from) {
        return this.isPipeConnected(from);
    }

    @Optional.Method(modid="BuildCraft|Transport")
    public int x() {
        return this.field_145851_c;
    }

    @Optional.Method(modid="BuildCraft|Transport")
    public int y() {
        return this.field_145848_d;
    }

    @Optional.Method(modid="BuildCraft|Transport")
    public int z() {
        return this.field_145849_e;
    }

    @Optional.Method(modid="BuildCraft|Transport")
    public Block getNeighborBlock(ForgeDirection dir) {
        return this.getBlock(dir);
    }

    @Optional.Method(modid="BuildCraft|Transport")
    public TileEntity getNeighborTile(ForgeDirection dir) {
        return this.getTile(dir);
    }

    @Optional.Method(modid="BuildCraft|Transport")
    public IPipe getNeighborPipe(ForgeDirection dir) {
        if (this.getTile(dir) instanceof IPipeTile) {
            return ((IPipeTile)this.getTile(dir)).getPipe();
        }
        return null;
    }

    @Optional.Method(modid="BuildCraft|Transport")
    public int getPipeColor() {
        return 0;
    }

    @Optional.Method(modid="BuildCraft|Transport")
    public PipePluggable getPipePluggable(ForgeDirection direction) {
        if (this.tilePart.getBCPipePluggable(direction) == null) {
            return null;
        }
        return (PipePluggable)this.tilePart.getBCPipePluggable(direction).getOriginal();
    }

    @Optional.Method(modid="BuildCraft|Transport")
    public boolean hasPipePluggable(ForgeDirection direction) {
        return this.tilePart.getBCPipePluggable(direction) != null;
    }

    @Optional.Method(modid="BuildCraft|Transport")
    public boolean hasBlockingPluggable(ForgeDirection direction) {
        if (this.tilePart.getBCPipePluggable(direction) == null) {
            return false;
        }
        return this.tilePart.getBCPipePluggable(direction).isBlocking();
    }

    @Optional.Method(modid="BuildCraft|Transport")
    public IPipeConnection.ConnectOverride overridePipeConnection(IPipeTile.PipeType pipeType, ForgeDirection forgeDirection) {
        if (this.pipe != null && this.pipe.isFluidPipe() && pipeType == IPipeTile.PipeType.FLUID) {
            return IPipeConnection.ConnectOverride.CONNECT;
        }
        return IPipeConnection.ConnectOverride.DEFAULT;
    }

    public void func_145834_a(World world) {
        super.func_145834_a(world);
        this.tilePart.setWorldObj_LP(world);
    }

    @SideOnly(value=Side.CLIENT)
    public AxisAlignedBB getRenderBoundingBox() {
        return AxisAlignedBB.func_72330_a((double)this.field_145851_c, (double)this.field_145848_d, (double)this.field_145849_e, (double)(this.field_145851_c + 1), (double)(this.field_145848_d + 1), (double)(this.field_145849_e + 1));
    }

    @Override
    public double getDistanceTo(int destinationint, ForgeDirection ignore, ItemIdentifier ident, boolean isActive, double traveled, double max, List<LPPosition> visited) {
        if (this.pipe == null || traveled > max) {
            return 2.147483647E9;
        }
        double result = this.pipe.getDistanceTo(destinationint, ignore, ident, isActive, traveled + this.getDistance(), max, visited);
        if (result == 2.147483647E9) {
            return result;
        }
        return result + (double)((int)this.getDistance());
    }

    @Override
    public boolean acceptItem(LPTravelingItem item, TileEntity from) {
        if (LogisticsBlockGenericPipe.isValid(this.pipe) && this.pipe.transport != null) {
            this.pipe.transport.injectItem(item, item.output);
            return true;
        }
        return false;
    }

    @Override
    public void refreshTileCacheOnSide(ForgeDirection side) {
        TileBuffer[] cache = this.getTileCache();
        if (cache != null) {
            cache[side.ordinal()].refresh();
        }
    }

    public boolean isInitialized() {
        return this.initialized;
    }

    public static class CoreState
    implements IClientState {
        public int pipeId = -1;

        @Override
        public void writeData(LPDataOutputStream data) throws IOException {
            data.writeInt(this.pipeId);
        }

        @Override
        public void readData(LPDataInputStream data) throws IOException {
            this.pipeId = data.readInt();
        }
    }
}

