/*
 * Decompiled with CFR 0.152.
 */
package logisticspipes.network.abstractguis;

import java.io.IOException;
import logisticspipes.modules.abstractmodules.LogisticsModule;
import logisticspipes.network.LPDataInputStream;
import logisticspipes.network.LPDataOutputStream;
import logisticspipes.network.abstractguis.CoordinatesGuiProvider;
import logisticspipes.pipes.PipeLogisticsChassi;
import logisticspipes.pipes.basic.CoreRoutedPipe;
import logisticspipes.pipes.basic.LogisticsTileGenericPipe;
import net.minecraft.world.World;

public abstract class ModuleCoordinatesGuiProvider
extends CoordinatesGuiProvider {
    private LogisticsModule.ModulePositionType slot;
    private int positionInt;

    public ModuleCoordinatesGuiProvider(int id) {
        super(id);
    }

    @Override
    public void writeData(LPDataOutputStream data) throws IOException {
        super.writeData(data);
        data.writeEnum(this.slot);
        data.writeInt(this.positionInt);
    }

    @Override
    public void readData(LPDataInputStream data) throws IOException {
        super.readData(data);
        this.slot = data.readEnum(LogisticsModule.ModulePositionType.class);
        this.positionInt = data.readInt();
    }

    public <T> T getLogisticsModule(World world, Class<T> clazz) {
        LogisticsModule module;
        LogisticsTileGenericPipe pipe = this.getPipe(world);
        if (pipe == null || !(pipe.pipe instanceof CoreRoutedPipe)) {
            return null;
        }
        if (this.slot == LogisticsModule.ModulePositionType.IN_PIPE) {
            module = ((CoreRoutedPipe)pipe.pipe).getLogisticsModule();
        } else {
            if (this.slot == LogisticsModule.ModulePositionType.IN_HAND) {
                throw new UnsupportedOperationException("NO IN_HAND FOR THIS PACKET TYPE");
            }
            if (!(pipe.pipe instanceof PipeLogisticsChassi)) {
                return null;
            }
            module = ((PipeLogisticsChassi)pipe.pipe).getLogisticsModule().getSubModule(this.positionInt);
        }
        if (module != null && !clazz.isAssignableFrom(module.getClass())) {
            return null;
        }
        return (T)module;
    }

    public LogisticsModule.ModulePositionType getSlot() {
        return this.slot;
    }

    public ModuleCoordinatesGuiProvider setSlot(LogisticsModule.ModulePositionType slot) {
        this.slot = slot;
        return this;
    }

    public int getPositionInt() {
        return this.positionInt;
    }

    public ModuleCoordinatesGuiProvider setPositionInt(int positionInt) {
        this.positionInt = positionInt;
        return this;
    }
}

