/*
 * Decompiled with CFR 0.152.
 */
package logisticspipes.modules;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.Collection;
import logisticspipes.interfaces.IInventoryUtil;
import logisticspipes.interfaces.IPipeServiceProvider;
import logisticspipes.interfaces.IWorldProvider;
import logisticspipes.modules.abstractmodules.LogisticsModule;
import logisticspipes.pipes.basic.CoreRoutedPipe;
import logisticspipes.proxy.SimpleServiceLocator;
import logisticspipes.utils.AdjacentTile;
import logisticspipes.utils.SidedInventoryMinecraftAdapter;
import logisticspipes.utils.SinkReply;
import logisticspipes.utils.WorldUtil;
import logisticspipes.utils.item.ItemIdentifier;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.IIcon;

public class ModuleSatelite
extends LogisticsModule {
    private final CoreRoutedPipe pipe;
    private final SinkReply _sinkReply = new SinkReply(SinkReply.FixedPriority.ItemSink, 0, true, false, 1, 0, null);

    public ModuleSatelite(CoreRoutedPipe pipeItemsSatelliteLogistics) {
        this.pipe = pipeItemsSatelliteLogistics;
    }

    @Override
    public void registerHandler(IWorldProvider world, IPipeServiceProvider service) {
    }

    @Override
    public final int getX() {
        return this.pipe.getX();
    }

    @Override
    public final int getY() {
        return this.pipe.getY();
    }

    @Override
    public final int getZ() {
        return this.pipe.getZ();
    }

    @Override
    public SinkReply sinksItem(ItemIdentifier item, int bestPriority, int bestCustomPriority, boolean allowDefault, boolean includeInTransit) {
        if (bestPriority > this._sinkReply.fixedPriority.ordinal() || bestPriority == this._sinkReply.fixedPriority.ordinal() && bestCustomPriority >= this._sinkReply.customPriority) {
            return null;
        }
        return new SinkReply(this._sinkReply, this.spaceFor(item, includeInTransit));
    }

    private int spaceFor(ItemIdentifier item, boolean includeInTransit) {
        int count = 0;
        WorldUtil wUtil = new WorldUtil(this.pipe.getWorld(), this.pipe.getX(), this.pipe.getY(), this.pipe.getZ());
        for (AdjacentTile tile : wUtil.getAdjacentTileEntities(true)) {
            if (!(tile.tile instanceof IInventory)) continue;
            IInventory base = (IInventory)tile.tile;
            if (base instanceof ISidedInventory) {
                base = new SidedInventoryMinecraftAdapter((ISidedInventory)base, tile.orientation.getOpposite(), false);
            }
            IInventoryUtil inv = SimpleServiceLocator.inventoryUtilFactory.getInventoryUtil(base, tile.orientation);
            count += inv.roomForItem(item, 9999);
        }
        if (includeInTransit) {
            count -= this.pipe.countOnRoute(item);
        }
        return count;
    }

    @Override
    public LogisticsModule getSubModule(int slot) {
        return null;
    }

    @Override
    public void readFromNBT(NBTTagCompound nbttagcompound) {
    }

    @Override
    public void writeToNBT(NBTTagCompound nbttagcompound) {
    }

    @Override
    public void tick() {
    }

    @Override
    public boolean hasGenericInterests() {
        return false;
    }

    @Override
    public Collection<ItemIdentifier> getSpecificInterests() {
        return this.pipe.getSpecificInterests();
    }

    @Override
    public boolean interestedInAttachedInventory() {
        return false;
    }

    @Override
    public boolean interestedInUndamagedID() {
        return false;
    }

    @Override
    public boolean recievePassive() {
        return false;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public IIcon getIconTexture(IIconRegister register) {
        return null;
    }
}

