/*
 * Decompiled with CFR 0.152.
 */
package com.creativemd.littletiles.common.structure;

import com.creativemd.creativecore.common.gui.SubGui;
import com.creativemd.creativecore.common.utils.HashMapList;
import com.creativemd.littletiles.common.structure.LittleBed;
import com.creativemd.littletiles.common.structure.LittleChair;
import com.creativemd.littletiles.common.structure.LittleDoor;
import com.creativemd.littletiles.common.structure.LittleFixedStructure;
import com.creativemd.littletiles.common.structure.LittleLadder;
import com.creativemd.littletiles.common.tileentity.TileEntityLittleTiles;
import com.creativemd.littletiles.common.utils.LittleTile;
import com.creativemd.littletiles.common.utils.small.LittleTileCoord;
import com.creativemd.littletiles.utils.PreviewTile;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.HashMap;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ChunkCoordinates;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.EmptyChunk;
import net.minecraftforge.common.util.ForgeDirection;

public abstract class LittleStructure {
    private static final HashMap<String, LittleStructureEntry> structures = new HashMap();
    public LittleTile mainTile;
    private ArrayList<LittleTile> tiles = null;
    public ArrayList<LittleTileCoord> tilesToLoad = null;
    public ItemStack dropStack;

    public static ArrayList<String> getStructureNames() {
        return new ArrayList<String>(structures.keySet());
    }

    public static void registerLittleStructure(String id, LittleStructure structure) {
        LittleStructure.registerLittleStructure(id, new LittleStructureEntry(structure.getClass(), structure));
    }

    public static void registerLittleStructure(String id, LittleStructureEntry entry) {
        if (structures.containsKey(id)) {
            System.out.println("ID is already taken! id=" + id);
        } else if (structures.containsValue(entry)) {
            System.out.println("Already registered class=" + entry);
        } else {
            structures.put(id, entry);
        }
    }

    public static String getIDByClass(Class<? extends LittleStructure> classStructure) {
        for (String id : structures.keySet()) {
            if (!classStructure.equals(LittleStructure.structures.get((Object)id).structureClass)) continue;
            return id;
        }
        return "";
    }

    public static Class<? extends LittleStructure> getClassByID(String id) {
        LittleStructureEntry entry = structures.get(id);
        if (entry != null) {
            return entry.structureClass;
        }
        return null;
    }

    public static LittleStructureEntry getEntryByID(String id) {
        return structures.get(id);
    }

    public static void initStructures() {
        LittleStructure.registerLittleStructure("fixed", new LittleFixedStructure());
        LittleStructure.registerLittleStructure("chair", new LittleChair());
        LittleStructure.registerLittleStructure("door", new LittleDoor());
        LittleStructure.registerLittleStructure("ladder", new LittleLadder());
        LittleStructure.registerLittleStructure("bed", new LittleBed());
    }

    public static LittleStructure createAndLoadStructure(NBTTagCompound nbt, LittleTile mainTile) {
        Class<? extends LittleStructure> classStructure;
        if (nbt == null) {
            return null;
        }
        String id = nbt.func_74779_i("id");
        LittleStructureEntry entry = LittleStructure.getEntryByID(id);
        if (entry != null && (classStructure = entry.structureClass) != null) {
            LittleStructure structure = null;
            try {
                structure = classStructure.getConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (Exception e) {
                System.out.println("Found invalid structureID=" + id);
            }
            structure.mainTile = mainTile;
            structure.loadFromNBT(nbt);
            return structure;
        }
        return null;
    }

    public void setTiles(ArrayList<LittleTile> tiles) {
        this.tiles = tiles;
    }

    public ArrayList<LittleTile> getTiles() {
        if (this.tiles == null && !this.loadTiles()) {
            return new ArrayList<LittleTile>();
        }
        return this.tiles;
    }

    public boolean hasLoaded() {
        this.loadTiles();
        return this.tilesToLoad == null || this.tilesToLoad.size() == 0;
    }

    public boolean loadTiles() {
        if (this.mainTile != null) {
            if (this.tiles == null) {
                this.tiles = new ArrayList();
                this.tiles.add(this.mainTile);
            }
            if (this.tilesToLoad == null) {
                return true;
            }
            int i = 0;
            while (i < this.tilesToLoad.size()) {
                if (this.checkForTile(this.mainTile.te.func_145831_w(), this.tilesToLoad.get(i))) {
                    this.tilesToLoad.remove(i);
                    continue;
                }
                ++i;
            }
            if (this.tilesToLoad.size() == 0) {
                this.tilesToLoad = null;
            }
            return true;
        }
        return false;
    }

    public void loadFromNBT(NBTTagCompound nbt) {
        if (nbt.func_74764_b("stack")) {
            this.dropStack = ItemStack.func_77949_a((NBTTagCompound)nbt.func_74775_l("stack"));
        }
        if (nbt.func_74764_b("count")) {
            this.tilesToLoad = new ArrayList();
            int count = nbt.func_74762_e("count");
            for (int i = 0; i < count; ++i) {
                LittleTileCoord coord;
                if (nbt.func_74764_b("i" + i + "coX")) {
                    LittleTile.LittleTilePosition pos = new LittleTile.LittleTilePosition("i" + i, nbt);
                    coord = new LittleTileCoord(this.mainTile.te, pos.coord, pos.position);
                } else {
                    coord = new LittleTileCoord("i" + i, nbt);
                }
                this.tilesToLoad.add(coord);
            }
        }
        this.loadFromNBTExtra(nbt);
    }

    protected abstract void loadFromNBTExtra(NBTTagCompound var1);

    public void writeToNBT(NBTTagCompound nbt) {
        if (this.dropStack != null) {
            NBTTagCompound nbtStack = new NBTTagCompound();
            this.dropStack.func_77955_b(nbtStack);
            nbt.func_74782_a("stack", (NBTBase)nbtStack);
        }
        nbt.func_74778_a("id", this.getIDOfStructure());
        if (this.tiles != null) {
            nbt.func_74768_a("count", this.tiles.size());
            for (int i = 0; i < this.tiles.size(); ++i) {
                if (!this.tiles.get((int)i).isStructureBlock) continue;
                this.tiles.get(i).updateCorner();
                new LittleTileCoord(this.mainTile.te, this.tiles.get((int)i).te.getCoord(), this.tiles.get((int)i).cornerVec.copy()).writeToNBT("i" + i, nbt);
            }
        }
        if (this.tilesToLoad != null) {
            int start = nbt.func_74762_e("count");
            nbt.func_74768_a("count", start + this.tilesToLoad.size());
            for (int i = 0; i < this.tilesToLoad.size(); ++i) {
                this.tilesToLoad.get(i).writeToNBT("i" + (i + start), nbt);
            }
        }
        this.writeToNBTExtra(nbt);
    }

    protected abstract void writeToNBTExtra(NBTTagCompound var1);

    public boolean checkForTile(World world, LittleTileCoord pos) {
        LittleTile tile;
        TileEntity tileEntity;
        ChunkCoordinates coord = pos.getAbsolutePosition(this.mainTile.te);
        Chunk chunk = world.func_72938_d(coord.field_71574_a, coord.field_71573_c);
        if (!(chunk instanceof EmptyChunk) && (tileEntity = world.func_147438_o(coord.field_71574_a, coord.field_71572_b, coord.field_71573_c)) instanceof TileEntityLittleTiles && (tile = ((TileEntityLittleTiles)tileEntity).getTile(pos.position)) != null && tile.isStructureBlock) {
            if (!this.tiles.contains(tile)) {
                this.tiles.add(tile);
            }
            tile.structure = this;
            return true;
        }
        return false;
    }

    public ArrayList<PreviewTile> getSpecialTiles() {
        return new ArrayList<PreviewTile>();
    }

    public void onLittleTileDestory() {
        ArrayList<LittleTile> tiles = this.getTiles();
        for (LittleTile tile : tiles) {
            tile.te.removeTile(tile);
        }
    }

    public ItemStack getStructureDrop() {
        return this.dropStack;
    }

    public boolean onBlockActivated(World world, LittleTile tile, int x, int y, int z, EntityPlayer player, int side, float moveX, float moveY, float moveZ) {
        return false;
    }

    public HashMapList<ChunkCoordinates, LittleTile> getTilesSortedPerBlock() {
        HashMapList coords = new HashMapList();
        ArrayList<LittleTile> tiles = this.getTiles();
        for (LittleTile tile : tiles) {
            coords.add((Object)tile.te.getCoord(), (Object)tile);
        }
        return coords;
    }

    public void onFlip(World world, EntityPlayer player, ItemStack stack, ForgeDirection direction) {
    }

    public void onRotate(World world, EntityPlayer player, ItemStack stack, ForgeDirection direction) {
    }

    @SideOnly(value=Side.CLIENT)
    public abstract void createControls(SubGui var1, LittleStructure var2);

    @SideOnly(value=Side.CLIENT)
    public abstract LittleStructure parseStructure(SubGui var1);

    public String getIDOfStructure() {
        return LittleStructure.getIDByClass(this.getClass());
    }

    public boolean isBed(IBlockAccess world, int x, int y, int z, EntityLivingBase player) {
        return false;
    }

    public boolean isLadder() {
        return false;
    }

    public static class LittleStructureEntry {
        public Class<? extends LittleStructure> structureClass;
        public LittleStructure parser;

        public LittleStructureEntry(Class<? extends LittleStructure> structureClass, LittleStructure parser) {
            this.structureClass = structureClass;
            this.parser = parser;
        }

        public boolean equals(Object object) {
            return object instanceof LittleStructureEntry && ((LittleStructureEntry)object).structureClass == this.structureClass;
        }

        public String toString() {
            return this.structureClass.toString();
        }
    }
}

