/*
 * Decompiled with CFR 0.152.
 */
package client.renderer;

import common.tileentities.TE_ItemProxyCable;
import cpw.mods.fml.client.registry.ISimpleBlockRenderingHandler;
import cpw.mods.fml.client.registry.RenderingRegistry;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.common.util.ForgeDirection;

public class ConduitRenderer
implements ISimpleBlockRenderingHandler {
    public static final int RID = RenderingRegistry.getNextAvailableRenderId();
    private static final ConduitRenderer INSTANCE = new ConduitRenderer();

    private ConduitRenderer() {
    }

    public static ConduitRenderer getInstance() {
        return INSTANCE;
    }

    public void renderInventoryBlock(Block block, int metadata, int modelId, RenderBlocks renderer) {
    }

    public boolean renderWorldBlock(IBlockAccess world, int x, int y, int z, Block block, int modelId, RenderBlocks renderer) {
        TileEntity te = world.func_147438_o(x, y, z);
        if (te instanceof TE_ItemProxyCable) {
            TE_ItemProxyCable cable = (TE_ItemProxyCable)te;
            float thickness = TE_ItemProxyCable.getThickness();
            float space = (1.0f - thickness) / 2.0f;
            float xThickness = thickness;
            float xOffset = space;
            float yThickness = thickness;
            float yOffset = space;
            float zThickness = thickness;
            float zOffset = space;
            block8: for (ForgeDirection side : ForgeDirection.VALID_DIRECTIONS) {
                if (!cable.isConnected(side)) continue;
                switch (side) {
                    case DOWN: {
                        yOffset = 0.0f;
                        yThickness += space;
                        continue block8;
                    }
                    case UP: {
                        yThickness += space;
                        continue block8;
                    }
                    case NORTH: {
                        zOffset = 0.0f;
                        zThickness += space;
                        continue block8;
                    }
                    case SOUTH: {
                        zThickness += space;
                        continue block8;
                    }
                    case WEST: {
                        xOffset += 0.0f;
                        xThickness += space;
                        continue block8;
                    }
                    case EAST: {
                        xThickness += space;
                    }
                }
            }
            block.func_149676_a(xOffset, yOffset, zOffset, xOffset + xThickness, yOffset + yThickness, zOffset + zThickness);
            renderer.func_147775_a(block);
        }
        return false;
    }

    public boolean shouldRender3DInInventory(int modelId) {
        return true;
    }

    public int getRenderId() {
        return RID;
    }
}

