/*
 * Decompiled with CFR 0.152.
 */
package se.rupy.http;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilePermission;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.ConnectException;
import java.net.HttpURLConnection;
import java.net.SocketPermission;
import java.net.URL;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.PermissionCollection;
import java.security.Permissions;
import java.security.PrivilegedExceptionAction;
import java.security.ProtectionDomain;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Properties;
import java.util.Vector;
import java.util.jar.JarEntry;
import java.util.jar.JarInputStream;
import se.rupy.http.Daemon;
import se.rupy.http.Event;
import se.rupy.http.Failure;
import se.rupy.http.Input;
import se.rupy.http.Service;

public class Deploy
extends Service {
    protected static String path;
    protected static String pass;

    public Deploy(String path, String pass) {
        Deploy.path = path;
        Deploy.pass = pass;
        new File(path).mkdirs();
    }

    public Deploy(String path) {
        Deploy.path = path;
        new File(path).mkdirs();
    }

    @Override
    public String path() {
        return "/deploy";
    }

    @Override
    public void filter(Event event) throws Event, Exception {
        String name = event.query().header("file");
        String size = event.query().header("size");
        String pass = event.query().header("pass");
        if (name == null) {
            throw new Failure("File header missing.");
        }
        if (pass == null) {
            throw new Failure("Pass header missing.");
        }
        if (Deploy.pass == null) {
            if (size != null && size.length() > 0 && Integer.parseInt(size) > 0x200000) {
                throw new Exception("Maximum deployable size is 2MB.");
            }
            Properties properties = new Properties();
            properties.load(new FileInputStream(new File("passport")));
            String port = properties.getProperty(name.substring(0, name.lastIndexOf(46)));
            if (port == null || !port.equals(pass)) {
                throw new Exception("Pass verification failed. (" + name + ")");
            }
        } else {
            if (!Deploy.pass.equals(pass)) {
                throw new Failure("Pass verification failed. (" + pass + ")");
            }
            if (Deploy.pass.equals("secret") && !event.remote().equals("127.0.0.1")) {
                throw new Failure("'secret' pass can only deploy from 127.0.0.1. (" + event.remote() + ")");
            }
        }
        File file = new File(path + name);
        FileOutputStream out = new FileOutputStream(file);
        Input in = event.query().input();
        if (Deploy.pass == null) {
            try {
                Deploy.pipe(in, out, 1024, 0x200000);
            }
            catch (IOException e) {
                file.delete();
                throw e;
            }
        } else {
            Deploy.pipe(in, out, 1024);
        }
        out.flush();
        ((OutputStream)out).close();
        event.reply().output().print("Application '" + Deploy.deploy(event.daemon(), file) + "' deployed.");
    }

    public static String deploy(Daemon daemon, File file) throws Exception {
        Archive archive = new Archive(daemon, file);
        daemon.chain(archive);
        daemon.verify(archive);
        return archive.name();
    }

    public static String name(String name) {
        name = name.substring(0, name.indexOf("."));
        name = name.replace("/", ".");
        return name;
    }

    public static int pipe(InputStream in, OutputStream out) throws IOException {
        return Deploy.pipe(in, out, 1024, 0);
    }

    public static int pipe(InputStream in, OutputStream out, int length) throws IOException {
        return Deploy.pipe(in, out, length, 0);
    }

    public static int pipe(InputStream in, OutputStream out, int length, int limit) throws IOException {
        byte[] data = new byte[length];
        int total = 0;
        int read = in.read(data);
        while (read > -1) {
            if (limit > 0 && total > limit) {
                throw new IOException("Max allowed bytes read. (" + limit + ")");
            }
            total += read;
            out.write(data, 0, read);
            read = in.read(data);
        }
        return total;
    }

    public static void main(String[] args) {
        if (args.length > 2) {
            try {
                URL url = new URL("http://" + args[0] + "/deploy");
                File file = new File(args[1]);
                InputStream in = new Client().send(url, file, args[2]);
                System.out.println(new SimpleDateFormat("H:mm").format(new Date()) + " " + Client.toString(in));
            }
            catch (ConnectException ce) {
                System.out.println("Connection failed, is there a server running on " + args[0] + "?");
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        } else {
            System.out.println("Usage: Deploy [host] [file] [pass]");
        }
    }

    static class JarInput
    extends JarInputStream {
        public JarInput(InputStream in) throws IOException {
            super(in);
        }

        @Override
        public void close() {
        }
    }

    static class Client {
        Client() {
        }

        InputStream send(URL url, File file, String pass) throws IOException {
            return this.send(url, file, pass, true);
        }

        InputStream send(URL url, File file, String pass, boolean chunk) throws IOException {
            int code;
            HttpURLConnection conn = (HttpURLConnection)url.openConnection();
            conn.setRequestMethod("POST");
            OutputStream out = null;
            InputStream in = null;
            if (file != null) {
                conn.addRequestProperty("File", file.getName());
                conn.addRequestProperty("Size", "" + file.length());
                if (pass != null) {
                    conn.addRequestProperty("Pass", pass);
                }
                if (chunk) {
                    conn.setChunkedStreamingMode(0);
                }
                conn.setDoOutput(true);
                out = conn.getOutputStream();
                in = new FileInputStream(file);
                Deploy.pipe(in, out);
                out.flush();
                in.close();
            }
            if ((code = conn.getResponseCode()) == 200) {
                in = conn.getInputStream();
            } else {
                if (code < 0) {
                    throw new IOException("HTTP response unreadable.");
                }
                in = conn.getErrorStream();
            }
            return in;
        }

        static String toString(InputStream in) throws IOException {
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            Deploy.pipe(in, out);
            out.close();
            in.close();
            return new String(out.toByteArray());
        }
    }

    static interface Stream {
        public String name();

        public InputStream input();

        public long length();

        public long date();
    }

    static class Small
    implements Stream {
        private String name;
        private byte[] data;
        private long date;
        private Class clazz;

        public Small(String name, byte[] data) {
            this(name, data, 0L);
        }

        public Small(String name, byte[] data, long date) {
            this.name = name;
            this.data = data;
            this.date = date - date % 1000L;
        }

        @Override
        public String name() {
            return this.name;
        }

        @Override
        public InputStream input() {
            return new ByteArrayInputStream(this.data);
        }

        @Override
        public long length() {
            return this.data.length;
        }

        @Override
        public long date() {
            return this.date;
        }

        byte[] data() {
            return this.data;
        }

        public String toString() {
            return this.name;
        }
    }

    static class Big
    implements Stream {
        private File file;
        private String name;
        private long date;

        public Big(String host, String name, InputStream in, long date) throws IOException {
            this.file = Big.write(host, name, in);
            this.name = name;
            this.date = date - date % 1000L;
        }

        public Big(File file) {
            long date = file.lastModified();
            this.name = file.getName();
            this.file = file;
            this.date = date - date % 1000L;
        }

        static File write(String host, String name, InputStream in) throws IOException {
            String path = name.substring(0, name.lastIndexOf("/"));
            String root = Deploy.path + host;
            new File(root + path).mkdirs();
            File file = new File(root + name);
            file.createNewFile();
            FileOutputStream out = new FileOutputStream(file);
            Deploy.pipe(in, out);
            out.flush();
            ((OutputStream)out).close();
            return file;
        }

        @Override
        public String name() {
            return this.name;
        }

        @Override
        public InputStream input() {
            try {
                return new FileInputStream(this.file);
            }
            catch (FileNotFoundException e) {
                return null;
            }
        }

        @Override
        public long length() {
            return this.file.length();
        }

        @Override
        public long date() {
            return this.date;
        }
    }

    public static class Archive
    extends ClassLoader {
        private AccessControlContext access;
        private HashSet service;
        private HashMap chain;
        private String name;
        private String host;
        private long date;
        Vector classes = new Vector();
        static Archive deployer = new Archive();

        Archive() {
            Permissions permissions = new Permissions();
            ((PermissionCollection)permissions).add(new SocketPermission("*", "listen,accept,resolve,connect"));
            ((PermissionCollection)permissions).add(new FilePermission("-", "read"));
            ((PermissionCollection)permissions).add(new FilePermission("-", "write"));
            ((PermissionCollection)permissions).add(new FilePermission("-", "delete"));
            ((PermissionCollection)permissions).add(new RuntimePermission("createClassLoader"));
            this.access = new AccessControlContext(new ProtectionDomain[]{new ProtectionDomain(null, permissions)});
        }

        Archive(Daemon daemon, File file) throws Exception {
            this.service = new HashSet();
            this.chain = new HashMap();
            this.name = file.getName();
            this.date = file.lastModified();
            JarInput in = new JarInput(new FileInputStream(file));
            if (daemon.host) {
                this.host = this.name.substring(0, this.name.lastIndexOf(46));
                String path = "app" + File.separator + this.host + File.separator;
                Permissions permissions = new Permissions();
                ((PermissionCollection)permissions).add(new SocketPermission("localhost", "resolve,connect"));
                ((PermissionCollection)permissions).add(new FilePermission(path + "-", "read"));
                ((PermissionCollection)permissions).add(new FilePermission(path + "-", "write"));
                ((PermissionCollection)permissions).add(new FilePermission(path + "-", "delete"));
                this.access = new AccessControlContext(new ProtectionDomain[]{new ProtectionDomain(null, permissions)});
                new File(path).mkdirs();
            } else {
                this.host = "content";
            }
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            JarEntry entry = null;
            while ((entry = in.getNextJarEntry()) != null) {
                if (entry.getName().endsWith(".class")) {
                    Deploy.pipe(in, out);
                    byte[] data = out.toByteArray();
                    out.reset();
                    String name = Archive.name(entry.getName());
                    this.classes.add(new Small(name, data));
                    continue;
                }
                if (entry.isDirectory()) continue;
                Big.write(this.host, "/" + entry.getName(), in);
            }
            int length = this.classes.size();
            String missing = "";
            Small small = null;
            while (this.classes.size() > 0) {
                small = (Small)this.classes.elementAt(0);
                this.classes.removeElement(small);
                this.instantiate(small, daemon);
            }
        }

        protected Class findClass(String name) throws ClassNotFoundException {
            Small small = null;
            for (int i = 0; i < this.classes.size(); ++i) {
                small = (Small)this.classes.get(i);
                if (!small.name.equals(name)) continue;
                small.clazz = this.defineClass(small.name, small.data, 0, small.data.length);
                this.resolveClass(small.clazz);
                return small.clazz;
            }
            throw new ClassNotFoundException();
        }

        private void instantiate(final Small small, Daemon daemon) throws Exception {
            boolean service;
            block8: {
                if (small.clazz == null) {
                    small.clazz = this.defineClass(small.name, small.data, 0, small.data.length);
                    this.resolveClass(small.clazz);
                }
                service = false;
                for (Class clazz = small.clazz.getSuperclass(); clazz != null; clazz = clazz.getSuperclass()) {
                    if (!clazz.getCanonicalName().equals("se.rupy.http.Service")) continue;
                    service = true;
                }
                if (service) {
                    try {
                        if (daemon.host) {
                            Service s = (Service)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                                public Object run() throws Exception {
                                    return (Service)small.clazz.newInstance();
                                }
                            }, this.access());
                            this.service.add(s);
                        } else {
                            this.service.add(small.clazz.newInstance());
                        }
                    }
                    catch (Exception e) {
                        if (!daemon.verbose) break block8;
                        daemon.out.println(small.name + " couldn't be instantiated!");
                    }
                }
            }
            if (daemon.debug) {
                daemon.out.println(small.name + (service ? "*" : ""));
            }
        }

        protected AccessControlContext access() {
            return this.access;
        }

        protected static String name(String name) {
            name = name.substring(0, name.indexOf("."));
            if ((name = name.replace("/", ".")).startsWith("WEB-INF.classes")) {
                name = name.substring(16);
            }
            return name;
        }

        public String name() {
            return this.name;
        }

        public String host() {
            return this.host;
        }

        public long date() {
            return this.date;
        }

        protected HashMap chain() {
            return this.chain;
        }

        protected HashSet service() {
            return this.service;
        }
    }
}

