/*
 * Decompiled with CFR 0.152.
 */
package com.sinthoras.hydroenergy.server;

import com.sinthoras.hydroenergy.HE;
import com.sinthoras.hydroenergy.config.HEConfig;
import com.sinthoras.hydroenergy.network.packet.HEPacketSynchronize;
import com.sinthoras.hydroenergy.server.HEDam;
import cpw.mods.fml.common.gameevent.PlayerEvent;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import net.minecraft.world.WorldSavedData;

public class HEServer
extends WorldSavedData {
    private HEDam[] dams;
    public static HEServer instance;

    public HEServer() {
        super("hydroenergy");
    }

    public HEServer(String name) {
        super(name);
        this.dams = new HEDam[HEConfig.maxDams];
        for (int waterId = 0; waterId < HEConfig.maxDams; ++waterId) {
            this.dams[waterId] = new HEDam(waterId);
        }
    }

    public static HEServer load(World world) {
        HEServer instance = (HEServer)world.field_72988_C.func_75742_a(HEServer.class, "hydroenergy");
        if (instance == null) {
            instance = new HEServer("hydroenergy");
            world.field_72988_C.func_75745_a("hydroenergy", (WorldSavedData)instance);
            HE.info("Initializing dam data");
        } else {
            HE.info("Dam data loaded");
        }
        return instance;
    }

    public void func_76184_a(NBTTagCompound compound) {
        this.dams = new HEDam[HEConfig.maxDams];
        for (int waterId = 0; waterId < HEConfig.maxDams; ++waterId) {
            this.dams[waterId] = new HEDam(waterId);
            this.dams[waterId].readFromNBTFull(compound.func_74775_l("dam" + waterId));
        }
    }

    public void func_76187_b(NBTTagCompound compound) {
        for (int waterId = 0; waterId < HEConfig.maxDams; ++waterId) {
            NBTTagCompound damCompound = new NBTTagCompound();
            this.dams[waterId].writeToNBTFull(damCompound);
            compound.func_74782_a("dam" + waterId, (NBTBase)damCompound);
        }
    }

    public boolean canControllerBePlaced() {
        for (HEDam dam : this.dams) {
            if (dam.isPlaced()) continue;
            return true;
        }
        return false;
    }

    public void onBreakController(int waterId) {
        this.dams[waterId].breakController();
        this.func_76185_a();
    }

    public int onPlacecontroller(String ownerName, int dimensionId, int blockX, int blockY, int blockZ, int waterBlockX, int waterBlockY, int waterBlockZ) {
        for (int waterId = 0; waterId < HEConfig.maxDams; ++waterId) {
            if (this.dams[waterId].isPlaced()) continue;
            this.dams[waterId].placeController(ownerName, dimensionId, blockX, blockY, blockZ, waterBlockX, waterBlockY, waterBlockZ);
            this.func_76185_a();
            return waterId;
        }
        return -1;
    }

    public void onWaterRemoved(int waterId, int blockY) {
        this.dams[waterId].onWaterRemoved(blockY);
        this.func_76185_a();
    }

    public void onWaterPlaced(int waterId, int blockY) {
        this.dams[waterId].onWaterPlaced(blockY);
        this.func_76185_a();
    }

    public float getWaterLevel(int waterId) {
        return this.dams[waterId].getWaterLevel();
    }

    public void setWaterLevel(int waterId, float waterLevel) {
        if (this.dams[waterId].setWaterLevel(waterLevel)) {
            this.func_76185_a();
        }
    }

    public void setMode(int waterId, HE.DamMode mode) {
        this.dams[waterId].setMode(mode);
    }

    public int getWaterLimitWest(int waterId) {
        return this.dams[waterId].getLimitWest();
    }

    public int getWaterLimitDown(int waterId) {
        return this.dams[waterId].getLimitDown();
    }

    public int getWaterLimitNorth(int waterId) {
        return this.dams[waterId].getLimitNorth();
    }

    public int getWaterLimitEast(int waterId) {
        return this.dams[waterId].getLimitEast();
    }

    public int getWaterLimitUp(int waterId) {
        return this.dams[waterId].getLimitUp();
    }

    public int getWaterLimitSouth(int waterId) {
        return this.dams[waterId].getLimitSouth();
    }

    public boolean isBlockOutOfBounds(int waterId, int blockX, int blockY, int blockZ) {
        HEDam dam = this.dams[waterId];
        return blockX > dam.limitEast || blockX < dam.limitWest || blockY > dam.limitUp || blockY < dam.limitDown || blockZ > dam.limitSouth || blockZ < dam.limitNorth;
    }

    public void setWaterLimitWest(int waterId, int limitWest) {
        if (this.dams[waterId].setLimitWest(limitWest)) {
            this.func_76185_a();
        }
    }

    public void setWaterLimitDown(int waterId, int limitDown) {
        if (this.dams[waterId].setLimitDown(limitDown)) {
            this.func_76185_a();
        }
    }

    public void setWaterLimitNorth(int waterId, int limitNorth) {
        if (this.dams[waterId].setLimitNorth(limitNorth)) {
            this.func_76185_a();
        }
    }

    public void setWaterLimitEast(int waterId, int limitEast) {
        if (this.dams[waterId].setLimitEast(limitEast)) {
            this.func_76185_a();
        }
    }

    public void setWaterLimitUp(int waterId, int limitUp) {
        if (this.dams[waterId].setLimitUp(limitUp)) {
            this.func_76185_a();
        }
    }

    public void setWaterLimitSouth(int waterId, int limitSouth) {
        if (this.dams[waterId].setLimitSouth(limitSouth)) {
            this.func_76185_a();
        }
    }

    public boolean canSpread(int waterId) {
        return this.dams[waterId].canSpread();
    }

    public void synchronizeClient(PlayerEvent.PlayerLoggedInEvent event) {
        HEPacketSynchronize message = new HEPacketSynchronize();
        for (int waterId = 0; waterId < HEConfig.maxDams; ++waterId) {
            message.blocksX[waterId] = this.dams[waterId].getBlockX();
            message.blocksY[waterId] = this.dams[waterId].getBlockY();
            message.blocksZ[waterId] = this.dams[waterId].getBlockZ();
            message.waterLevels[waterId] = this.dams[waterId].getWaterLevel();
            message.modes[waterId] = this.dams[waterId].getMode();
            message.limitsWest[waterId] = this.dams[waterId].limitWest;
            message.limitsDown[waterId] = this.dams[waterId].limitDown;
            message.limitsNorth[waterId] = this.dams[waterId].limitNorth;
            message.limitsEast[waterId] = this.dams[waterId].limitEast;
            message.limitsUp[waterId] = this.dams[waterId].limitUp;
            message.limitsSouth[waterId] = this.dams[waterId].limitSouth;
        }
        message.enabledTiers = HEConfig.enabledTiers;
        HE.network.sendTo((IMessage)message, (EntityPlayerMP)event.player);
        HE.debug("Sent synchronize packet to player " + event.player.getDisplayName());
    }

    public void onConfigRequest(int waterId, HE.DamMode mode, int limitWest, int limitDown, int limitNorth, int limitEast, int limitUp, int limitSouth) {
        HE.debug("Received dam config change request");
        if (waterId < 0 || waterId >= HEConfig.maxDams) {
            return;
        }
        if (this.dams[waterId].onConfigRequest(mode, limitWest, limitDown, limitNorth, limitEast, limitUp, limitSouth)) {
            this.func_76185_a();
        }
    }

    public int getWaterId(int blockX, int blockY, int blockZ) {
        for (int waterId = 0; waterId < HEConfig.maxDams; ++waterId) {
            if (blockX != this.dams[waterId].getBlockX() || blockY != this.dams[waterId].getBlockY() || blockZ != this.dams[waterId].getBlockZ()) continue;
            return waterId;
        }
        return -1;
    }

    public List<String> getControllerCoordinates() {
        ArrayList<String> list = new ArrayList<String>();
        for (HEDam dam : this.dams) {
            if (!dam.isPlaced()) continue;
            list.add(dam.getShortDescription());
        }
        return list;
    }

    public long getEuCapacity(int waterId) {
        return this.dams[waterId].getEuCapacity();
    }

    public long getEuCapacityAt(int waterId, int blockY) {
        return this.dams[waterId].getEuCapacityAt(blockY);
    }

    public void setWaterLevel(int waterId, long euStored) {
        this.dams[waterId].setWaterLevel(euStored);
    }

    public int getRainedOnBlocks(int waterId) {
        return this.dams[waterId].getRainedOnBlocks();
    }

    public String getOwnerName(int waterId) {
        return this.dams[waterId].getOwnerName();
    }
}

