/*
 * Decompiled with CFR 0.152.
 */
package com.gtnewhorizons.gtnhintergalactic.nei;

import codechicken.lib.gui.GuiDraw;
import codechicken.nei.PositionedStack;
import codechicken.nei.recipe.TemplateRecipeHandler;
import com.gtnewhorizons.gtnhintergalactic.gui.IG_UITextures;
import com.gtnewhorizons.gtnhintergalactic.recipe.GasSiphonRecipes;
import com.gtnewhorizons.modularui.api.GlStateManager;
import com.gtnewhorizons.modularui.api.ModularUITextures;
import com.gtnewhorizons.modularui.api.UIInfos;
import com.gtnewhorizons.modularui.api.drawable.IDrawable;
import com.gtnewhorizons.modularui.api.math.Pos2d;
import com.gtnewhorizons.modularui.api.screen.ModularWindow;
import com.gtnewhorizons.modularui.api.widget.Widget;
import com.gtnewhorizons.modularui.common.widget.DrawableWidget;
import gregtech.api.util.GT_Utility;
import java.awt.Rectangle;
import java.util.Map;
import micdoodle8.mods.galacticraft.core.util.GCCoreUtil;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumChatFormatting;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;

public class GasSiphonRecipeHandler
extends TemplateRecipeHandler {
    private static final String SEE_ALL = "ig.nei.elevatorpump.see_all";
    protected final ModularWindow modularWindow = ((ModularWindow.Builder)ModularWindow.builder((int)172, (int)82).setBackground(new IDrawable[]{ModularUITextures.VANILLA_BACKGROUND}).widget(new DrawableWidget().setDrawable((IDrawable)IG_UITextures.PICTURE_ELEVATOR_LOGO).setSize(17, 17).setPos(new Pos2d(147, 52)))).build();
    private static final Pos2d WINDOW_OFFSET = new Pos2d(-3, -8);
    private static final int CATEGORY_TITLE_X = 30;
    private static final int CATEGORY_VALUE_X = 85;
    private static final int PLANET_TYPE_Y = 0;
    private static final int GAS_TYPE_Y = 15;
    private static final int OUT_AMOUNT_Y = 30;
    private static final int TEXT_COLOR = 0x404040;

    public GasSiphonRecipeHandler() {
        UIInfos.initializeWindow((EntityPlayer)Minecraft.func_71410_x().field_71439_g, (ModularWindow)this.modularWindow);
    }

    public int recipiesPerPage() {
        return 3;
    }

    public String getGuiTexture() {
        return "galaxyspace:textures/gui/guiBase.png";
    }

    public void loadTransferRects() {
        int stringLength = GuiDraw.getStringWidth((String)I18n.func_135052_a((String)SEE_ALL, (Object[])new Object[0]));
        this.transferRects.add(new TemplateRecipeHandler.RecipeTransferRect(new Rectangle(this.getGuiWidth() - stringLength - 3, 26, stringLength, 9), this.getOutputId(), new Object[0]));
    }

    public int getGuiWidth() {
        return 166;
    }

    public void loadCraftingRecipes(String outputId, Object ... results) {
        if (outputId.equals(this.getOutputId())) {
            for (Map.Entry<String, Map<Integer, FluidStack>> entry : GasSiphonRecipes.RECIPES.entrySet()) {
                for (Map.Entry<Integer, FluidStack> innerEntry : entry.getValue().entrySet()) {
                    this.arecipes.add(new CachedSiphonRecipe(entry.getKey(), innerEntry.getKey(), innerEntry.getValue().getFluid(), innerEntry.getValue().amount));
                }
            }
        } else {
            super.loadCraftingRecipes(outputId, results);
        }
    }

    public void drawBackground(int recipe) {
        for (IDrawable background : this.modularWindow.getBackground()) {
            GlStateManager.pushMatrix();
            GlStateManager.translate((float)GasSiphonRecipeHandler.WINDOW_OFFSET.x, (float)GasSiphonRecipeHandler.WINDOW_OFFSET.y, (float)0.0f);
            GlStateManager.color((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            background.draw(Pos2d.ZERO, this.modularWindow.getSize(), 0.0f);
            GlStateManager.popMatrix();
        }
        for (Widget widget : this.modularWindow.getChildren()) {
            GlStateManager.pushMatrix();
            GlStateManager.translate((float)widget.getPos().x, (float)widget.getPos().y, (float)0.0f);
            GlStateManager.color((float)1.0f, (float)1.0f, (float)1.0f, (float)this.modularWindow.getAlpha());
            GlStateManager.enableBlend();
            widget.drawBackground(0.0f);
            widget.draw(0.0f);
            GlStateManager.popMatrix();
        }
    }

    public void loadCraftingRecipes(ItemStack result) {
        FluidStack displayFluid;
        Fluid fluid = null;
        FluidStack containerFluid = GT_Utility.getFluidForFilledItem((ItemStack)result, (boolean)true);
        if (containerFluid != null) {
            fluid = containerFluid.getFluid();
        }
        if (fluid == null && (displayFluid = GT_Utility.getFluidFromDisplayStack((ItemStack)result)) != null) {
            fluid = displayFluid.getFluid();
        }
        if (fluid == null) {
            return;
        }
        for (Map.Entry<String, Map<Integer, FluidStack>> entry : GasSiphonRecipes.RECIPES.entrySet()) {
            for (Map.Entry<Integer, FluidStack> innerEntry : entry.getValue().entrySet()) {
                if (!innerEntry.getValue().isFluidEqual(new FluidStack(fluid, 0))) continue;
                this.arecipes.add(new CachedSiphonRecipe(entry.getKey(), innerEntry.getKey(), fluid, innerEntry.getValue().amount));
            }
        }
    }

    public void drawExtras(int recipeIndex) {
        GuiDraw.drawStringC((String)(I18n.func_135052_a((String)"ig.nei.siphon.planet", (Object[])new Object[0]) + ":"), (int)30, (int)0, (int)0x404040, (boolean)false);
        GuiDraw.drawStringC((String)(I18n.func_135052_a((String)"ig.nei.siphon.depth", (Object[])new Object[0]) + ":"), (int)30, (int)15, (int)0x404040, (boolean)false);
        GuiDraw.drawStringC((String)(I18n.func_135052_a((String)"ig.nei.elevatorpump.amount", (Object[])new Object[0]) + ":"), (int)30, (int)30, (int)0x404040, (boolean)false);
        CachedSiphonRecipe recipe = (CachedSiphonRecipe)((Object)this.arecipes.get(recipeIndex));
        GuiDraw.drawStringC((String)GCCoreUtil.translate((String)recipe.planet), (int)85, (int)0, (int)0x404040, (boolean)false);
        GuiDraw.drawStringC((String)Integer.toString(recipe.depth), (int)85, (int)15, (int)0x404040, (boolean)false);
        GuiDraw.drawStringC((String)GT_Utility.formatNumbers((long)recipe.amount), (int)85, (int)30, (int)0x404040, (boolean)false);
        GuiDraw.drawStringR((String)(EnumChatFormatting.BOLD + I18n.func_135052_a((String)SEE_ALL, (Object[])new Object[0])), (int)(this.getGuiWidth() - 3), (int)30, (int)0x404040, (boolean)false);
    }

    public String getOutputId() {
        return "galacticraft.siphon";
    }

    public String getRecipeName() {
        return I18n.func_135052_a((String)"ig.nei.siphon.name", (Object[])new Object[0]);
    }

    private class CachedSiphonRecipe
    extends TemplateRecipeHandler.CachedRecipe {
        private final PositionedStack targetFluidDisplay;
        private final String planet;
        private final int depth;
        private final int amount;

        private CachedSiphonRecipe(String planet, int depth, Fluid output, int outputAmount) {
            super((TemplateRecipeHandler)GasSiphonRecipeHandler.this);
            this.targetFluidDisplay = new PositionedStack((Object)GT_Utility.getFluidDisplayStack((Fluid)output), GasSiphonRecipeHandler.this.getGuiWidth() - 19, 0);
            this.planet = planet;
            this.depth = depth;
            this.amount = outputAmount;
        }

        public PositionedStack getResult() {
            return this.targetFluidDisplay;
        }
    }
}

