/*
 * Decompiled with CFR 0.152.
 */
package pers.gwyog.gtneioreplugin.util;

import com.google.common.base.Strings;
import java.util.Arrays;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;

public class StringPaddingHack {
    private static final int SPACE_WIDTH = 4;
    private static final int BOLD_SPACE_WIDTH = 5;

    public static String[] stringsToSpacedColumns(String[] strings, int numColumns, int minColumnSpacing) {
        if (numColumns < 1) {
            throw new IllegalArgumentException(String.format("Argument numColumns must be 1 or higher, got value %d", numColumns));
        }
        if (numColumns > 1) {
            int i;
            int sliceSize = strings.length / numColumns;
            int remainder = strings.length % numColumns;
            String[][] columns = new String[numColumns][];
            int totalExtra = 0;
            for (i = 0; i < numColumns; ++i) {
                int extra = 0;
                if (remainder > 0) {
                    --remainder;
                    extra = 1;
                }
                columns[i] = Arrays.copyOfRange(strings, sliceSize * i + totalExtra, sliceSize * (i + 1) + totalExtra + extra);
                totalExtra += extra;
            }
            for (i = 0; i < numColumns - 1; ++i) {
                columns[i] = StringPaddingHack.padStrings(columns[i], minColumnSpacing);
            }
            strings = columns[0];
            for (i = 0; i < sliceSize; ++i) {
                for (int j = 1; j < numColumns; ++j) {
                    int n = i;
                    strings[n] = strings[n] + columns[j][i];
                }
            }
        }
        return strings;
    }

    public static String[] padStrings(String[] strings, int minExtraSpaces) {
        int i;
        int[] widths = StringPaddingHack.getStringWidths(strings);
        int maxUnPaddedStrLength = 0;
        int numSpacesAddedToLongestString = 0;
        int maxPaddedStrLength = 0;
        for (i = 0; i < strings.length; ++i) {
            int mod = widths[i] % 4;
            int numBoldSpacesToAdd = (4 - mod) % 4;
            if (widths[i] > maxUnPaddedStrLength) {
                numSpacesAddedToLongestString = numBoldSpacesToAdd;
                maxUnPaddedStrLength = widths[i];
            }
            int n = i;
            strings[n] = strings[n] + "\u00a7l" + Strings.repeat((String)" ", (int)numBoldSpacesToAdd) + "\u00a7r";
            int n2 = i;
            widths[n2] = widths[n2] + numBoldSpacesToAdd * 5;
            if (widths[i] <= maxPaddedStrLength) continue;
            maxPaddedStrLength = widths[i];
        }
        if (numSpacesAddedToLongestString < minExtraSpaces) {
            maxPaddedStrLength += (minExtraSpaces - numSpacesAddedToLongestString) * 4;
        }
        i = 0;
        while (i < strings.length) {
            int numSpacesToAdd = (maxPaddedStrLength - widths[i]) / 4;
            int n = i;
            strings[n] = strings[n] + Strings.repeat((String)" ", (int)numSpacesToAdd);
            int n3 = i++;
            widths[n3] = widths[n3] + numSpacesToAdd * 4;
        }
        return strings;
    }

    protected static int[] getStringWidths(String[] strList) {
        FontRenderer font = Minecraft.func_71410_x().field_71466_p;
        int[] widths = new int[strList.length];
        for (int i = 0; i < strList.length; ++i) {
            widths[i] = font.func_78256_a(strList[i]);
        }
        return widths;
    }
}

