/*
 * Decompiled with CFR 0.152.
 */
package gregtech.loaders.oreprocessing;

import gregtech.api.enums.Dyes;
import gregtech.api.enums.GT_Values;
import gregtech.api.enums.Materials;
import gregtech.api.enums.OrePrefixes;
import gregtech.api.interfaces.IOreRecipeRegistrator;
import gregtech.api.util.GT_ModHandler;
import gregtech.api.util.GT_OreDictUnificator;
import gregtech.api.util.GT_Recipe;
import gregtech.api.util.GT_RecipeConstants;
import gregtech.api.util.GT_Utility;
import java.util.Locale;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidRegistry;

public class ProcessingDye
implements IOreRecipeRegistrator {
    public ProcessingDye() {
        OrePrefixes.dye.add(this);
    }

    @Override
    public void registerOre(OrePrefixes prefix, Materials material, String oreDictName, String modName, ItemStack stack) {
        Dyes aDye = Dyes.get(oreDictName);
        if (aDye.mIndex >= 0 && aDye.mIndex < 16 && GT_Utility.getContainerItem(stack, true) == null) {
            this.registerAlloySmelter(stack, aDye);
            this.registerMixer(stack, aDye);
            this.registerChemicalReactor(stack, aDye);
        }
    }

    public void registerMixer(ItemStack stack, Dyes dye) {
        String fluidName = "dye.watermixed." + dye.name().toLowerCase(Locale.ENGLISH);
        GT_Values.RA.stdBuilder().itemInputs(GT_Utility.copyAmount(1L, stack), GT_Utility.getIntegratedCircuit(1)).noItemOutputs().fluidInputs(Materials.Water.getFluid(216L)).fluidOutputs(FluidRegistry.getFluidStack((String)fluidName, (int)192)).duration(16).eut(4).addTo(GT_Recipe.GT_Recipe_Map.sMixerRecipes);
        GT_Values.RA.stdBuilder().itemInputs(GT_Utility.copyAmount(1L, stack), GT_Utility.getIntegratedCircuit(1)).noItemOutputs().fluidInputs(GT_ModHandler.getDistilledWater(288L)).fluidOutputs(FluidRegistry.getFluidStack((String)fluidName, (int)216)).duration(16).eut(4).addTo(GT_Recipe.GT_Recipe_Map.sMixerRecipes);
    }

    public void registerAlloySmelter(ItemStack stack, Dyes dye) {
        GT_ModHandler.addAlloySmelterRecipe(GT_OreDictUnificator.get(OrePrefixes.dust, Materials.Glass, 8L), GT_Utility.copyAmount(1L, stack), new ItemStack((Block)Blocks.field_150399_cn, 8, 15 - dye.mIndex), 200, 8, false);
        GT_ModHandler.addAlloySmelterRecipe(new ItemStack(Blocks.field_150359_w, 8, Short.MAX_VALUE), GT_Utility.copyAmount(1L, stack), new ItemStack((Block)Blocks.field_150399_cn, 8, 15 - dye.mIndex), 200, 8, false);
    }

    public void registerChemicalReactor(ItemStack stack, Dyes dye) {
        String fluidName = "dye.chemical." + dye.name().toLowerCase(Locale.ENGLISH);
        GT_Values.RA.stdBuilder().itemInputs(GT_Utility.copyAmount(1L, stack), GT_OreDictUnificator.get(OrePrefixes.dust, Materials.Salt, 2L)).noItemOutputs().fluidInputs(Materials.SulfuricAcid.getFluid(432L)).fluidOutputs(FluidRegistry.getFluidStack((String)fluidName, (int)288)).duration(600).eut(48).addTo(GT_RecipeConstants.UniversalChemical);
    }
}

