/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.tileentities.machines;

import appeng.api.AEApi;
import appeng.api.implementations.ICraftingPatternItem;
import appeng.api.implementations.IPowerChannelState;
import appeng.api.networking.GridFlags;
import appeng.api.networking.IGridNode;
import appeng.api.networking.crafting.ICraftingMedium;
import appeng.api.networking.crafting.ICraftingPatternDetails;
import appeng.api.networking.crafting.ICraftingProvider;
import appeng.api.networking.crafting.ICraftingProviderHelper;
import appeng.api.networking.energy.IEnergySource;
import appeng.api.networking.events.MENetworkCraftingPatternChange;
import appeng.api.networking.events.MENetworkEvent;
import appeng.api.networking.security.BaseActionSource;
import appeng.api.networking.security.IActionHost;
import appeng.api.networking.security.MachineSource;
import appeng.api.storage.IMEInventory;
import appeng.api.storage.IMEMonitor;
import appeng.api.storage.data.IAEFluidStack;
import appeng.api.storage.data.IAEItemStack;
import appeng.api.storage.data.IAEStack;
import appeng.api.util.AECableType;
import appeng.api.util.DimensionalCoord;
import appeng.items.misc.ItemEncodedPattern;
import appeng.me.GridAccessException;
import appeng.me.helpers.AENetworkProxy;
import appeng.me.helpers.IGridProxyable;
import appeng.util.Platform;
import appeng.util.ReadableNumberConverter;
import com.glodblock.github.common.item.ItemFluidPacket;
import com.google.common.collect.ImmutableList;
import com.gtnewhorizons.modularui.api.drawable.IDrawable;
import com.gtnewhorizons.modularui.api.forge.IItemHandlerModifiable;
import com.gtnewhorizons.modularui.api.screen.ModularWindow;
import com.gtnewhorizons.modularui.api.screen.UIBuildContext;
import com.gtnewhorizons.modularui.common.internal.wrapper.BaseSlot;
import com.gtnewhorizons.modularui.common.widget.ButtonWidget;
import com.gtnewhorizons.modularui.common.widget.SlotGroup;
import com.gtnewhorizons.modularui.common.widget.SlotWidget;
import gregtech.GT_Mod;
import gregtech.api.GregTech_API;
import gregtech.api.enums.ItemList;
import gregtech.api.enums.Textures;
import gregtech.api.gui.modularui.GT_UITextures;
import gregtech.api.interfaces.IConfigurationCircuitSupport;
import gregtech.api.interfaces.ITexture;
import gregtech.api.interfaces.modularui.IAddGregtechLogo;
import gregtech.api.interfaces.modularui.IAddUIWidgets;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.metatileentity.MetaTileEntity;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_Hatch_InputBus;
import gregtech.api.render.TextureFactory;
import gregtech.api.util.GT_Utility;
import gregtech.common.tileentities.machines.IDualInputHatch;
import gregtech.common.tileentities.machines.IDualInputInventory;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import mcp.mobius.waila.api.IWailaConfigHandler;
import mcp.mobius.waila.api.IWailaDataAccessor;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.inventory.Slot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.IChatComponent;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.FluidStack;
import org.apache.commons.lang3.ArrayUtils;
import org.jetbrains.annotations.NotNull;

public class GT_MetaTileEntity_Hatch_CraftingInput_ME
extends GT_MetaTileEntity_Hatch_InputBus
implements IConfigurationCircuitSupport,
IAddGregtechLogo,
IAddUIWidgets,
IPowerChannelState,
ICraftingProvider,
IGridProxyable,
IDualInputHatch {
    private static final int MAX_PATTERN_COUNT = 32;
    private static final int MAX_INV_COUNT = 34;
    private static final int SLOT_MANUAL = 33;
    private static final int SLOT_CIRCUIT = 32;
    private BaseActionSource requestSource = null;
    @Nullable
    private AENetworkProxy gridProxy = null;
    private PatternSlot[] internalInventory = new PatternSlot[32];
    private Map<ICraftingPatternDetails, PatternSlot> patternDetailsPatternSlotMap = new HashMap<ICraftingPatternDetails, PatternSlot>(32);
    private boolean needPatternSync = true;
    private boolean justHadNewItems = false;
    private boolean supportFluids;

    public GT_MetaTileEntity_Hatch_CraftingInput_ME(int aID, String aName, String aNameRegional, boolean supportFluids) {
        super(aID, aName, aNameRegional, 6, 34, new String[]{"Advanced item input for Multiblocks", "Processes patterns directly from ME", supportFluids ? "It supports patterns including fluids" : "It does not support patterns including fluids"});
        this.disableSort = true;
        this.supportFluids = supportFluids;
    }

    public GT_MetaTileEntity_Hatch_CraftingInput_ME(String aName, int aTier, String[] aDescription, ITexture[][][] aTextures, boolean supportFluids) {
        super(aName, aTier, 34, aDescription, aTextures);
        this.supportFluids = supportFluids;
        this.disableSort = true;
    }

    @Override
    public MetaTileEntity newMetaEntity(IGregTechTileEntity aTileEntity) {
        return new GT_MetaTileEntity_Hatch_CraftingInput_ME(this.mName, (int)this.mTier, this.mDescriptionArray, this.mTextures, this.supportFluids);
    }

    @Override
    public ITexture[] getTexturesActive(ITexture aBaseTexture) {
        return this.getTexturesInactive(aBaseTexture);
    }

    @Override
    public ITexture[] getTexturesInactive(ITexture aBaseTexture) {
        return new ITexture[]{aBaseTexture, TextureFactory.of(this.supportFluids ? Textures.BlockIcons.OVERLAY_ME_CRAFTING_INPUT_BUFFER : Textures.BlockIcons.OVERLAY_ME_CRAFTING_INPUT_BUS)};
    }

    @Override
    public void onPostTick(IGregTechTileEntity aBaseMetaTileEntity, long aTimer) {
        super.onPostTick(aBaseMetaTileEntity, aTimer);
        if (this.needPatternSync && aTimer % 10L == 0L && this.getBaseMetaTileEntity().isServerSide()) {
            this.needPatternSync = !this.postMEPatternChange();
        }
    }

    @Override
    public void onFirstTick(IGregTechTileEntity aBaseMetaTileEntity) {
        super.onFirstTick(aBaseMetaTileEntity);
        this.getProxy().onReady();
    }

    public IGridNode getGridNode(ForgeDirection dir) {
        return this.getProxy().getNode();
    }

    @Override
    public AECableType getCableConnectionType(ForgeDirection forgeDirection) {
        return this.isOutputFacing(forgeDirection) ? AECableType.SMART : AECableType.NONE;
    }

    public void securityBreak() {
    }

    @Override
    public AENetworkProxy getProxy() {
        if (this.gridProxy == null) {
            this.gridProxy = new AENetworkProxy((IGridProxyable)this, "proxy", ItemList.Hatch_CraftingInput_Bus_ME.get(1L, new Object[0]), true);
            this.gridProxy.setFlags(new GridFlags[]{GridFlags.REQUIRE_CHANNEL});
            if (this.getBaseMetaTileEntity().getWorld() != null) {
                this.gridProxy.setOwner(this.getBaseMetaTileEntity().getWorld().func_72924_a(this.getBaseMetaTileEntity().getOwnerName()));
            }
        }
        return this.gridProxy;
    }

    public DimensionalCoord getLocation() {
        return new DimensionalCoord(this.getBaseMetaTileEntity().getWorld(), this.getBaseMetaTileEntity().getXCoord(), (int)this.getBaseMetaTileEntity().getYCoord(), this.getBaseMetaTileEntity().getZCoord());
    }

    @Override
    public void gridChanged() {
        this.needPatternSync = true;
    }

    public boolean isPowered() {
        return this.getProxy() != null && this.getProxy().isPowered();
    }

    public boolean isActive() {
        return this.getProxy() != null && this.getProxy().isActive();
    }

    @Override
    public void saveNBTData(NBTTagCompound aNBT) {
        super.saveNBTData(aNBT);
        NBTTagList internalInventoryNBT = new NBTTagList();
        for (int i = 0; i < this.internalInventory.length; ++i) {
            if (this.internalInventory[i] == null) continue;
            NBTTagCompound internalInventorySlotNBT = new NBTTagCompound();
            internalInventorySlotNBT.func_74768_a("patternSlot", i);
            internalInventorySlotNBT.func_74782_a("patternSlotNBT", (NBTBase)this.internalInventory[i].writeToNBT(new NBTTagCompound()));
            internalInventoryNBT.func_74742_a((NBTBase)internalInventorySlotNBT);
        }
        aNBT.func_74782_a("internalInventory", (NBTBase)internalInventoryNBT);
        if (GregTech_API.mAE2) {
            this.getProxy().writeToNBT(aNBT);
        }
    }

    @Override
    public void loadNBTData(NBTTagCompound aNBT) {
        super.loadNBTData(aNBT);
        NBTTagList internalInventoryNBT = aNBT.func_150295_c("internalInventory", 10);
        for (int i = 0; i < internalInventoryNBT.func_74745_c(); ++i) {
            NBTTagCompound internalInventorySlotNBT = internalInventoryNBT.func_150305_b(i);
            int patternSlot = internalInventorySlotNBT.func_74762_e("patternSlot");
            NBTTagCompound patternSlotNBT = internalInventorySlotNBT.func_74775_l("patternSlotNBT");
            ItemStack pattern = ItemStack.func_77949_a((NBTTagCompound)patternSlotNBT.func_74775_l("pattern"));
            if (pattern != null) {
                this.internalInventory[patternSlot] = new PatternSlot(pattern, patternSlotNBT, this.getBaseMetaTileEntity().getWorld(), this::getSharedItems);
                continue;
            }
            GT_Mod.GT_FML_LOGGER.warn("An error occurred while loading contents of ME Crafting Input Bus. This pattern has been voided: " + patternSlotNBT);
        }
        this.patternDetailsPatternSlotMap.clear();
        for (PatternSlot patternSlot : this.internalInventory) {
            if (patternSlot == null) continue;
            this.patternDetailsPatternSlotMap.put(patternSlot.getPatternDetails(), patternSlot);
        }
        if (GregTech_API.mAE2) {
            this.getProxy().readFromNBT(aNBT);
        }
    }

    @Override
    public boolean isGivingInformation() {
        return true;
    }

    private String describePattern(ICraftingPatternDetails patternDetails) {
        return Arrays.stream(patternDetails.getCondensedOutputs()).map(aeItemStack -> aeItemStack.getItem().func_77653_i(aeItemStack.getItemStack())).collect(Collectors.joining(", "));
    }

    @Override
    public String[] getInfoData() {
        if (GregTech_API.mAE2) {
            ArrayList<String> ret = new ArrayList<String>();
            ret.add("The bus is " + (this.getProxy() != null && this.getProxy().isActive() ? EnumChatFormatting.GREEN + "online" : EnumChatFormatting.RED + "offline" + this.getAEDiagnostics()) + EnumChatFormatting.RESET);
            ret.add("Internal Inventory: ");
            int i = 0;
            for (PatternSlot slot : this.internalInventory) {
                if (slot == null) continue;
                ReadableNumberConverter nc = ReadableNumberConverter.INSTANCE;
                ret.add("Slot " + ++i + " " + EnumChatFormatting.BLUE + this.describePattern(slot.patternDetails) + EnumChatFormatting.RESET);
                for (ItemStack item : slot.itemInventory) {
                    if (item == null || item.field_77994_a == 0) continue;
                    ret.add(item.func_77973_b().func_77653_i(item) + ": " + EnumChatFormatting.GOLD + nc.toWideReadableForm((long)item.field_77994_a) + EnumChatFormatting.RESET);
                }
                for (FluidStack fluid : slot.fluidInventory) {
                    if (fluid == null || fluid.amount == 0) continue;
                    ret.add(fluid.getLocalizedName() + ": " + EnumChatFormatting.AQUA + nc.toWideReadableForm((long)fluid.amount) + EnumChatFormatting.RESET);
                }
            }
            return ret.toArray(new String[0]);
        }
        return new String[0];
    }

    @Override
    public boolean allowPullStack(IGregTechTileEntity aBaseMetaTileEntity, int aIndex, ForgeDirection side, ItemStack aStack) {
        return false;
    }

    @Override
    public boolean allowPutStack(IGregTechTileEntity aBaseMetaTileEntity, int aIndex, ForgeDirection side, ItemStack aStack) {
        return false;
    }

    @Override
    public int getCircuitSlot() {
        return 32;
    }

    @Override
    public int getCircuitSlotX() {
        return 152;
    }

    @Override
    public int getCircuitSlotY() {
        return 64;
    }

    @Override
    public boolean isValidSlot(int aIndex) {
        return true;
    }

    @Override
    public void addUIWidgets(// Could not load outer class - annotation placement on inner may be incorrect
     @NotNull ModularWindow.Builder builder, UIBuildContext buildContext) {
        ((ModularWindow.Builder)((ModularWindow.Builder)builder.widget(SlotGroup.ofItemHandler((IItemHandlerModifiable)this.inventoryHandler, (int)8).startFromSlot(0).endAtSlot(31).phantom(false).background(new IDrawable[]{this.getGUITextureSet().getItemSlot(), GT_UITextures.OVERLAY_SLOT_PATTERN_ME}).widgetCreator(slot -> new SlotWidget((BaseSlot)slot, (BaseSlot)slot){
            final /* synthetic */ BaseSlot val$slot;
            {
                this.val$slot = baseSlot;
                super(slot);
            }

            protected ItemStack getItemStackForRendering(Slot slotIn) {
                Item item;
                ItemStack stack = this.val$slot.func_75211_c();
                if (stack == null || !((item = stack.func_77973_b()) instanceof ItemEncodedPattern)) {
                    return stack;
                }
                ItemEncodedPattern patternItem = (ItemEncodedPattern)item;
                ItemStack output = patternItem.getOutput(stack);
                return output != null ? output : stack;
            }
        }.setFilter(itemStack -> itemStack.func_77973_b() instanceof ICraftingPatternItem).setChangeListener(() -> this.onPatternChange((BaseSlot)slot))).build().setPos(7, 9))).widget(new SlotWidget((IItemHandlerModifiable)this.inventoryHandler, 33).setShiftClickPriority(11).setBackground(new IDrawable[]{this.getGUITextureSet().getItemSlot()}).setPos(151, 45))).widget(new ButtonWidget().setOnClick((clickData, widget) -> {
            if (clickData.mouseButton == 0) {
                this.refundAll();
            }
        }).setPlayClickSound(true).setBackground(new IDrawable[]{GT_UITextures.BUTTON_STANDARD, GT_UITextures.OVERLAY_BUTTON_EXPORT}).addTooltips((List)ImmutableList.of((Object)"Return all internally stored items back to AE")).setSize(16, 16).setPos(152, 28));
    }

    @Override
    public void updateSlots() {
        if (this.mInventory[33] != null && this.mInventory[33].field_77994_a <= 0) {
            this.mInventory[33] = null;
        }
    }

    private BaseActionSource getRequest() {
        if (this.requestSource == null) {
            this.requestSource = new MachineSource((IActionHost)this.getBaseMetaTileEntity());
        }
        return this.requestSource;
    }

    private void onPatternChange(BaseSlot slot) {
        PatternSlot patternSlot;
        ItemStack pattern;
        if (!this.getBaseMetaTileEntity().isServerSide()) {
            return;
        }
        World world = this.getBaseMetaTileEntity().getWorld();
        PatternSlot originalPattern = this.internalInventory[slot.getSlotIndex()];
        if (originalPattern != null) {
            if (originalPattern.hasChanged(slot.func_75211_c(), world)) {
                try {
                    originalPattern.refund(this.getProxy(), this.getRequest());
                }
                catch (GridAccessException gridAccessException) {
                    // empty catch block
                }
                this.internalInventory[slot.getSlotIndex()] = null;
                this.needPatternSync = true;
            } else {
                return;
            }
        }
        if ((pattern = slot.func_75211_c()) == null || !(pattern.func_77973_b() instanceof ICraftingPatternItem)) {
            return;
        }
        this.internalInventory[slot.getSlotIndex()] = patternSlot = new PatternSlot(pattern, world, this::getSharedItems);
        this.patternDetailsPatternSlotMap.put(patternSlot.getPatternDetails(), patternSlot);
        this.needPatternSync = true;
    }

    private ItemStack[] getSharedItems() {
        return new ItemStack[]{this.mInventory[32], this.mInventory[33]};
    }

    @Override
    public void getWailaBody(ItemStack itemStack, List<String> currenttip, IWailaDataAccessor accessor, IWailaConfigHandler config) {
        NBTTagCompound tag = accessor.getNBTData();
        if (tag.func_74764_b("inventory")) {
            NBTTagList inventory = tag.func_150295_c("inventory", 10);
            for (int i = 0; i < inventory.func_74745_c(); ++i) {
                NBTTagCompound item = inventory.func_150305_b(i);
                String name = item.func_74779_i("name");
                int amount = item.func_74762_e("amount");
                currenttip.add(name + ": " + EnumChatFormatting.GOLD + ReadableNumberConverter.INSTANCE.toWideReadableForm((long)amount) + EnumChatFormatting.RESET);
            }
        }
        super.getWailaBody(itemStack, currenttip, accessor, config);
    }

    @Override
    public void getWailaNBTData(EntityPlayerMP player, TileEntity tile, NBTTagCompound tag, World world, int x, int y, int z) {
        NBTTagList inventory = new NBTTagList();
        HashMap<String, Integer> nameToAmount = new HashMap<String, Integer>();
        Iterator<PatternSlot> it = this.inventories();
        while (it.hasNext()) {
            Integer amount;
            String name;
            PatternSlot i = it.next();
            for (ItemStack item : i.itemInventory) {
                if (item == null || item.field_77994_a <= 0) continue;
                name = item.func_82833_r();
                amount = nameToAmount.getOrDefault(name, 0);
                nameToAmount.put(name, amount + item.field_77994_a);
            }
            for (FluidStack fluid : i.fluidInventory) {
                if (fluid == null || fluid.amount <= 0) continue;
                name = fluid.getLocalizedName();
                amount = nameToAmount.getOrDefault(name, 0);
                nameToAmount.put(name, amount + fluid.amount);
            }
        }
        for (Map.Entry entry : nameToAmount.entrySet()) {
            NBTTagCompound item = new NBTTagCompound();
            item.func_74778_a("name", (String)entry.getKey());
            item.func_74768_a("amount", ((Integer)entry.getValue()).intValue());
            inventory.func_74742_a((NBTBase)item);
        }
        tag.func_74782_a("inventory", (NBTBase)inventory);
        super.getWailaNBTData(player, tile, tag, world, x, y, z);
    }

    public void provideCrafting(ICraftingProviderHelper craftingTracker) {
        if (!this.isActive()) {
            return;
        }
        for (PatternSlot slot : this.internalInventory) {
            if (slot == null) continue;
            ICraftingPatternDetails details = slot.getPatternDetails();
            if (details == null) {
                GT_Mod.GT_FML_LOGGER.warn("Found an invalid pattern at " + this.getBaseMetaTileEntity().getCoords() + " in dim " + this.getBaseMetaTileEntity().getWorld().field_73011_w.field_76574_g);
                continue;
            }
            craftingTracker.addCraftingOption((ICraftingMedium)this, details);
        }
    }

    public boolean pushPattern(ICraftingPatternDetails patternDetails, InventoryCrafting table) {
        if (!this.isActive()) {
            return false;
        }
        if (!this.supportFluids) {
            for (int i = 0; i < table.func_70302_i_(); ++i) {
                ItemStack itemStack = table.func_70301_a(i);
                if (itemStack == null || !(itemStack.func_77973_b() instanceof ItemFluidPacket)) continue;
                return false;
            }
        }
        if (!this.patternDetailsPatternSlotMap.get(patternDetails).insertItemsAndFluids(table)) {
            return false;
        }
        this.justHadNewItems = true;
        return true;
    }

    public boolean isBusy() {
        return false;
    }

    public Iterator<PatternSlot> inventories() {
        return Arrays.stream(this.internalInventory).filter(Objects::nonNull).iterator();
    }

    @Override
    public void onBlockDestroyed() {
        this.refundAll();
        super.onBlockDestroyed();
    }

    private void refundAll() {
        for (PatternSlot slot : this.internalInventory) {
            if (slot == null) continue;
            try {
                slot.refund(this.getProxy(), this.getRequest());
            }
            catch (GridAccessException gridAccessException) {
                // empty catch block
            }
        }
    }

    @Override
    public boolean justUpdated() {
        boolean ret = this.justHadNewItems;
        this.justHadNewItems = false;
        return ret;
    }

    @Override
    public void onLeftclick(IGregTechTileEntity aBaseMetaTileEntity, EntityPlayer aPlayer) {
        if (!(aPlayer instanceof EntityPlayerMP)) {
            return;
        }
        ItemStack dataStick = aPlayer.field_71071_by.func_70448_g();
        if (!ItemList.Tool_DataStick.isStackEqual(dataStick, true, true)) {
            return;
        }
        NBTTagCompound tag = new NBTTagCompound();
        tag.func_74778_a("type", "CraftingInputBuffer");
        tag.func_74768_a("x", aBaseMetaTileEntity.getXCoord());
        tag.func_74768_a("y", (int)aBaseMetaTileEntity.getYCoord());
        tag.func_74768_a("z", aBaseMetaTileEntity.getZCoord());
        dataStick.field_77990_d = tag;
        dataStick.func_151001_c("Crafting Input Buffer Link Data Stick (" + aBaseMetaTileEntity.getXCoord() + ", " + aBaseMetaTileEntity.getYCoord() + ", " + aBaseMetaTileEntity.getZCoord() + ")");
        aPlayer.func_145747_a((IChatComponent)new ChatComponentText("Saved Link Data to Data Stick"));
    }

    public ItemStack getCrafterIcon() {
        return this.getMachineCraftingIcon();
    }

    private boolean postMEPatternChange() {
        if (!this.getProxy().isActive()) {
            return false;
        }
        try {
            this.getProxy().getGrid().postEvent((MENetworkEvent)new MENetworkCraftingPatternChange((ICraftingProvider)this, this.getProxy().getNode()));
        }
        catch (GridAccessException ignored) {
            return false;
        }
        return true;
    }

    public static class PatternSlot
    implements IDualInputInventory {
        private final ItemStack pattern;
        private final ICraftingPatternDetails patternDetails;
        private final List<ItemStack> itemInventory;
        private final List<FluidStack> fluidInventory;
        private final SharedItemGetter sharedItemGetter;

        public PatternSlot(ItemStack pattern, World world, SharedItemGetter getter) {
            this.pattern = pattern;
            this.patternDetails = ((ICraftingPatternItem)Objects.requireNonNull(pattern.func_77973_b())).getPatternForItem(pattern, world);
            this.itemInventory = new ArrayList<ItemStack>();
            this.fluidInventory = new ArrayList<FluidStack>();
            this.sharedItemGetter = getter;
        }

        public PatternSlot(ItemStack pattern, NBTTagCompound nbt, World world, SharedItemGetter getter) {
            this.pattern = pattern;
            this.patternDetails = ((ICraftingPatternItem)Objects.requireNonNull(pattern.func_77973_b())).getPatternForItem(pattern, world);
            this.itemInventory = new ArrayList<ItemStack>();
            this.fluidInventory = new ArrayList<FluidStack>();
            this.sharedItemGetter = getter;
            NBTTagList inv = nbt.func_150295_c("inventory", 10);
            for (int i = 0; i < inv.func_74745_c(); ++i) {
                NBTTagCompound tagItemStack = inv.func_150305_b(i);
                ItemStack item = GT_Utility.loadItem(tagItemStack);
                if (item != null) {
                    if (item.field_77994_a <= 0) continue;
                    this.itemInventory.add(item);
                    continue;
                }
                GT_Mod.GT_FML_LOGGER.warn("An error occurred while loading contents of ME Crafting Input Bus. This item has been voided: " + tagItemStack);
            }
            NBTTagList fluidInv = nbt.func_150295_c("fluidInventory", 10);
            for (int i = 0; i < fluidInv.func_74745_c(); ++i) {
                NBTTagCompound tagFluidStack = fluidInv.func_150305_b(i);
                FluidStack fluid = FluidStack.loadFluidStackFromNBT((NBTTagCompound)tagFluidStack);
                if (fluid != null) {
                    if (fluid.amount <= 0) continue;
                    this.fluidInventory.add(fluid);
                    continue;
                }
                GT_Mod.GT_FML_LOGGER.warn("An error occurred while loading contents of ME Crafting Input Bus. This fluid has been voided: " + tagFluidStack);
            }
        }

        public boolean hasChanged(ItemStack newPattern, World world) {
            return newPattern == null || !ItemStack.func_77989_b((ItemStack)this.pattern, (ItemStack)newPattern) && !this.patternDetails.equals(((ICraftingPatternItem)Objects.requireNonNull(this.pattern.func_77973_b())).getPatternForItem(this.pattern, world));
        }

        private boolean isEmpty() {
            if (!this.itemInventory.isEmpty()) {
                return this.itemInventory.get(0) == null || this.itemInventory.get((int)0).field_77994_a <= 0;
            }
            if (!this.fluidInventory.isEmpty()) {
                return this.fluidInventory.get(0) == null || this.fluidInventory.get((int)0).amount <= 0;
            }
            return true;
        }

        @Override
        public ItemStack[] getItemInputs() {
            if (this.isEmpty()) {
                return new ItemStack[0];
            }
            return (ItemStack[])ArrayUtils.addAll((Object[])this.itemInventory.toArray(new ItemStack[0]), (Object[])this.sharedItemGetter.getSharedItem());
        }

        @Override
        public FluidStack[] getFluidInputs() {
            if (this.isEmpty()) {
                return new FluidStack[0];
            }
            return this.fluidInventory.toArray(new FluidStack[0]);
        }

        public ICraftingPatternDetails getPatternDetails() {
            return this.patternDetails;
        }

        public void refund(AENetworkProxy proxy, BaseActionSource src) throws GridAccessException {
            IMEMonitor sg = proxy.getStorage().getItemInventory();
            for (ItemStack itemStack : this.itemInventory) {
                if (itemStack == null || itemStack.field_77994_a == 0) continue;
                IAEItemStack rest = (IAEItemStack)Platform.poweredInsert((IEnergySource)proxy.getEnergy(), (IMEInventory)sg, (IAEStack)AEApi.instance().storage().createItemStack(itemStack), (BaseActionSource)src);
                itemStack.field_77994_a = rest != null && rest.getStackSize() > 0L ? (int)rest.getStackSize() : 0;
            }
            IMEMonitor fsg = proxy.getStorage().getFluidInventory();
            for (FluidStack fluidStack : this.fluidInventory) {
                if (fluidStack == null || fluidStack.amount == 0) continue;
                IAEFluidStack rest = (IAEFluidStack)Platform.poweredInsert((IEnergySource)proxy.getEnergy(), (IMEInventory)fsg, (IAEStack)AEApi.instance().storage().createFluidStack(fluidStack), (BaseActionSource)src);
                fluidStack.amount = rest != null && rest.getStackSize() > 0L ? (int)rest.getStackSize() : 0;
            }
        }

        public boolean insertItemsAndFluids(InventoryCrafting inventoryCrafting) {
            ItemStack itemStack;
            int i;
            int errorIndex = -1;
            for (i = 0; i < inventoryCrafting.func_70302_i_(); ++i) {
                itemStack = inventoryCrafting.func_70301_a(i);
                if (itemStack == null) continue;
                boolean inserted = false;
                if (itemStack.func_77973_b() instanceof ItemFluidPacket) {
                    FluidStack fluidStack = ItemFluidPacket.getFluidStack((ItemStack)itemStack);
                    if (fluidStack == null) continue;
                    for (FluidStack fluid : this.fluidInventory) {
                        if (!fluid.isFluidEqual(fluidStack)) continue;
                        if (Integer.MAX_VALUE - fluidStack.amount < fluid.amount) {
                            errorIndex = i;
                            break;
                        }
                        fluid.amount += fluidStack.amount;
                        inserted = true;
                        break;
                    }
                    if (errorIndex != -1) break;
                    if (inserted) continue;
                    this.fluidInventory.add(fluidStack);
                    continue;
                }
                for (ItemStack item : this.itemInventory) {
                    if (!itemStack.func_77969_a(item)) continue;
                    if (Integer.MAX_VALUE - itemStack.field_77994_a < item.field_77994_a) {
                        errorIndex = i;
                        break;
                    }
                    item.field_77994_a += itemStack.field_77994_a;
                    inserted = true;
                    break;
                }
                if (errorIndex != -1) break;
                if (inserted) continue;
                this.itemInventory.add(itemStack);
            }
            if (errorIndex != -1) {
                block3: for (i = 0; i < errorIndex; ++i) {
                    itemStack = inventoryCrafting.func_70301_a(i);
                    if (itemStack == null) continue;
                    if (itemStack.func_77973_b() instanceof ItemFluidPacket) {
                        FluidStack fluidStack = ItemFluidPacket.getFluidStack((ItemStack)itemStack);
                        if (fluidStack == null) continue;
                        for (FluidStack fluid : this.fluidInventory) {
                            if (!fluid.isFluidEqual(fluidStack)) continue;
                            fluid.amount -= fluidStack.amount;
                            continue block3;
                        }
                        continue;
                    }
                    for (ItemStack item : this.itemInventory) {
                        if (!item.func_77969_a(itemStack)) continue;
                        item.field_77994_a -= itemStack.field_77994_a;
                        continue block3;
                    }
                }
                return false;
            }
            return true;
        }

        public NBTTagCompound writeToNBT(NBTTagCompound nbt) {
            nbt.func_74782_a("pattern", (NBTBase)this.pattern.func_77955_b(new NBTTagCompound()));
            NBTTagList itemInventoryNbt = new NBTTagList();
            for (ItemStack itemStack : this.itemInventory) {
                itemInventoryNbt.func_74742_a((NBTBase)GT_Utility.saveItem(itemStack));
            }
            nbt.func_74782_a("inventory", (NBTBase)itemInventoryNbt);
            NBTTagList fluidInventoryNbt = new NBTTagList();
            for (FluidStack fluidStack : this.fluidInventory) {
                fluidInventoryNbt.func_74742_a((NBTBase)fluidStack.writeToNBT(new NBTTagCompound()));
            }
            nbt.func_74782_a("fluidInventory", (NBTBase)fluidInventoryNbt);
            return nbt;
        }

        public static interface SharedItemGetter {
            public ItemStack[] getSharedItem();
        }
    }
}

