/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.render.items;

import gregtech.api.enums.ItemList;
import gregtech.api.enums.Materials;
import gregtech.api.interfaces.IGT_ItemWithMaterialRenderer;
import gregtech.api.objects.ItemData;
import gregtech.api.util.GT_OreDictUnificator;
import gregtech.api.util.GT_Utility;
import gregtech.common.render.items.GT_DataStick_Renderer;
import gregtech.common.render.items.GT_GeneratedItem_Renderer;
import gregtech.common.render.items.GT_GeneratedMaterial_Renderer;
import net.minecraft.client.renderer.entity.RenderItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.client.IItemRenderer;
import net.minecraftforge.client.MinecraftForgeClient;
import org.lwjgl.opengl.GL11;

public class GT_MetaGenerated_Item_Renderer
implements IItemRenderer {
    private final IItemRenderer mItemRenderer = new GT_GeneratedItem_Renderer();
    private final IItemRenderer mMaterialRenderer = new GT_GeneratedMaterial_Renderer();
    private final IItemRenderer mDataStickRenderer = new GT_DataStick_Renderer();

    public <T extends Item> void registerItem(T item) {
        MinecraftForgeClient.registerItemRenderer(item, (IItemRenderer)this);
    }

    public boolean handleRenderType(ItemStack aStack, IItemRenderer.ItemRenderType aType) {
        if (GT_Utility.isStackInvalid(aStack) || aStack.func_77960_j() < 0 || !(aStack.func_77973_b() instanceof IGT_ItemWithMaterialRenderer) || !((IGT_ItemWithMaterialRenderer)aStack.func_77973_b()).shouldUseCustomRenderer(aStack.func_77960_j())) {
            return false;
        }
        return this.getRendererForItemStack(aStack).handleRenderType(aStack, aType);
    }

    public boolean shouldUseRenderHelper(IItemRenderer.ItemRenderType aType, ItemStack aStack, IItemRenderer.ItemRendererHelper aHelper) {
        if (GT_Utility.isStackInvalid(aStack)) {
            return false;
        }
        return this.getRendererForItemStack(aStack).shouldUseRenderHelper(aType, aStack, aHelper);
    }

    public void renderItem(IItemRenderer.ItemRenderType type, ItemStack aStack, Object ... data) {
        if (type == IItemRenderer.ItemRenderType.ENTITY) {
            if (RenderItem.field_82407_g) {
                GL11.glScalef((float)0.85f, (float)0.85f, (float)0.85f);
                GL11.glRotatef((float)-90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                GL11.glTranslated((double)-0.5, (double)-0.42, (double)0.0);
            } else {
                GL11.glTranslated((double)-0.5, (double)-0.42, (double)0.0);
            }
        }
        IItemRenderer itemRenderer = this.getRendererForItemStack(aStack);
        itemRenderer.renderItem(type, aStack, data);
    }

    private IItemRenderer getRendererForItemStack(ItemStack aStack) {
        short aMetaData = (short)aStack.func_77960_j();
        IGT_ItemWithMaterialRenderer aItem = (IGT_ItemWithMaterialRenderer)aStack.func_77973_b();
        if (aItem != null && aItem.allowMaterialRenderer(aMetaData)) {
            ItemData itemData;
            GT_GeneratedMaterial_Renderer aMaterialRenderer = aItem.getMaterialRenderer(aMetaData);
            if (aMaterialRenderer == null && (itemData = GT_OreDictUnificator.getAssociation(aStack)) != null) {
                Materials material = itemData.mMaterial.mMaterial;
                if (material.renderer != null) {
                    aMaterialRenderer = material.renderer;
                }
            }
            return aMaterialRenderer != null ? aMaterialRenderer : this.mMaterialRenderer;
        }
        if (aStack.func_77973_b() == ItemList.Tool_DataStick.getItem() && aStack.func_77942_o() && aStack.func_77978_p().func_74764_b("output")) {
            return this.mDataStickRenderer;
        }
        return this.mItemRenderer;
    }
}

