/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.render;

import gregtech.api.interfaces.IBlockContainer;
import gregtech.api.interfaces.ITexture;
import gregtech.api.util.GT_RenderingWorld;
import gregtech.api.util.LightingHelper;
import gregtech.common.render.GT_TextureBase;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.common.util.ForgeDirection;

class GT_CopiedCTMBlockTexture
extends GT_TextureBase
implements ITexture,
IBlockContainer {
    private final Block mBlock;
    private final byte mSide;
    private final byte mMeta;

    GT_CopiedCTMBlockTexture(Block aBlock, int ordinalSide, int aMeta, short[] aRGBa, boolean allowAlpha) {
        if (aRGBa.length != 4) {
            throw new IllegalArgumentException("RGBa doesn't have 4 Values @ GT_CopiedCTMBlockTexture");
        }
        this.mBlock = aBlock;
        this.mSide = (byte)ordinalSide;
        this.mMeta = (byte)aMeta;
    }

    @Override
    public boolean isOldTexture() {
        return false;
    }

    private IIcon getIcon(int ordinalSide, int aX, int aY, int aZ, RenderBlocks aRenderer) {
        int tSide = this.mSide == 6 ? ordinalSide : (int)this.mSide;
        return this.mBlock.func_149673_e((IBlockAccess)this.getBlockAccess(aRenderer), aX, aY, aZ, tSide);
    }

    private GT_RenderingWorld getBlockAccess(RenderBlocks aRenderer) {
        return GT_RenderingWorld.getInstance(aRenderer.field_147845_a);
    }

    @Override
    public void renderXPos(RenderBlocks aRenderer, Block aBlock, int aX, int aY, int aZ) {
        IIcon aIcon = this.getIcon(ForgeDirection.EAST.ordinal(), aX, aY, aZ, aRenderer);
        aRenderer.field_152631_f = true;
        this.startDrawingQuads(aRenderer, 1.0f, 0.0f, 0.0f);
        new LightingHelper(aRenderer).setupLightingXPos(aBlock, aX, aY, aZ).setupColor(ForgeDirection.EAST, this.mBlock.func_149720_d((IBlockAccess)this.getBlockAccess(aRenderer), aX, aY, aZ));
        aRenderer.func_147764_f(aBlock, (double)aX, (double)aY, (double)aZ, aIcon);
        this.draw(aRenderer);
        aRenderer.field_152631_f = false;
    }

    @Override
    public void renderXNeg(RenderBlocks aRenderer, Block aBlock, int aX, int aY, int aZ) {
        this.startDrawingQuads(aRenderer, -1.0f, 0.0f, 0.0f);
        IIcon aIcon = this.getIcon(ForgeDirection.WEST.ordinal(), aX, aY, aZ, aRenderer);
        new LightingHelper(aRenderer).setupLightingXNeg(aBlock, aX, aY, aZ).setupColor(ForgeDirection.WEST, this.mBlock.func_149720_d((IBlockAccess)this.getBlockAccess(aRenderer), aX, aY, aZ));
        aRenderer.func_147798_e(aBlock, (double)aX, (double)aY, (double)aZ, aIcon);
        this.draw(aRenderer);
    }

    @Override
    public void renderYPos(RenderBlocks aRenderer, Block aBlock, int aX, int aY, int aZ) {
        this.startDrawingQuads(aRenderer, 0.0f, 1.0f, 0.0f);
        IIcon aIcon = this.getIcon(ForgeDirection.UP.ordinal(), aX, aY, aZ, aRenderer);
        new LightingHelper(aRenderer).setupLightingYPos(aBlock, aX, aY, aZ).setupColor(ForgeDirection.UP, this.mBlock.func_149720_d((IBlockAccess)this.getBlockAccess(aRenderer), aX, aY, aZ));
        aRenderer.func_147806_b(aBlock, (double)aX, (double)aY, (double)aZ, aIcon);
        this.draw(aRenderer);
    }

    @Override
    public void renderYNeg(RenderBlocks aRenderer, Block aBlock, int aX, int aY, int aZ) {
        this.startDrawingQuads(aRenderer, 0.0f, -1.0f, 0.0f);
        IIcon aIcon = this.getIcon(ForgeDirection.DOWN.ordinal(), aX, aY, aZ, aRenderer);
        new LightingHelper(aRenderer).setupLightingYNeg(aBlock, aX, aY, aZ).setupColor(ForgeDirection.DOWN, this.mBlock.func_149720_d((IBlockAccess)this.getBlockAccess(aRenderer), aX, aY, aZ));
        aRenderer.func_147768_a(aBlock, (double)aX, (double)aY, (double)aZ, aIcon);
        this.draw(aRenderer);
    }

    @Override
    public void renderZPos(RenderBlocks aRenderer, Block aBlock, int aX, int aY, int aZ) {
        this.startDrawingQuads(aRenderer, 0.0f, 0.0f, 1.0f);
        IIcon aIcon = this.getIcon(ForgeDirection.SOUTH.ordinal(), aX, aY, aZ, aRenderer);
        new LightingHelper(aRenderer).setupLightingZPos(aBlock, aX, aY, aZ).setupColor(ForgeDirection.SOUTH, this.mBlock.func_149720_d((IBlockAccess)this.getBlockAccess(aRenderer), aX, aY, aZ));
        aRenderer.func_147734_d(aBlock, (double)aX, (double)aY, (double)aZ, aIcon);
        this.draw(aRenderer);
    }

    @Override
    public void renderZNeg(RenderBlocks aRenderer, Block aBlock, int aX, int aY, int aZ) {
        this.startDrawingQuads(aRenderer, 0.0f, 0.0f, -1.0f);
        IIcon aIcon = this.getIcon(ForgeDirection.NORTH.ordinal(), aX, aY, aZ, aRenderer);
        aRenderer.field_152631_f = true;
        new LightingHelper(aRenderer).setupLightingZNeg(aBlock, aX, aY, aZ).setupColor(ForgeDirection.NORTH, this.mBlock.func_149720_d((IBlockAccess)this.getBlockAccess(aRenderer), aX, aY, aZ));
        aRenderer.func_147761_c(aBlock, (double)aX, (double)aY, (double)aZ, aIcon);
        this.draw(aRenderer);
        aRenderer.field_152631_f = false;
    }

    @Override
    public boolean isValidTexture() {
        return this.mBlock != null;
    }

    @Override
    public Block getBlock() {
        return this.mBlock;
    }

    @Override
    public byte getMeta() {
        return this.mMeta;
    }
}

