/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.blocks;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import gregtech.api.enums.HeatingCoilLevel;
import gregtech.api.enums.ItemList;
import gregtech.api.enums.Textures;
import gregtech.api.interfaces.IHeatingCoil;
import gregtech.api.util.GT_LanguageManager;
import gregtech.common.blocks.GT_Block_Casings_Abstract;
import gregtech.common.blocks.GT_Item_Casings5;
import gregtech.common.blocks.GT_Material_Casings;
import java.util.function.Consumer;
import net.minecraft.block.Block;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIcon;

public class GT_Block_Casings5
extends GT_Block_Casings_Abstract
implements IHeatingCoil {
    private Consumer<IHeatingCoil> callback = coil -> {};

    public GT_Block_Casings5() {
        super(GT_Item_Casings5.class, "gt.blockcasings5", GT_Material_Casings.INSTANCE, 16);
        GT_LanguageManager.addStringLocalization(this.func_149739_a() + ".0.name", "Cupronickel Coil Block");
        GT_LanguageManager.addStringLocalization(this.func_149739_a() + ".1.name", "Kanthal Coil Block");
        GT_LanguageManager.addStringLocalization(this.func_149739_a() + ".2.name", "Nichrome Coil Block");
        GT_LanguageManager.addStringLocalization(this.func_149739_a() + ".3.name", "TPV-Alloy Coil Block");
        GT_LanguageManager.addStringLocalization(this.func_149739_a() + ".4.name", "HSS-G Coil Block");
        GT_LanguageManager.addStringLocalization(this.func_149739_a() + ".5.name", "Naquadah Coil Block");
        GT_LanguageManager.addStringLocalization(this.func_149739_a() + ".6.name", "Naquadah Alloy Coil Block");
        GT_LanguageManager.addStringLocalization(this.func_149739_a() + ".7.name", "Electrum Flux Coil Block");
        GT_LanguageManager.addStringLocalization(this.func_149739_a() + ".8.name", "Awakened Draconium Coil Block");
        GT_LanguageManager.addStringLocalization(this.func_149739_a() + ".9.name", "HSS-S Coil Block");
        GT_LanguageManager.addStringLocalization(this.func_149739_a() + ".10.name", "Trinium Coil Block");
        GT_LanguageManager.addStringLocalization(this.func_149739_a() + ".11.name", "Infinity Coil Block");
        GT_LanguageManager.addStringLocalization(this.func_149739_a() + ".12.name", "Hypogen Coil Block");
        GT_LanguageManager.addStringLocalization(this.func_149739_a() + ".13.name", "Eternal Coil Block");
        ItemList.Casing_Coil_Cupronickel.set(new ItemStack((Block)this, 1, 0));
        ItemList.Casing_Coil_Kanthal.set(new ItemStack((Block)this, 1, 1));
        ItemList.Casing_Coil_Nichrome.set(new ItemStack((Block)this, 1, 2));
        ItemList.Casing_Coil_TungstenSteel.set(new ItemStack((Block)this, 1, 3));
        ItemList.Casing_Coil_HSSG.set(new ItemStack((Block)this, 1, 4));
        ItemList.Casing_Coil_Naquadah.set(new ItemStack((Block)this, 1, 5));
        ItemList.Casing_Coil_NaquadahAlloy.set(new ItemStack((Block)this, 1, 6));
        ItemList.Casing_Coil_ElectrumFlux.set(new ItemStack((Block)this, 1, 7));
        ItemList.Casing_Coil_AwakenedDraconium.set(new ItemStack((Block)this, 1, 8));
        ItemList.Casing_Coil_HSSS.set(new ItemStack((Block)this, 1, 9));
        ItemList.Casing_Coil_Trinium.set(new ItemStack((Block)this, 1, 10));
        ItemList.Casing_Coil_Infinity.set(new ItemStack((Block)this, 1, 11));
        ItemList.Casing_Coil_Hypogen.set(new ItemStack((Block)this, 1, 12));
        ItemList.Casing_Coil_Eternal.set(new ItemStack((Block)this, 1, 13));
    }

    @Override
    public int getTextureIndex(int aMeta) {
        return 0x80 | aMeta;
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_149691_a(int ordinalSide, int aMeta) {
        IIcon iIcon;
        switch (aMeta) {
            case 0: {
                iIcon = Textures.BlockIcons.MACHINE_COIL_CUPRONICKEL.getIcon();
                break;
            }
            case 1: {
                iIcon = Textures.BlockIcons.MACHINE_COIL_KANTHAL.getIcon();
                break;
            }
            case 2: {
                iIcon = Textures.BlockIcons.MACHINE_COIL_NICHROME.getIcon();
                break;
            }
            case 3: {
                iIcon = Textures.BlockIcons.MACHINE_COIL_TUNGSTENSTEEL.getIcon();
                break;
            }
            case 4: {
                iIcon = Textures.BlockIcons.MACHINE_COIL_HSSG.getIcon();
                break;
            }
            case 5: {
                iIcon = Textures.BlockIcons.MACHINE_COIL_NAQUADAH.getIcon();
                break;
            }
            case 6: {
                iIcon = Textures.BlockIcons.MACHINE_COIL_NAQUADAHALLOY.getIcon();
                break;
            }
            case 7: {
                iIcon = Textures.BlockIcons.MACHINE_COIL_ELECTRUMFLUX.getIcon();
                break;
            }
            case 8: {
                iIcon = Textures.BlockIcons.MACHINE_COIL_AWAKENEDDRACONIUM.getIcon();
                break;
            }
            case 9: {
                iIcon = Textures.BlockIcons.MACHINE_COIL_HSSS.getIcon();
                break;
            }
            case 10: {
                iIcon = Textures.BlockIcons.MACHINE_COIL_TRINIUM.getIcon();
                break;
            }
            case 11: {
                iIcon = Textures.BlockIcons.MACHINE_COIL_INFINITY.getIcon();
                break;
            }
            case 12: {
                iIcon = Textures.BlockIcons.MACHINE_COIL_HYPOGEN.getIcon();
                break;
            }
            case 13: {
                iIcon = Textures.BlockIcons.MACHINE_COIL_ETERNAL.getIcon();
                break;
            }
            default: {
                iIcon = Textures.BlockIcons.MACHINE_COIL_CUPRONICKEL.getIcon();
            }
        }
        return iIcon;
    }

    public static HeatingCoilLevel getCoilHeatFromDamage(int meta) {
        HeatingCoilLevel heatingCoilLevel;
        switch (meta) {
            case 0: {
                heatingCoilLevel = HeatingCoilLevel.LV;
                break;
            }
            case 1: {
                heatingCoilLevel = HeatingCoilLevel.MV;
                break;
            }
            case 2: {
                heatingCoilLevel = HeatingCoilLevel.HV;
                break;
            }
            case 3: {
                heatingCoilLevel = HeatingCoilLevel.EV;
                break;
            }
            case 4: {
                heatingCoilLevel = HeatingCoilLevel.IV;
                break;
            }
            case 5: {
                heatingCoilLevel = HeatingCoilLevel.ZPM;
                break;
            }
            case 6: {
                heatingCoilLevel = HeatingCoilLevel.UV;
                break;
            }
            case 7: {
                heatingCoilLevel = HeatingCoilLevel.UEV;
                break;
            }
            case 8: {
                heatingCoilLevel = HeatingCoilLevel.UIV;
                break;
            }
            case 9: {
                heatingCoilLevel = HeatingCoilLevel.LuV;
                break;
            }
            case 10: {
                heatingCoilLevel = HeatingCoilLevel.UHV;
                break;
            }
            case 11: {
                heatingCoilLevel = HeatingCoilLevel.UMV;
                break;
            }
            case 12: {
                heatingCoilLevel = HeatingCoilLevel.UXV;
                break;
            }
            case 13: {
                heatingCoilLevel = HeatingCoilLevel.MAX;
                break;
            }
            default: {
                heatingCoilLevel = HeatingCoilLevel.None;
            }
        }
        return heatingCoilLevel;
    }

    public static int getMetaFromCoilHeat(HeatingCoilLevel level) {
        int n;
        switch (level) {
            case LV: {
                n = 0;
                break;
            }
            case MV: {
                n = 1;
                break;
            }
            case HV: {
                n = 2;
                break;
            }
            case EV: {
                n = 3;
                break;
            }
            case IV: {
                n = 4;
                break;
            }
            case ZPM: {
                n = 5;
                break;
            }
            case UV: {
                n = 6;
                break;
            }
            case UEV: {
                n = 7;
                break;
            }
            case UIV: {
                n = 8;
                break;
            }
            case LuV: {
                n = 9;
                break;
            }
            case UHV: {
                n = 10;
                break;
            }
            case UMV: {
                n = 11;
                break;
            }
            case UXV: {
                n = 12;
                break;
            }
            case MAX: {
                n = 13;
                break;
            }
            default: {
                n = 0;
            }
        }
        return n;
    }

    @Override
    public HeatingCoilLevel getCoilHeat(int meta) {
        this.getOnCoilCheck().accept(this);
        return GT_Block_Casings5.getCoilHeatFromDamage(meta);
    }

    @Override
    public void setOnCoilCheck(Consumer<IHeatingCoil> callback) {
        this.callback = callback;
    }

    @Override
    public Consumer<IHeatingCoil> getOnCoilCheck() {
        return this.callback;
    }
}

