/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.util;

import gregtech.api.interfaces.IGT_RecipeMap;
import gregtech.api.util.GT_Log;
import gregtech.api.util.GT_OreDictUnificator;
import gregtech.api.util.GT_Recipe;
import gregtech.api.util.GT_RecipeConstants;
import gregtech.api.util.GT_Utility;
import gregtech.api.util.extensions.ArrayExt;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import javax.annotation.Nonnull;
import net.minecraft.item.ItemStack;
import net.minecraft.launchwrapper.Launch;
import net.minecraftforge.fluids.FluidStack;

public class GT_RecipeBuilder {
    private static final boolean DEBUG_MODE = System.getProperties().containsKey("gt.recipebuilder.debug") ? Boolean.getBoolean("gt.recipebuilder.debug") : (Boolean)Launch.blackboard.get("fml.deobfuscatedEnvironment");
    private static final boolean PANIC_MODE = DEBUG_MODE && Boolean.getBoolean("gt.recipebuilder.panic");
    public static final int WILDCARD = Short.MAX_VALUE;
    public static final int HOURS = 72000;
    public static final int MINUTES = 1200;
    public static final int SECONDS = 20;
    public static final int TICKS = 1;
    public static final int INGOTS = 144;
    public static final int HALF_INGOT = 72;
    public static final int QUARTER_INGOT = 36;
    public static final int EIGHTH_INGOT = 18;
    public static final int NUGGETS = 16;
    public static final int BUCKETS = 1000;
    protected ItemStack[] inputsBasic;
    protected Object[] inputsOreDict;
    protected ItemStack[] outputs;
    protected ItemStack[][] alts;
    protected FluidStack[] fluidInputs;
    protected FluidStack[] fluidOutputs;
    protected int[] chances;
    protected Object special;
    protected int duration = -1;
    protected int eut = -1;
    protected int specialValue;
    protected boolean enabled = true;
    protected boolean hidden = false;
    protected boolean fakeRecipe = false;
    protected boolean mCanBeBuffered = true;
    protected boolean mNeedsEmptyOutput = false;
    protected String[] neiDesc;
    protected boolean optimize = true;
    protected Map<MetadataIdentifier<?>, Object> additionalData = new HashMap();
    protected boolean valid = true;

    GT_RecipeBuilder() {
    }

    private GT_RecipeBuilder(ItemStack[] inputsBasic, Object[] inputsOreDict, ItemStack[] outputs, ItemStack[][] alts, FluidStack[] fluidInputs, FluidStack[] fluidOutputs, int[] chances, Object special, int duration, int eut, int specialValue, boolean enabled, boolean hidden, boolean fakeRecipe, boolean mCanBeBuffered, boolean mNeedsEmptyOutput, String[] neiDesc, boolean optimize, Map<MetadataIdentifier<?>, Object> additionalData, boolean valid) {
        this.inputsBasic = inputsBasic;
        this.inputsOreDict = inputsOreDict;
        this.outputs = outputs;
        this.alts = alts;
        this.fluidInputs = fluidInputs;
        this.fluidOutputs = fluidOutputs;
        this.chances = chances;
        this.special = special;
        this.duration = duration;
        this.eut = eut;
        this.specialValue = specialValue;
        this.enabled = enabled;
        this.hidden = hidden;
        this.fakeRecipe = fakeRecipe;
        this.mCanBeBuffered = mCanBeBuffered;
        this.mNeedsEmptyOutput = mNeedsEmptyOutput;
        this.neiDesc = neiDesc;
        this.optimize = optimize;
        this.additionalData.putAll(additionalData);
        this.valid = valid;
    }

    private static FluidStack[] fix(FluidStack[] fluidInputs) {
        return (FluidStack[])Arrays.stream(fluidInputs).filter(Objects::nonNull).map(FluidStack::copy).toArray(FluidStack[]::new);
    }

    private static ItemStack[] fix(ItemStack[] inputs) {
        return GT_OreDictUnificator.setStackArray(true, ArrayExt.withoutTrailingNulls(inputs, ItemStack[]::new));
    }

    public static GT_RecipeBuilder builder() {
        return new GT_RecipeBuilder();
    }

    private static boolean containsNull(Object[] arr) {
        return arr == null || Arrays.stream(arr).anyMatch(Objects::isNull);
    }

    private static void handleNullRecipeComponents(String componentType) {
        if (PANIC_MODE) {
            throw new IllegalArgumentException("null in argument");
        }
        GT_Log.err.print("null detected in ");
        GT_Log.err.println(componentType);
        new NullPointerException().printStackTrace(GT_Log.err);
    }

    private static void handleInvalidRecipe() {
        if (!PANIC_MODE && !DEBUG_MODE) {
            return;
        }
        GT_Log.err.print("invalid recipe");
        new IllegalArgumentException().printStackTrace(GT_Log.err);
        if (PANIC_MODE) {
            throw new IllegalArgumentException("invalid recipe");
        }
    }

    public static void handleRecipeCollision(String details) {
        if (!PANIC_MODE && !DEBUG_MODE) {
            return;
        }
        GT_Log.err.print("Recipe collision resulting in recipe loss detected with ");
        GT_Log.err.println(details);
        if (PANIC_MODE) {
            throw new IllegalArgumentException("Recipe Collision");
        }
        new IllegalArgumentException().printStackTrace(GT_Log.err);
    }

    public GT_RecipeBuilder itemInputsUnified(ItemStack ... inputs) {
        if (DEBUG_MODE && GT_RecipeBuilder.containsNull(inputs)) {
            GT_RecipeBuilder.handleNullRecipeComponents("itemInputUnified");
        }
        this.inputsBasic = ArrayExt.withoutTrailingNulls(inputs, ItemStack[]::new);
        this.inputsOreDict = null;
        this.alts = null;
        return this;
    }

    public GT_RecipeBuilder itemInputs(ItemStack ... inputs) {
        if (DEBUG_MODE && GT_RecipeBuilder.containsNull(inputs)) {
            GT_RecipeBuilder.handleNullRecipeComponents("itemInputs");
        }
        this.inputsBasic = GT_RecipeBuilder.fix(inputs);
        this.inputsOreDict = null;
        this.alts = null;
        return this;
    }

    public GT_RecipeBuilder itemInputs(Object ... inputs) {
        this.inputsOreDict = inputs;
        this.alts = new ItemStack[inputs.length][];
        int inputsLength = inputs.length;
        for (int i = 0; i < inputsLength; ++i) {
            Object input = inputs[i];
            if (input instanceof ItemStack) {
                this.alts[i] = new ItemStack[]{(ItemStack)input};
                continue;
            }
            if (input instanceof ItemStack[]) {
                this.alts[i] = (ItemStack[])((ItemStack[])input).clone();
                continue;
            }
            if (input instanceof Object[]) {
                ArrayList<ItemStack> ores;
                Object[] arr = (Object[])input;
                if (arr.length != 2 || (ores = GT_OreDictUnificator.getOres(arr[0])).isEmpty()) continue;
                int size = ((Number)arr[1]).intValue();
                this.alts[i] = (ItemStack[])ores.stream().map(s -> GT_Utility.copyAmount((long)size, s)).filter(GT_Utility::isStackValid).toArray(ItemStack[]::new);
                continue;
            }
            if (input == null) {
                GT_RecipeBuilder.handleNullRecipeComponents("recipe oredict input");
                this.alts[i] = new ItemStack[0];
                continue;
            }
            throw new IllegalArgumentException("index " + i + ", unexpected type: " + input.getClass());
        }
        this.inputsBasic = (ItemStack[])Arrays.stream(this.alts).map(ss -> ((ItemStack[])ss).length > 0 ? ss[0] : null).toArray(ItemStack[]::new);
        return this.noOptimize();
    }

    public GT_RecipeBuilder noItemInputs() {
        this.inputsBasic = new ItemStack[0];
        this.inputsOreDict = null;
        this.alts = null;
        return this;
    }

    public GT_RecipeBuilder itemOutputs(ItemStack ... outputs) {
        if (DEBUG_MODE && GT_RecipeBuilder.containsNull(outputs)) {
            GT_RecipeBuilder.handleNullRecipeComponents("itemOutputs");
        }
        this.outputs = outputs;
        if (this.chances != null && this.chances.length != outputs.length) {
            throw new IllegalArgumentException("Output chances array and items array length differs");
        }
        return this;
    }

    public GT_RecipeBuilder itemOutputs(ItemStack[] outputs, int[] chances) {
        if (DEBUG_MODE && GT_RecipeBuilder.containsNull(outputs)) {
            GT_RecipeBuilder.handleNullRecipeComponents("itemOutputs");
        }
        this.outputs = outputs;
        this.chances = chances;
        if (chances != null && chances.length != outputs.length) {
            throw new IllegalArgumentException("Output chances array and items array length differs");
        }
        return this;
    }

    public GT_RecipeBuilder noItemOutputs() {
        return this.itemOutputs(new ItemStack[0]);
    }

    public GT_RecipeBuilder fluidInputs(FluidStack ... fluidInputs) {
        if (DEBUG_MODE && GT_RecipeBuilder.containsNull(fluidInputs)) {
            GT_RecipeBuilder.handleNullRecipeComponents("fluidInputs");
        }
        this.fluidInputs = GT_RecipeBuilder.fix(fluidInputs);
        return this;
    }

    public GT_RecipeBuilder noFluidInputs() {
        return this.fluidInputs == null ? this.fluidInputs(new FluidStack[0]) : this;
    }

    public GT_RecipeBuilder fluidOutputs(FluidStack ... fluidOutputs) {
        if (DEBUG_MODE && GT_RecipeBuilder.containsNull(fluidOutputs)) {
            GT_RecipeBuilder.handleNullRecipeComponents("fluidOutputs");
        }
        this.fluidOutputs = GT_RecipeBuilder.fix(fluidOutputs);
        return this;
    }

    public GT_RecipeBuilder noFluidOutputs() {
        return this.fluidOutputs(new FluidStack[0]);
    }

    public GT_RecipeBuilder noOutputs() {
        return this.noFluidOutputs().noItemOutputs();
    }

    public GT_RecipeBuilder outputChances(int ... chances) {
        if (this.outputs != null && chances.length != this.outputs.length) {
            throw new IllegalArgumentException("Output chances array and items array length differs");
        }
        this.chances = chances;
        return this;
    }

    public GT_RecipeBuilder special(Object special) {
        this.special = special;
        return this;
    }

    public GT_RecipeBuilder specialItem(ItemStack specialItem) {
        return this.special(specialItem);
    }

    public GT_RecipeBuilder duration(int duration) {
        this.duration = duration;
        return this;
    }

    public GT_RecipeBuilder duration(long duration) {
        this.duration = (int)duration;
        return this;
    }

    public GT_RecipeBuilder eut(int eut) {
        this.eut = eut;
        return this;
    }

    public GT_RecipeBuilder eut(long eut) {
        this.eut = (int)eut;
        return this;
    }

    public GT_RecipeBuilder specialValue(int specialValue) {
        this.specialValue = specialValue;
        return this;
    }

    public GT_RecipeBuilder disabled() {
        this.enabled = false;
        return this;
    }

    public GT_RecipeBuilder hidden() {
        this.hidden = true;
        return this;
    }

    public GT_RecipeBuilder fake() {
        this.fakeRecipe = true;
        return this;
    }

    public GT_RecipeBuilder noBuffer() {
        this.mCanBeBuffered = false;
        return this;
    }

    public GT_RecipeBuilder needsEmptyOutput() {
        this.mNeedsEmptyOutput = true;
        return this;
    }

    public GT_RecipeBuilder setNEIDesc(String ... neiDesc) {
        this.neiDesc = neiDesc;
        return this;
    }

    public GT_RecipeBuilder noOptimize() {
        this.optimize = false;
        return this;
    }

    public <T> GT_RecipeBuilder metadata(MetadataIdentifier<T> key, T value) {
        this.additionalData.put(key, value);
        return this;
    }

    public <T> T getMetadata(MetadataIdentifier<T> key) {
        return key.cast(this.additionalData.get(key));
    }

    public <T> T getMetadata(MetadataIdentifier<T> key, T defaultValue) {
        return key.cast(this.additionalData.getOrDefault(key, defaultValue));
    }

    public GT_RecipeBuilder requiresCleanRoom() {
        return this.metadata(GT_RecipeConstants.CLEANROOM, true);
    }

    public GT_RecipeBuilder requiresLowGravity() {
        return this.metadata(GT_RecipeConstants.LOW_GRAVITY, true);
    }

    private static <T> T[] copy(T[] arr) {
        return arr == null ? null : (Object[])arr.clone();
    }

    private static int[] copy(int[] arr) {
        return arr == null ? null : (int[])arr.clone();
    }

    public GT_RecipeBuilder copy() {
        return new GT_RecipeBuilder(GT_Utility.copyItemArray(this.inputsBasic), GT_RecipeBuilder.copy(this.inputsOreDict), GT_Utility.copyItemArray(this.outputs), (ItemStack[][])GT_RecipeBuilder.copy(this.alts), GT_Utility.copyFluidArray(this.fluidInputs), GT_Utility.copyFluidArray(this.fluidOutputs), GT_RecipeBuilder.copy(this.chances), this.special, this.duration, this.eut, this.specialValue, this.enabled, this.hidden, this.fakeRecipe, this.mCanBeBuffered, this.mNeedsEmptyOutput, GT_RecipeBuilder.copy(this.neiDesc), this.optimize, this.additionalData, this.valid);
    }

    public GT_RecipeBuilder copyNoMetadata() {
        return new GT_RecipeBuilder(GT_Utility.copyItemArray(this.inputsBasic), GT_RecipeBuilder.copy(this.inputsOreDict), GT_Utility.copyItemArray(this.outputs), (ItemStack[][])GT_RecipeBuilder.copy(this.alts), GT_Utility.copyFluidArray(this.fluidInputs), GT_Utility.copyFluidArray(this.fluidOutputs), GT_RecipeBuilder.copy(this.chances), this.special, this.duration, this.eut, this.specialValue, this.enabled, this.hidden, this.fakeRecipe, this.mCanBeBuffered, this.mNeedsEmptyOutput, GT_RecipeBuilder.copy(this.neiDesc), this.optimize, Collections.emptyMap(), this.valid);
    }

    public ItemStack getItemInputBasic(int index) {
        return index < this.inputsBasic.length ? this.inputsBasic[index] : null;
    }

    public Object getItemInputOreDict(int index) {
        return index < this.inputsOreDict.length ? this.inputsOreDict[index] : null;
    }

    public ItemStack getItemOutput(int index) {
        return index < this.outputs.length ? this.outputs[index] : null;
    }

    public FluidStack getFluidInput(int index) {
        return index < this.fluidInputs.length ? this.fluidInputs[index] : null;
    }

    public FluidStack getFluidOutput(int index) {
        return index < this.fluidOutputs.length ? this.fluidOutputs[index] : null;
    }

    public ItemStack[] getItemInputsBasic() {
        return this.inputsBasic;
    }

    public Object[] getItemInputsOreDict() {
        return this.inputsOreDict;
    }

    public ItemStack[] getItemOutputs() {
        return this.outputs;
    }

    public FluidStack[] getFluidInputs() {
        return this.fluidInputs;
    }

    public FluidStack[] getFluidOutputs() {
        return this.fluidOutputs;
    }

    public int getDuration() {
        return this.duration;
    }

    public int[] getChances() {
        return this.chances;
    }

    public int getEUt() {
        return this.eut;
    }

    public GT_RecipeBuilder clearInvalid() {
        this.valid = true;
        return this;
    }

    public GT_RecipeBuilder invalidate() {
        this.valid = false;
        return this;
    }

    public boolean isValid() {
        return this.valid;
    }

    private static boolean isArrayValid(@Nonnull Object[] arr, int min, int max) {
        int count = 0;
        for (Object o : arr) {
            if (o == null) continue;
            ++count;
        }
        return min <= count && max >= count;
    }

    public GT_RecipeBuilder validateNoInput() {
        return GT_Utility.isArrayEmptyOrNull(this.inputsBasic) ? this.noItemInputs() : this.invalidate();
    }

    public GT_RecipeBuilder validateNoInputFluid() {
        return GT_Utility.isArrayEmptyOrNull(this.fluidInputs) ? this.noFluidInputs() : this.invalidate();
    }

    public GT_RecipeBuilder validateNoOutput() {
        return GT_Utility.isArrayEmptyOrNull(this.outputs) ? this.noItemInputs() : this.invalidate();
    }

    public GT_RecipeBuilder validateNoOutputFluid() {
        return GT_Utility.isArrayEmptyOrNull(this.fluidOutputs) ? this.noFluidOutputs() : this.invalidate();
    }

    public GT_RecipeBuilder validateInputCount(int min, int max) {
        if (this.inputsBasic == null) {
            return min < 0 ? this.noItemInputs() : this.invalidate();
        }
        return GT_RecipeBuilder.isArrayValid(this.inputsBasic, min, max) ? this : this.invalidate();
    }

    public GT_RecipeBuilder validateInputFluidCount(int min, int max) {
        if (this.fluidInputs == null) {
            return min < 0 ? this.noItemInputs() : this.invalidate();
        }
        return GT_RecipeBuilder.isArrayValid(this.fluidInputs, min, max) ? this : this.invalidate();
    }

    public GT_RecipeBuilder validateOutputCount(int min, int max) {
        if (this.outputs == null) {
            return min < 0 ? this.noItemInputs() : this.invalidate();
        }
        return GT_RecipeBuilder.isArrayValid(this.outputs, min, max) ? this : this.invalidate();
    }

    public GT_RecipeBuilder validateOutputFluidCount(int min, int max) {
        if (this.fluidOutputs == null) {
            return min < 0 ? this.noItemInputs() : this.invalidate();
        }
        return GT_RecipeBuilder.isArrayValid(this.fluidOutputs, min, max) ? this : this.invalidate();
    }

    public GT_RecipeBuilder validateAnyInput() {
        if (this.fluidInputs != null && GT_RecipeBuilder.isArrayValid(this.fluidInputs, 1, Integer.MAX_VALUE)) {
            return this.inputsBasic == null ? this.noItemInputs() : this;
        }
        if (this.inputsBasic != null && GT_RecipeBuilder.isArrayValid(this.inputsBasic, 1, Integer.MAX_VALUE)) {
            return this.fluidInputs == null ? this.noFluidInputs() : this;
        }
        return this.invalidate();
    }

    public GT_RecipeBuilder validateAnyOutput() {
        if (this.fluidOutputs != null && GT_RecipeBuilder.isArrayValid(this.fluidOutputs, 1, Integer.MAX_VALUE)) {
            return this.outputs == null ? this.noItemOutputs() : this;
        }
        if (this.outputs != null && GT_RecipeBuilder.isArrayValid(this.outputs, 1, Integer.MAX_VALUE)) {
            return this.fluidOutputs == null ? this.noFluidOutputs() : this;
        }
        return this.invalidate();
    }

    public Optional<GT_Recipe> build() {
        if (!this.valid) {
            if (DEBUG_MODE) {
                GT_RecipeBuilder.handleInvalidRecipe();
            }
            return Optional.empty();
        }
        this.preBuildChecks();
        this.optimize();
        return Optional.of(this.decorate(new GT_Recipe(this.inputsBasic, this.outputs, this.fluidInputs, this.fluidOutputs, this.chances, this.special, this.duration, this.eut, this.specialValue, this.enabled, this.hidden, this.fakeRecipe, this.mCanBeBuffered, this.mNeedsEmptyOutput, this.neiDesc)));
    }

    public GT_RecipeBuilder forceOreDictInput() {
        if (this.inputsOreDict != null || this.inputsBasic == null) {
            return this;
        }
        return this.itemInputs((Object[])this.inputsBasic);
    }

    public Optional<GT_Recipe.GT_Recipe_WithAlt> buildWithAlt() {
        if (this.inputsOreDict == null) {
            throw new UnsupportedOperationException();
        }
        if (!this.valid) {
            if (DEBUG_MODE) {
                GT_RecipeBuilder.handleInvalidRecipe();
            }
            return Optional.empty();
        }
        this.preBuildChecks();
        return Optional.of(this.decorate(new GT_Recipe.GT_Recipe_WithAlt(this.inputsBasic, this.outputs, this.fluidInputs, this.fluidOutputs, this.chances, this.special, this.duration, this.eut, this.specialValue, this.enabled, this.hidden, this.fakeRecipe, this.mCanBeBuffered, this.mNeedsEmptyOutput, this.neiDesc, this.alts)));
    }

    private void preBuildChecks() {
        if (this.inputsBasic == null) {
            throw new IllegalStateException("no itemInputs");
        }
        if (this.outputs == null) {
            throw new IllegalStateException("no itemOutputs");
        }
        if (this.fluidInputs == null) {
            throw new IllegalStateException("no fluidInputs");
        }
        if (this.fluidOutputs == null) {
            throw new IllegalStateException("no fluidOutputs");
        }
        if (this.duration == -1) {
            throw new IllegalStateException("no duration");
        }
        if (this.eut == -1) {
            throw new IllegalStateException("no eut");
        }
    }

    private void optimize() {
        if (this.optimize) {
            int i;
            ArrayList<ItemStack> l = new ArrayList<ItemStack>();
            l.addAll(Arrays.asList(this.inputsBasic));
            l.addAll(Arrays.asList(this.outputs));
            for (i = 0; i < l.size(); ++i) {
                if (l.get(i) != null) continue;
                l.remove(i--);
            }
            block1: for (i = (int)((byte)Math.min(64, this.duration / 16)); i > 1; i = (int)((byte)(i - 1))) {
                if (this.duration / i < 16) continue;
                for (ItemStack stack : l) {
                    if (stack.field_77994_a % i == 0) continue;
                    continue block1;
                }
                for (Object fluidInput : this.fluidInputs) {
                    if (fluidInput.amount % i != 0) continue block1;
                }
                for (Object fluidOutput : this.fluidOutputs) {
                    if (fluidOutput.amount % i != 0) continue block1;
                }
                for (ItemStack itemStack : l) {
                    itemStack.field_77994_a /= i;
                }
                for (Object fluidInput : this.fluidInputs) {
                    fluidInput.amount /= i;
                }
                for (Object fluidOutput : this.fluidOutputs) {
                    fluidOutput.amount /= i;
                }
                this.duration /= i;
            }
            this.optimize = false;
        }
    }

    private <T extends GT_Recipe> T decorate(T r) {
        r.mHidden = this.hidden;
        r.mCanBeBuffered = this.mCanBeBuffered;
        r.mNeedsEmptyOutput = this.mNeedsEmptyOutput;
        r.mFakeRecipe = this.fakeRecipe;
        r.mEnabled = this.enabled;
        if (this.neiDesc != null) {
            r.setNeiDesc(this.neiDesc);
        }
        return r;
    }

    public Collection<GT_Recipe> addTo(IGT_RecipeMap recipeMap) {
        return recipeMap.doAdd(this);
    }

    public GT_RecipeBuilder reset() {
        this.additionalData.clear();
        this.alts = null;
        this.chances = null;
        this.duration = -1;
        this.enabled = true;
        this.eut = -1;
        this.fakeRecipe = false;
        this.fluidInputs = null;
        this.fluidOutputs = null;
        this.hidden = false;
        this.inputsBasic = null;
        this.inputsOreDict = null;
        this.mCanBeBuffered = true;
        this.mNeedsEmptyOutput = false;
        this.neiDesc = null;
        this.optimize = true;
        this.outputs = null;
        this.special = null;
        this.specialValue = 0;
        this.valid = true;
        return this;
    }

    public static final class MetadataIdentifier<T> {
        private static final Map<MetadataIdentifier<?>, MetadataIdentifier<?>> allIdentifiers = Collections.synchronizedMap(new HashMap());
        private final Class<T> clazz;
        private final String identifier;

        private MetadataIdentifier(Class<T> clazz, String identifier) {
            this.clazz = clazz;
            this.identifier = identifier;
        }

        public static <T> MetadataIdentifier<T> create(Class<T> clazz, String identifier) {
            MetadataIdentifier<T> key = new MetadataIdentifier<T>(clazz, identifier);
            return allIdentifiers.computeIfAbsent(key, Function.identity());
        }

        public T cast(Object o) {
            return this.clazz.cast(o);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            MetadataIdentifier that = (MetadataIdentifier)o;
            if (!this.clazz.equals(that.clazz)) {
                return false;
            }
            return this.identifier.equals(that.identifier);
        }

        public int hashCode() {
            int result = this.clazz.hashCode();
            result = 31 * result + this.identifier.hashCode();
            return result;
        }
    }
}

